/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.ai.vision.imageanalysis.models.DetectedTextWord;
import com.azure.ai.vision.imageanalysis.models.ImagePoint;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DetectedTextLine
implements JsonSerializable<DetectedTextLine> {
    private final String text;
    private final List<ImagePoint> boundingPolygon;
    private final List<DetectedTextWord> words;

    private DetectedTextLine(String text, List<ImagePoint> boundingPolygon, List<DetectedTextWord> words) {
        this.text = text;
        this.boundingPolygon = boundingPolygon;
        this.words = words;
    }

    public String getText() {
        return this.text;
    }

    public List<ImagePoint> getBoundingPolygon() {
        return this.boundingPolygon;
    }

    public List<DetectedTextWord> getWords() {
        return this.words;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("boundingPolygon", this.boundingPolygon, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("words", this.words, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static DetectedTextLine fromJson(JsonReader jsonReader) throws IOException {
        return (DetectedTextLine)jsonReader.readObject(reader -> {
            String text = null;
            List boundingPolygon = null;
            List words = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("boundingPolygon".equals(fieldName)) {
                    boundingPolygon = reader.readArray(reader1 -> ImagePoint.fromJson(reader1));
                    continue;
                }
                if ("words".equals(fieldName)) {
                    words = reader.readArray(reader1 -> DetectedTextWord.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return new DetectedTextLine(text, boundingPolygon, words);
        });
    }
}

