/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImageBoundingBox
implements JsonSerializable<ImageBoundingBox> {
    private final int x;
    private final int y;
    private final int width;
    private final int height;

    private ImageBoundingBox(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return "{x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("x", this.x);
        jsonWriter.writeIntField("y", this.y);
        jsonWriter.writeIntField("w", this.width);
        jsonWriter.writeIntField("h", this.height);
        return jsonWriter.writeEndObject();
    }

    public static ImageBoundingBox fromJson(JsonReader jsonReader) throws IOException {
        return (ImageBoundingBox)jsonReader.readObject(reader -> {
            int x = 0;
            int y = 0;
            int width = 0;
            int height = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x".equals(fieldName)) {
                    x = reader.getInt();
                    continue;
                }
                if ("y".equals(fieldName)) {
                    y = reader.getInt();
                    continue;
                }
                if ("w".equals(fieldName)) {
                    width = reader.getInt();
                    continue;
                }
                if ("h".equals(fieldName)) {
                    height = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new ImageBoundingBox(x, y, width, height);
        });
    }
}

