/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis;

import com.azure.ai.vision.imageanalysis.ImageAnalysisClient;
import com.azure.ai.vision.imageanalysis.ImageAnalysisClientBuilder;
import com.azure.ai.vision.imageanalysis.implementation.ImageAnalysisClientImpl;
import com.azure.ai.vision.imageanalysis.implementation.models.ImageUrl;
import com.azure.ai.vision.imageanalysis.models.ImageAnalysisOptions;
import com.azure.ai.vision.imageanalysis.models.ImageAnalysisResult;
import com.azure.ai.vision.imageanalysis.models.VisualFeatures;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ImageAnalysisClientBuilder.class, isAsync=true)
public final class ImageAnalysisAsyncClient {
    private final ImageAnalysisClientImpl serviceClient;

    ImageAnalysisAsyncClient(ImageAnalysisClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> analyzeFromUrlWithResponse(List<String> visualFeatures, BinaryData imageUrl, RequestOptions requestOptions) {
        return this.serviceClient.analyzeFromUrlWithResponseAsync(visualFeatures, imageUrl, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<ImageAnalysisResult> analyzeFromUrl(List<VisualFeatures> visualFeatures, ImageUrl imageUrl, String language, Boolean genderNeutralCaption, List<Double> smartCropsAspectRatios, String modelVersion) {
        RequestOptions requestOptions = new RequestOptions();
        if (language != null) {
            requestOptions.addQueryParam("language", language, false);
        }
        if (genderNeutralCaption != null) {
            requestOptions.addQueryParam("gender-neutral-caption", String.valueOf(genderNeutralCaption), false);
        }
        if (smartCropsAspectRatios != null) {
            requestOptions.addQueryParam("smartcrops-aspect-ratios", JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(smartCropsAspectRatios, CollectionFormat.CSV), false);
        }
        if (modelVersion != null) {
            requestOptions.addQueryParam("model-version", modelVersion, false);
        }
        return this.analyzeFromUrlWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), BinaryData.fromObject((Object)imageUrl), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ImageAnalysisResult)protocolMethodData.toObject(ImageAnalysisResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<ImageAnalysisResult> analyzeFromUrl(List<VisualFeatures> visualFeatures, ImageUrl imageUrl) {
        RequestOptions requestOptions = new RequestOptions();
        return this.analyzeFromUrlWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), BinaryData.fromObject((Object)imageUrl), requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ImageAnalysisResult)protocolMethodData.toObject(ImageAnalysisResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<Response<BinaryData>> analyzeFromImageDataWithResponse(List<String> visualFeatures, BinaryData imageData, RequestOptions requestOptions) {
        return this.serviceClient.analyzeFromImageDataWithResponseAsync(visualFeatures, imageData, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<ImageAnalysisResult> analyzeFromImageData(List<VisualFeatures> visualFeatures, BinaryData imageData, String language, Boolean genderNeutralCaption, List<Double> smartCropsAspectRatios, String modelVersion) {
        RequestOptions requestOptions = new RequestOptions();
        if (language != null) {
            requestOptions.addQueryParam("language", language, false);
        }
        if (genderNeutralCaption != null) {
            requestOptions.addQueryParam("gender-neutral-caption", String.valueOf(genderNeutralCaption), false);
        }
        if (smartCropsAspectRatios != null) {
            requestOptions.addQueryParam("smartcrops-aspect-ratios", JacksonAdapter.createDefaultSerializerAdapter().serializeIterable(smartCropsAspectRatios, CollectionFormat.CSV), false);
        }
        if (modelVersion != null) {
            requestOptions.addQueryParam("model-version", modelVersion, false);
        }
        return this.analyzeFromImageDataWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), imageData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ImageAnalysisResult)protocolMethodData.toObject(ImageAnalysisResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    Mono<ImageAnalysisResult> analyzeFromImageData(List<VisualFeatures> visualFeatures, BinaryData imageData) {
        RequestOptions requestOptions = new RequestOptions();
        return this.analyzeFromImageDataWithResponse(visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList()), imageData, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (ImageAnalysisResult)protocolMethodData.toObject(ImageAnalysisResult.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ImageAnalysisResult> analyzeFromUrl(String imageUrl, List<VisualFeatures> visualFeatures, ImageAnalysisOptions options) {
        return this.analyzeFromUrlWithResponse(imageUrl, visualFeatures, options, null).map(response -> (ImageAnalysisResult)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ImageAnalysisResult> analyze(BinaryData imageData, List<VisualFeatures> visualFeatures, ImageAnalysisOptions options) {
        return this.analyzeWithResponse(imageData, visualFeatures, options, null).map(response -> (ImageAnalysisResult)response.getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ImageAnalysisResult>> analyzeFromUrlWithResponse(String imageUrl, List<VisualFeatures> visualFeatures, ImageAnalysisOptions imageAnalysisOptions, RequestOptions requestOptions) {
        List<String> visualFeaturesAsStrings = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList());
        Mono<Response<BinaryData>> monoResponse = this.analyzeFromUrlWithResponse(visualFeaturesAsStrings, BinaryData.fromObject((Object)new ImageUrl(imageUrl)), ImageAnalysisClient.updateRequestOptions(requestOptions, imageAnalysisOptions));
        return monoResponse.map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((ImageAnalysisResult)((BinaryData)response.getValue()).toObject(ImageAnalysisResult.class))));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ImageAnalysisResult>> analyzeWithResponse(BinaryData imageData, List<VisualFeatures> visualFeatures, ImageAnalysisOptions imageAnalysisOptions, RequestOptions requestOptions) {
        List<String> visualFeaturesAsStrings = visualFeatures.stream().map(paramItemValue -> Objects.toString(paramItemValue, "")).collect(Collectors.toList());
        Mono<Response<BinaryData>> monoResponse = this.analyzeFromImageDataWithResponse(visualFeaturesAsStrings, imageData, ImageAnalysisClient.updateRequestOptions(requestOptions, imageAnalysisOptions));
        return monoResponse.map(response -> new SimpleResponse(response.getRequest(), response.getStatusCode(), response.getHeaders(), (Object)((ImageAnalysisResult)((BinaryData)response.getValue()).toObject(ImageAnalysisResult.class))));
    }
}

