/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.vision.imageanalysis.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ImagePoint
implements JsonSerializable<ImagePoint> {
    private final int x;
    private final int y;

    private ImagePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public String toString() {
        return "(x=" + this.getX() + ", y=" + this.getY() + ")";
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("x", this.x);
        jsonWriter.writeIntField("y", this.y);
        return jsonWriter.writeEndObject();
    }

    public static ImagePoint fromJson(JsonReader jsonReader) throws IOException {
        return (ImagePoint)jsonReader.readObject(reader -> {
            int x = 0;
            int y = 0;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("x".equals(fieldName)) {
                    x = reader.getInt();
                    continue;
                }
                if ("y".equals(fieldName)) {
                    y = reader.getInt();
                    continue;
                }
                reader.skipChildren();
            }
            return new ImagePoint(x, y);
        });
    }
}

