/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.LibrariesImpl;
import com.azure.analytics.synapse.artifacts.models.LibraryResource;
import com.azure.analytics.synapse.artifacts.models.LibraryResourceInfo;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=ArtifactsClientBuilder.class, isAsync=true)
public final class LibraryAsyncClient {
    private final LibrariesImpl serviceClient;

    LibraryAsyncClient(LibrariesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LibraryResource> list() {
        return this.serviceClient.listAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> flushWithResponse(String libraryName) {
        return this.serviceClient.flushWithResponseAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> flush(String libraryName) {
        return this.serviceClient.flushAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResource>> getOperationResultWithResponse(String operationId) {
        return this.serviceClient.getOperationResultWithResponseAsync(operationId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResource> getOperationResult(String operationId) {
        return this.serviceClient.getOperationResultAsync(operationId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> deleteWithResponse(String libraryName) {
        return this.serviceClient.deleteWithResponseAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> delete(String libraryName) {
        return this.serviceClient.deleteAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResource>> getWithResponse(String libraryName) {
        return this.serviceClient.getWithResponseAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResource> get(String libraryName) {
        return this.serviceClient.getAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> createWithResponse(String libraryName) {
        return this.serviceClient.createWithResponseAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> create(String libraryName) {
        return this.serviceClient.createAsync(libraryName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponse(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition) {
        return this.serviceClient.appendWithResponseAsync(libraryName, content, contentLength, blobConditionAppendPosition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> append(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition) {
        return this.serviceClient.appendAsync(libraryName, content, contentLength, blobConditionAppendPosition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> append(String libraryName, Flux<ByteBuffer> content, long contentLength) {
        return this.serviceClient.appendAsync(libraryName, content, contentLength);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponse(String libraryName, BinaryData content, long contentLength, Long blobConditionAppendPosition) {
        return this.serviceClient.appendWithResponseAsync(libraryName, content, contentLength, blobConditionAppendPosition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> append(String libraryName, BinaryData content, long contentLength, Long blobConditionAppendPosition) {
        return this.serviceClient.appendAsync(libraryName, content, contentLength, blobConditionAppendPosition);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> append(String libraryName, BinaryData content, long contentLength) {
        return this.serviceClient.appendAsync(libraryName, content, contentLength);
    }
}

