/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.BigDataPoolResourceInfo;
import com.azure.analytics.synapse.artifacts.models.BigDataPoolResourceInfoListResult;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class BigDataPoolsImpl {
    private final BigDataPoolsService service;
    private final ArtifactsClientImpl client;

    BigDataPoolsImpl(ArtifactsClientImpl client) {
        this.service = (BigDataPoolsService)RestProxy.create(BigDataPoolsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BigDataPoolResourceInfoListResult>> listWithResponseAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BigDataPoolResourceInfoListResult>> listWithResponseAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BigDataPoolResourceInfoListResult> listAsync() {
        return this.listWithResponseAsync().flatMap(res -> Mono.justOrEmpty((Object)((BigDataPoolResourceInfoListResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BigDataPoolResourceInfoListResult> listAsync(Context context) {
        return this.listWithResponseAsync(context).flatMap(res -> Mono.justOrEmpty((Object)((BigDataPoolResourceInfoListResult)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BigDataPoolResourceInfoListResult> listWithResponse(Context context) {
        return (Response)this.listWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BigDataPoolResourceInfoListResult list() {
        return (BigDataPoolResourceInfoListResult)this.listWithResponse(Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BigDataPoolResourceInfo>> getWithResponseAsync(String bigDataPoolName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2020-12-01", bigDataPoolName, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BigDataPoolResourceInfo>> getWithResponseAsync(String bigDataPoolName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), "2020-12-01", bigDataPoolName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BigDataPoolResourceInfo> getAsync(String bigDataPoolName) {
        return this.getWithResponseAsync(bigDataPoolName).flatMap(res -> Mono.justOrEmpty((Object)((BigDataPoolResourceInfo)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BigDataPoolResourceInfo> getAsync(String bigDataPoolName, Context context) {
        return this.getWithResponseAsync(bigDataPoolName, context).flatMap(res -> Mono.justOrEmpty((Object)((BigDataPoolResourceInfo)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BigDataPoolResourceInfo> getWithResponse(String bigDataPoolName, Context context) {
        return (Response)this.getWithResponseAsync(bigDataPoolName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BigDataPoolResourceInfo get(String bigDataPoolName) {
        return (BigDataPoolResourceInfo)this.getWithResponse(bigDataPoolName, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientBigDa")
    public static interface BigDataPoolsService {
        @Get(value="/bigDataPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<BigDataPoolResourceInfoListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/bigDataPools/{bigDataPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<BigDataPoolResourceInfo>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="bigDataPoolName") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

