/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.EditTablesRequest;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionDetailedStatus;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionListResponse;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionQueryTableStatus;
import com.azure.analytics.synapse.artifacts.models.LinkConnectionResource;
import com.azure.analytics.synapse.artifacts.models.LinkTableListResponse;
import com.azure.analytics.synapse.artifacts.models.QueryTableStatusRequest;
import com.azure.analytics.synapse.artifacts.models.UpdateLandingZoneCredential;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class LinkConnectionsImpl {
    private final LinkConnectionsService service;
    private final ArtifactsClientImpl client;

    LinkConnectionsImpl(ArtifactsClientImpl client) {
        this.service = (LinkConnectionsService)RestProxy.create(LinkConnectionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkConnectionResource>> listByWorkspaceSinglePageAsync() {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspace(this.client.getEndpoint(), "2023-04-18-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkConnectionListResponse)res.getValue()).getValue(), ((LinkConnectionListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkConnectionResource>> listByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.listByWorkspace(this.client.getEndpoint(), "2023-04-18-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkConnectionListResponse)res.getValue()).getValue(), ((LinkConnectionListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LinkConnectionResource> listByWorkspaceAsync() {
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LinkConnectionResource> listByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.listByWorkspaceSinglePageAsync(context), nextLink -> this.listByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<LinkConnectionResource> listByWorkspaceSinglePage() {
        return (PagedResponse)this.listByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<LinkConnectionResource> listByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.listByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkConnectionResource> listByWorkspace() {
        return new PagedIterable(this.listByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkConnectionResource> listByWorkspace(Context context) {
        return new PagedIterable(this.listByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionResource>> createOrUpdateWithResponseAsync(String linkConnectionName, LinkConnectionResource linkConnection) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", linkConnection, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionResource>> createOrUpdateWithResponseAsync(String linkConnectionName, LinkConnectionResource linkConnection, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.createOrUpdate(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", linkConnection, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionResource> createOrUpdateAsync(String linkConnectionName, LinkConnectionResource linkConnection) {
        return this.createOrUpdateWithResponseAsync(linkConnectionName, linkConnection).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionResource> createOrUpdateAsync(String linkConnectionName, LinkConnectionResource linkConnection, Context context) {
        return this.createOrUpdateWithResponseAsync(linkConnectionName, linkConnection, context).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionResource> createOrUpdateWithResponse(String linkConnectionName, LinkConnectionResource linkConnection, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(linkConnectionName, linkConnection, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionResource createOrUpdate(String linkConnectionName, LinkConnectionResource linkConnection) {
        return (LinkConnectionResource)this.createOrUpdateWithResponse(linkConnectionName, linkConnection, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionResource>> getWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionResource>> getWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionResource> getAsync(String linkConnectionName) {
        return this.getWithResponseAsync(linkConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionResource> getAsync(String linkConnectionName, Context context) {
        return this.getWithResponseAsync(linkConnectionName, context).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionResource> getWithResponse(String linkConnectionName, Context context) {
        return (Response)this.getWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionResource get(String linkConnectionName) {
        return (LinkConnectionResource)this.getWithResponse(linkConnectionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.delete(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String linkConnectionName) {
        return this.deleteWithResponseAsync(linkConnectionName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String linkConnectionName, Context context) {
        return this.deleteWithResponseAsync(linkConnectionName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String linkConnectionName, Context context) {
        return (Response)this.deleteWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String linkConnectionName) {
        this.deleteWithResponse(linkConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> editTablesWithResponseAsync(String linkConnectionName, EditTablesRequest editTablesRequest) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.editTables(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", editTablesRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> editTablesWithResponseAsync(String linkConnectionName, EditTablesRequest editTablesRequest, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.editTables(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", editTablesRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> editTablesAsync(String linkConnectionName, EditTablesRequest editTablesRequest) {
        return this.editTablesWithResponseAsync(linkConnectionName, editTablesRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> editTablesAsync(String linkConnectionName, EditTablesRequest editTablesRequest, Context context) {
        return this.editTablesWithResponseAsync(linkConnectionName, editTablesRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> editTablesWithResponse(String linkConnectionName, EditTablesRequest editTablesRequest, Context context) {
        return (Response)this.editTablesWithResponseAsync(linkConnectionName, editTablesRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void editTables(String linkConnectionName, EditTablesRequest editTablesRequest) {
        this.editTablesWithResponse(linkConnectionName, editTablesRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.start(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> startWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.start(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String linkConnectionName) {
        return this.startWithResponseAsync(linkConnectionName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> startAsync(String linkConnectionName, Context context) {
        return this.startWithResponseAsync(linkConnectionName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startWithResponse(String linkConnectionName, Context context) {
        return (Response)this.startWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void start(String linkConnectionName) {
        this.startWithResponse(linkConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.stop(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> stopWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.stop(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopAsync(String linkConnectionName) {
        return this.stopWithResponseAsync(linkConnectionName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> stopAsync(String linkConnectionName, Context context) {
        return this.stopWithResponseAsync(linkConnectionName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopWithResponse(String linkConnectionName, Context context) {
        return (Response)this.stopWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stop(String linkConnectionName) {
        this.stopWithResponse(linkConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionDetailedStatus>> getDetailedStatusWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getDetailedStatus(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionDetailedStatus>> getDetailedStatusWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.getDetailedStatus(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionDetailedStatus> getDetailedStatusAsync(String linkConnectionName) {
        return this.getDetailedStatusWithResponseAsync(linkConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionDetailedStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionDetailedStatus> getDetailedStatusAsync(String linkConnectionName, Context context) {
        return this.getDetailedStatusWithResponseAsync(linkConnectionName, context).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionDetailedStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionDetailedStatus> getDetailedStatusWithResponse(String linkConnectionName, Context context) {
        return (Response)this.getDetailedStatusWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionDetailedStatus getDetailedStatus(String linkConnectionName) {
        return (LinkConnectionDetailedStatus)this.getDetailedStatusWithResponse(linkConnectionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkTableListResponse>> listLinkTablesWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listLinkTables(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkTableListResponse>> listLinkTablesWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.listLinkTables(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkTableListResponse> listLinkTablesAsync(String linkConnectionName) {
        return this.listLinkTablesWithResponseAsync(linkConnectionName).flatMap(res -> Mono.justOrEmpty((Object)((LinkTableListResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkTableListResponse> listLinkTablesAsync(String linkConnectionName, Context context) {
        return this.listLinkTablesWithResponseAsync(linkConnectionName, context).flatMap(res -> Mono.justOrEmpty((Object)((LinkTableListResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkTableListResponse> listLinkTablesWithResponse(String linkConnectionName, Context context) {
        return (Response)this.listLinkTablesWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkTableListResponse listLinkTables(String linkConnectionName) {
        return (LinkTableListResponse)this.listLinkTablesWithResponse(linkConnectionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionQueryTableStatus>> queryTableStatusWithResponseAsync(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryTableStatus(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", queryTableStatusRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkConnectionQueryTableStatus>> queryTableStatusWithResponseAsync(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.queryTableStatus(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", queryTableStatusRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionQueryTableStatus> queryTableStatusAsync(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest) {
        return this.queryTableStatusWithResponseAsync(linkConnectionName, queryTableStatusRequest).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionQueryTableStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkConnectionQueryTableStatus> queryTableStatusAsync(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest, Context context) {
        return this.queryTableStatusWithResponseAsync(linkConnectionName, queryTableStatusRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((LinkConnectionQueryTableStatus)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkConnectionQueryTableStatus> queryTableStatusWithResponse(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest, Context context) {
        return (Response)this.queryTableStatusWithResponseAsync(linkConnectionName, queryTableStatusRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkConnectionQueryTableStatus queryTableStatus(String linkConnectionName, QueryTableStatusRequest queryTableStatusRequest) {
        return (LinkConnectionQueryTableStatus)this.queryTableStatusWithResponse(linkConnectionName, queryTableStatusRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateLandingZoneCredentialWithResponseAsync(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateLandingZoneCredential(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", updateLandingZoneCredentialRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> updateLandingZoneCredentialWithResponseAsync(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.updateLandingZoneCredential(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", updateLandingZoneCredentialRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateLandingZoneCredentialAsync(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest) {
        return this.updateLandingZoneCredentialWithResponseAsync(linkConnectionName, updateLandingZoneCredentialRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> updateLandingZoneCredentialAsync(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest, Context context) {
        return this.updateLandingZoneCredentialWithResponseAsync(linkConnectionName, updateLandingZoneCredentialRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> updateLandingZoneCredentialWithResponse(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest, Context context) {
        return (Response)this.updateLandingZoneCredentialWithResponseAsync(linkConnectionName, updateLandingZoneCredentialRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void updateLandingZoneCredential(String linkConnectionName, UpdateLandingZoneCredential updateLandingZoneCredentialRequest) {
        this.updateLandingZoneCredentialWithResponse(linkConnectionName, updateLandingZoneCredentialRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.pause(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> pauseWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.pause(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseAsync(String linkConnectionName) {
        return this.pauseWithResponseAsync(linkConnectionName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> pauseAsync(String linkConnectionName, Context context) {
        return this.pauseWithResponseAsync(linkConnectionName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> pauseWithResponse(String linkConnectionName, Context context) {
        return (Response)this.pauseWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void pause(String linkConnectionName) {
        this.pauseWithResponse(linkConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeWithResponseAsync(String linkConnectionName) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.resume(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resumeWithResponseAsync(String linkConnectionName, Context context) {
        String apiVersion = "2023-04-18-preview";
        String accept = "application/json";
        return this.service.resume(this.client.getEndpoint(), linkConnectionName, "2023-04-18-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeAsync(String linkConnectionName) {
        return this.resumeWithResponseAsync(linkConnectionName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resumeAsync(String linkConnectionName, Context context) {
        return this.resumeWithResponseAsync(linkConnectionName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resumeWithResponse(String linkConnectionName, Context context) {
        return (Response)this.resumeWithResponseAsync(linkConnectionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resume(String linkConnectionName) {
        this.resumeWithResponse(linkConnectionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkConnectionResource>> listByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkConnectionListResponse)res.getValue()).getValue(), ((LinkConnectionListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkConnectionResource>> listByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkConnectionListResponse)res.getValue()).getValue(), ((LinkConnectionListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<LinkConnectionResource> listByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.listByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<LinkConnectionResource> listByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.listByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientLinkC")
    public static interface LinkConnectionsService {
        @Get(value="/linkconnections")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkConnectionListResponse>> listByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/linkconnections/{linkConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkConnectionResource>> createOrUpdate(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") LinkConnectionResource var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/linkconnections/{linkConnectionName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkConnectionResource>> get(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/linkconnections/{linkConnectionName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/linkconnections/{linkConnectionName}/edittables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> editTables(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") EditTablesRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/linkconnections/{linkConnectionName}/start")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> start(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/linkconnections/{linkConnectionName}/stop")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> stop(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/linkconnections/{linkConnectionName}/detailedstatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkConnectionDetailedStatus>> getDetailedStatus(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/linkconnections/{linkConnectionName}/linktables")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkTableListResponse>> listLinkTables(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/linkconnections/{linkConnectionName}/querytablestatus")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkConnectionQueryTableStatus>> queryTableStatus(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") QueryTableStatusRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/linkconnections/{linkConnectionName}/updateLandingZoneCredential")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> updateLandingZoneCredential(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") UpdateLandingZoneCredential var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/linkconnections/{linkConnectionName}/pause")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> pause(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/linkconnections/{linkConnectionName}/resume")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> resume(@HostParam(value="endpoint") String var1, @PathParam(value="linkConnectionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<LinkConnectionListResponse>> listByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

