/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class NotebookOperationResultsImpl {
    private final NotebookOperationResultsService service;
    private final ArtifactsClientImpl client;

    NotebookOperationResultsImpl(ArtifactsClientImpl client) {
        this.service = (NotebookOperationResultsService)RestProxy.create(NotebookOperationResultsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getWithResponseAsync(String operationId) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2020-12-01", operationId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> getWithResponseAsync(String operationId, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), "2020-12-01", operationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAsync(String operationId) {
        return this.getWithResponseAsync(operationId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> getAsync(String operationId, Context context) {
        return this.getWithResponseAsync(operationId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> getWithResponse(String operationId, Context context) {
        return (Response)this.getWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void get(String operationId) {
        this.getWithResponse(operationId, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientNoteb")
    public static interface NotebookOperationResultsService {
        @Get(value="/notebookOperationResults/{operationId}")
        @ExpectedResponses(value={200, 201, 202, 204})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<Void>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="operationId") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

