/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.NotebookListResponse;
import com.azure.analytics.synapse.artifacts.models.NotebookResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class NotebooksImpl {
    private final NotebooksService service;
    private final ArtifactsClientImpl client;

    NotebooksImpl(ArtifactsClientImpl client) {
        this.service = (NotebooksService)RestProxy.create(NotebooksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebooksByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNotebooksByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebooksByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getNotebooksByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotebookResource> getNotebooksByWorkspaceAsync() {
        return new PagedFlux(() -> this.getNotebooksByWorkspaceSinglePageAsync(), nextLink -> this.getNotebooksByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotebookResource> getNotebooksByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getNotebooksByWorkspaceSinglePageAsync(context), nextLink -> this.getNotebooksByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebooksByWorkspaceSinglePage() {
        return (PagedResponse)this.getNotebooksByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebooksByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getNotebooksByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebooksByWorkspace() {
        return new PagedIterable(this.getNotebooksByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebooksByWorkspace(Context context) {
        return new PagedIterable(this.getNotebooksByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebookSummaryByWorkSpaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNotebookSummaryByWorkSpace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebookSummaryByWorkSpaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getNotebookSummaryByWorkSpace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotebookResource> getNotebookSummaryByWorkSpaceAsync() {
        return new PagedFlux(() -> this.getNotebookSummaryByWorkSpaceSinglePageAsync(), nextLink -> this.getNotebookSummaryByWorkSpaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<NotebookResource> getNotebookSummaryByWorkSpaceAsync(Context context) {
        return new PagedFlux(() -> this.getNotebookSummaryByWorkSpaceSinglePageAsync(context), nextLink -> this.getNotebookSummaryByWorkSpaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebookSummaryByWorkSpaceSinglePage() {
        return (PagedResponse)this.getNotebookSummaryByWorkSpaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebookSummaryByWorkSpaceSinglePage(Context context) {
        return (PagedResponse)this.getNotebookSummaryByWorkSpaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebookSummaryByWorkSpace() {
        return new PagedIterable(this.getNotebookSummaryByWorkSpaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebookSummaryByWorkSpace(Context context) {
        return new PagedIterable(this.getNotebookSummaryByWorkSpaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotebookResource>> createOrUpdateNotebookWithResponseAsync(String notebookName, NotebookResource notebook, String ifMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", ifMatch, notebook, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotebookResource>> createOrUpdateNotebookWithResponseAsync(String notebookName, NotebookResource notebook, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", ifMatch, notebook, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> createOrUpdateNotebookAsync(String notebookName, NotebookResource notebook, String ifMatch) {
        return this.createOrUpdateNotebookWithResponseAsync(notebookName, notebook, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((NotebookResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> createOrUpdateNotebookAsync(String notebookName, NotebookResource notebook) {
        String ifMatch = null;
        return this.createOrUpdateNotebookWithResponseAsync(notebookName, notebook, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((NotebookResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> createOrUpdateNotebookAsync(String notebookName, NotebookResource notebook, String ifMatch, Context context) {
        return this.createOrUpdateNotebookWithResponseAsync(notebookName, notebook, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((NotebookResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotebookResource> createOrUpdateNotebookWithResponse(String notebookName, NotebookResource notebook, String ifMatch, Context context) {
        return (Response)this.createOrUpdateNotebookWithResponseAsync(notebookName, notebook, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource createOrUpdateNotebook(String notebookName, NotebookResource notebook, String ifMatch) {
        return (NotebookResource)this.createOrUpdateNotebookWithResponse(notebookName, notebook, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource createOrUpdateNotebook(String notebookName, NotebookResource notebook) {
        String ifMatch = null;
        return (NotebookResource)this.createOrUpdateNotebookWithResponse(notebookName, notebook, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotebookResource>> getNotebookWithResponseAsync(String notebookName, String ifNoneMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", ifNoneMatch, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<NotebookResource>> getNotebookWithResponseAsync(String notebookName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> getNotebookAsync(String notebookName, String ifNoneMatch) {
        return this.getNotebookWithResponseAsync(notebookName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((NotebookResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> getNotebookAsync(String notebookName) {
        String ifNoneMatch = null;
        return this.getNotebookWithResponseAsync(notebookName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((NotebookResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<NotebookResource> getNotebookAsync(String notebookName, String ifNoneMatch, Context context) {
        return this.getNotebookWithResponseAsync(notebookName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((NotebookResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotebookResource> getNotebookWithResponse(String notebookName, String ifNoneMatch, Context context) {
        return (Response)this.getNotebookWithResponseAsync(notebookName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource getNotebook(String notebookName, String ifNoneMatch) {
        return (NotebookResource)this.getNotebookWithResponse(notebookName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource getNotebook(String notebookName) {
        String ifNoneMatch = null;
        return (NotebookResource)this.getNotebookWithResponse(notebookName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNotebookWithResponseAsync(String notebookName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteNotebookWithResponseAsync(String notebookName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNotebookAsync(String notebookName) {
        return this.deleteNotebookWithResponseAsync(notebookName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteNotebookAsync(String notebookName, Context context) {
        return this.deleteNotebookWithResponseAsync(notebookName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNotebookWithResponse(String notebookName, Context context) {
        return (Response)this.deleteNotebookWithResponseAsync(notebookName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNotebook(String notebookName) {
        this.deleteNotebookWithResponse(notebookName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNotebookWithResponseAsync(String notebookName, ArtifactRenameRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renameNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameNotebookWithResponseAsync(String notebookName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renameNotebook(this.client.getEndpoint(), notebookName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameNotebookAsync(String notebookName, ArtifactRenameRequest request) {
        return this.renameNotebookWithResponseAsync(notebookName, request).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameNotebookAsync(String notebookName, ArtifactRenameRequest request, Context context) {
        return this.renameNotebookWithResponseAsync(notebookName, request, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameNotebookWithResponse(String notebookName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameNotebookWithResponseAsync(notebookName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameNotebook(String notebookName, ArtifactRenameRequest request) {
        this.renameNotebookWithResponse(notebookName, request, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebooksByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNotebooksByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebooksByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getNotebooksByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebooksByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getNotebooksByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebooksByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getNotebooksByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebookSummaryByWorkSpaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getNotebookSummaryByWorkSpaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<NotebookResource>> getNotebookSummaryByWorkSpaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getNotebookSummaryByWorkSpaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((NotebookListResponse)res.getValue()).getValue(), ((NotebookListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebookSummaryByWorkSpaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getNotebookSummaryByWorkSpaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<NotebookResource> getNotebookSummaryByWorkSpaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getNotebookSummaryByWorkSpaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientNoteb")
    public static interface NotebooksService {
        @Get(value="/notebooks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<NotebookListResponse>> getNotebooksByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/notebooksSummary")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<NotebookListResponse>> getNotebookSummaryByWorkSpace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/notebooks/{notebookName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<NotebookResource>> createOrUpdateNotebook(@HostParam(value="endpoint") String var1, @PathParam(value="notebookName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") NotebookResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/notebooks/{notebookName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<NotebookResource>> getNotebook(@HostParam(value="endpoint") String var1, @PathParam(value="notebookName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/notebooks/{notebookName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteNotebook(@HostParam(value="endpoint") String var1, @PathParam(value="notebookName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/notebooks/{notebookName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renameNotebook(@HostParam(value="endpoint") String var1, @PathParam(value="notebookName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<NotebookListResponse>> getNotebooksByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<NotebookListResponse>> getNotebookSummaryByWorkSpaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

