/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.CreateRunResponse;
import com.azure.analytics.synapse.artifacts.models.PipelineListResponse;
import com.azure.analytics.synapse.artifacts.models.PipelineResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.util.Map;
import reactor.core.publisher.Mono;

public final class PipelinesImpl {
    private final PipelinesService service;
    private final ArtifactsClientImpl client;

    PipelinesImpl(ArtifactsClientImpl client) {
        this.service = (PipelinesService)RestProxy.create(PipelinesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PipelineResource>> getPipelinesByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPipelinesByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).getValue(), ((PipelineListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PipelineResource>> getPipelinesByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getPipelinesByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).getValue(), ((PipelineListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PipelineResource> getPipelinesByWorkspaceAsync() {
        return new PagedFlux(() -> this.getPipelinesByWorkspaceSinglePageAsync(), nextLink -> this.getPipelinesByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<PipelineResource> getPipelinesByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getPipelinesByWorkspaceSinglePageAsync(context), nextLink -> this.getPipelinesByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PipelineResource> getPipelinesByWorkspaceSinglePage() {
        return (PagedResponse)this.getPipelinesByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PipelineResource> getPipelinesByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getPipelinesByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PipelineResource> getPipelinesByWorkspace() {
        return new PagedIterable(this.getPipelinesByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PipelineResource> getPipelinesByWorkspace(Context context) {
        return new PagedIterable(this.getPipelinesByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineResource>> createOrUpdatePipelineWithResponseAsync(String pipelineName, PipelineResource pipeline, String ifMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdatePipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", ifMatch, pipeline, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineResource>> createOrUpdatePipelineWithResponseAsync(String pipelineName, PipelineResource pipeline, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdatePipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", ifMatch, pipeline, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> createOrUpdatePipelineAsync(String pipelineName, PipelineResource pipeline, String ifMatch) {
        return this.createOrUpdatePipelineWithResponseAsync(pipelineName, pipeline, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((PipelineResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> createOrUpdatePipelineAsync(String pipelineName, PipelineResource pipeline) {
        String ifMatch = null;
        return this.createOrUpdatePipelineWithResponseAsync(pipelineName, pipeline, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((PipelineResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> createOrUpdatePipelineAsync(String pipelineName, PipelineResource pipeline, String ifMatch, Context context) {
        return this.createOrUpdatePipelineWithResponseAsync(pipelineName, pipeline, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((PipelineResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineResource> createOrUpdatePipelineWithResponse(String pipelineName, PipelineResource pipeline, String ifMatch, Context context) {
        return (Response)this.createOrUpdatePipelineWithResponseAsync(pipelineName, pipeline, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource createOrUpdatePipeline(String pipelineName, PipelineResource pipeline, String ifMatch) {
        return (PipelineResource)this.createOrUpdatePipelineWithResponse(pipelineName, pipeline, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource createOrUpdatePipeline(String pipelineName, PipelineResource pipeline) {
        String ifMatch = null;
        return (PipelineResource)this.createOrUpdatePipelineWithResponse(pipelineName, pipeline, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineResource>> getPipelineWithResponseAsync(String pipelineName, String ifNoneMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", ifNoneMatch, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineResource>> getPipelineWithResponseAsync(String pipelineName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getPipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> getPipelineAsync(String pipelineName, String ifNoneMatch) {
        return this.getPipelineWithResponseAsync(pipelineName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((PipelineResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> getPipelineAsync(String pipelineName) {
        String ifNoneMatch = null;
        return this.getPipelineWithResponseAsync(pipelineName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((PipelineResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineResource> getPipelineAsync(String pipelineName, String ifNoneMatch, Context context) {
        return this.getPipelineWithResponseAsync(pipelineName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((PipelineResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineResource> getPipelineWithResponse(String pipelineName, String ifNoneMatch, Context context) {
        return (Response)this.getPipelineWithResponseAsync(pipelineName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource getPipeline(String pipelineName, String ifNoneMatch) {
        return (PipelineResource)this.getPipelineWithResponse(pipelineName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource getPipeline(String pipelineName) {
        String ifNoneMatch = null;
        return (PipelineResource)this.getPipelineWithResponse(pipelineName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePipelineWithResponseAsync(String pipelineName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deletePipelineWithResponseAsync(String pipelineName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deletePipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePipelineAsync(String pipelineName) {
        return this.deletePipelineWithResponseAsync(pipelineName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deletePipelineAsync(String pipelineName, Context context) {
        return this.deletePipelineWithResponseAsync(pipelineName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePipelineWithResponse(String pipelineName, Context context) {
        return (Response)this.deletePipelineWithResponseAsync(pipelineName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePipeline(String pipelineName) {
        this.deletePipelineWithResponse(pipelineName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renamePipelineWithResponseAsync(String pipelineName, ArtifactRenameRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renamePipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renamePipelineWithResponseAsync(String pipelineName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renamePipeline(this.client.getEndpoint(), pipelineName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renamePipelineAsync(String pipelineName, ArtifactRenameRequest request) {
        return this.renamePipelineWithResponseAsync(pipelineName, request).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renamePipelineAsync(String pipelineName, ArtifactRenameRequest request, Context context) {
        return this.renamePipelineWithResponseAsync(pipelineName, request, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renamePipelineWithResponse(String pipelineName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renamePipelineWithResponseAsync(pipelineName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renamePipeline(String pipelineName, ArtifactRenameRequest request) {
        this.renamePipelineWithResponse(pipelineName, request, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateRunResponse>> createPipelineRunWithResponseAsync(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createPipelineRun(this.client.getEndpoint(), pipelineName, "2020-12-01", referencePipelineRunId, isRecovery, startActivityName, parameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CreateRunResponse>> createPipelineRunWithResponseAsync(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createPipelineRun(this.client.getEndpoint(), pipelineName, "2020-12-01", referencePipelineRunId, isRecovery, startActivityName, parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateRunResponse> createPipelineRunAsync(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters) {
        return this.createPipelineRunWithResponseAsync(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((CreateRunResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateRunResponse> createPipelineRunAsync(String pipelineName) {
        String referencePipelineRunId = null;
        Boolean isRecovery = null;
        String startActivityName = null;
        Map<String, Object> parameters = null;
        return this.createPipelineRunWithResponseAsync(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((CreateRunResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateRunResponse> createPipelineRunAsync(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters, Context context) {
        return this.createPipelineRunWithResponseAsync(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters, context).flatMap(res -> Mono.justOrEmpty((Object)((CreateRunResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateRunResponse> createPipelineRunWithResponse(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters, Context context) {
        return (Response)this.createPipelineRunWithResponseAsync(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateRunResponse createPipelineRun(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters) {
        return (CreateRunResponse)this.createPipelineRunWithResponse(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateRunResponse createPipelineRun(String pipelineName) {
        String referencePipelineRunId = null;
        Boolean isRecovery = null;
        String startActivityName = null;
        Map<String, Object> parameters = null;
        return (CreateRunResponse)this.createPipelineRunWithResponse(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PipelineResource>> getPipelinesByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPipelinesByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).getValue(), ((PipelineListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<PipelineResource>> getPipelinesByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getPipelinesByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((PipelineListResponse)res.getValue()).getValue(), ((PipelineListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PipelineResource> getPipelinesByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getPipelinesByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<PipelineResource> getPipelinesByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getPipelinesByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientPipel")
    public static interface PipelinesService {
        @Get(value="/pipelines")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PipelineListResponse>> getPipelinesByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PipelineResource>> createOrUpdatePipeline(@HostParam(value="endpoint") String var1, @PathParam(value="pipelineName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") PipelineResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PipelineResource>> getPipeline(@HostParam(value="endpoint") String var1, @PathParam(value="pipelineName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/pipelines/{pipelineName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deletePipeline(@HostParam(value="endpoint") String var1, @PathParam(value="pipelineName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/pipelines/{pipelineName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renamePipeline(@HostParam(value="endpoint") String var1, @PathParam(value="pipelineName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/pipelines/{pipelineName}/createRun")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<CreateRunResponse>> createPipelineRun(@HostParam(value="endpoint") String var1, @PathParam(value="pipelineName") String var2, @QueryParam(value="api-version") String var3, @QueryParam(value="referencePipelineRunId") String var4, @QueryParam(value="isRecovery") Boolean var5, @QueryParam(value="startActivityName") String var6, @BodyParam(value="application/json") Map<String, Object> var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<PipelineListResponse>> getPipelinesByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

