/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.RunNotebookRequest;
import com.azure.analytics.synapse.artifacts.models.RunNotebookResponse;
import com.azure.analytics.synapse.artifacts.models.RunNotebookResponseException;
import com.azure.analytics.synapse.artifacts.models.RunNotebookSnapshotResponse;
import com.azure.analytics.synapse.artifacts.models.RunNotebooksCreateRunResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.annotation.UnexpectedResponseExceptionTypes;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class RunNotebooksImpl {
    private final RunNotebooksService service;
    private final ArtifactsClientImpl client;

    RunNotebooksImpl(ArtifactsClientImpl client) {
        this.service = (RunNotebooksService)RestProxy.create(RunNotebooksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebooksCreateRunResponse> createRunWithResponseAsync(String runId, RunNotebookRequest runNotebookRequest) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRun(this.client.getEndpoint(), "2022-03-01-preview", runId, runNotebookRequest, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebooksCreateRunResponse> createRunWithResponseAsync(String runId, RunNotebookRequest runNotebookRequest, Context context) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return this.service.createRun(this.client.getEndpoint(), "2022-03-01-preview", runId, runNotebookRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> createRunAsync(String runId, RunNotebookRequest runNotebookRequest) {
        return this.createRunWithResponseAsync(runId, runNotebookRequest).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> createRunAsync(String runId, RunNotebookRequest runNotebookRequest, Context context) {
        return this.createRunWithResponseAsync(runId, runNotebookRequest, context).flatMap(res -> Mono.justOrEmpty((Object)res.getValue()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebooksCreateRunResponse createRunWithResponse(String runId, RunNotebookRequest runNotebookRequest, Context context) {
        return (RunNotebooksCreateRunResponse)((Object)this.createRunWithResponseAsync(runId, runNotebookRequest, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookResponse createRun(String runId, RunNotebookRequest runNotebookRequest) {
        return this.createRunWithResponse(runId, runNotebookRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> getStatusWithResponseAsync(String runId) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getStatus(this.client.getEndpoint(), "2022-03-01-preview", runId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> getStatusWithResponseAsync(String runId, Context context) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return this.service.getStatus(this.client.getEndpoint(), "2022-03-01-preview", runId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> getStatusAsync(String runId) {
        return this.getStatusWithResponseAsync(runId).flatMap(res -> Mono.justOrEmpty((Object)((RunNotebookResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> getStatusAsync(String runId, Context context) {
        return this.getStatusWithResponseAsync(runId, context).flatMap(res -> Mono.justOrEmpty((Object)((RunNotebookResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookResponse> getStatusWithResponse(String runId, Context context) {
        return (Response)this.getStatusWithResponseAsync(runId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookResponse getStatus(String runId) {
        return (RunNotebookResponse)this.getStatusWithResponse(runId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> cancelRunWithResponseAsync(String runId) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelRun(this.client.getEndpoint(), "2022-03-01-preview", runId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookResponse>> cancelRunWithResponseAsync(String runId, Context context) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return this.service.cancelRun(this.client.getEndpoint(), "2022-03-01-preview", runId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> cancelRunAsync(String runId) {
        return this.cancelRunWithResponseAsync(runId).flatMap(res -> Mono.justOrEmpty((Object)((RunNotebookResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookResponse> cancelRunAsync(String runId, Context context) {
        return this.cancelRunWithResponseAsync(runId, context).flatMap(res -> Mono.justOrEmpty((Object)((RunNotebookResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookResponse> cancelRunWithResponse(String runId, Context context) {
        return (Response)this.cancelRunWithResponseAsync(runId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookResponse cancelRun(String runId) {
        return (RunNotebookResponse)this.cancelRunWithResponse(runId, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookSnapshotResponse>> getSnapshotWithResponseAsync(String runId) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSnapshot(this.client.getEndpoint(), "2022-03-01-preview", runId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RunNotebookSnapshotResponse>> getSnapshotWithResponseAsync(String runId, Context context) {
        String apiVersion = "2022-03-01-preview";
        String accept = "application/json";
        return this.service.getSnapshot(this.client.getEndpoint(), "2022-03-01-preview", runId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookSnapshotResponse> getSnapshotAsync(String runId) {
        return this.getSnapshotWithResponseAsync(runId).flatMap(res -> Mono.justOrEmpty((Object)((RunNotebookSnapshotResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RunNotebookSnapshotResponse> getSnapshotAsync(String runId, Context context) {
        return this.getSnapshotWithResponseAsync(runId, context).flatMap(res -> Mono.justOrEmpty((Object)((RunNotebookSnapshotResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RunNotebookSnapshotResponse> getSnapshotWithResponse(String runId, Context context) {
        return (Response)this.getSnapshotWithResponseAsync(runId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public RunNotebookSnapshotResponse getSnapshot(String runId) {
        return (RunNotebookSnapshotResponse)this.getSnapshotWithResponse(runId, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientRunNo")
    public static interface RunNotebooksService {
        @Put(value="/notebooks/runs/{runId}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<RunNotebooksCreateRunResponse> createRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="runId") String var3, @BodyParam(value="application/json") RunNotebookRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="/notebooks/runs/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<RunNotebookResponse>> getStatus(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="runId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/notebooks/runs/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionTypes(value={@UnexpectedResponseExceptionType(value=RunNotebookResponseException.class, code={409}), @UnexpectedResponseExceptionType(value=CloudErrorException.class)})
        public Mono<Response<RunNotebookResponse>> cancelRun(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="runId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/notebooks/runs/{runId}/snapshot")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<RunNotebookSnapshotResponse>> getSnapshot(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="runId") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

