/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.SparkBatchJob;
import com.azure.analytics.synapse.artifacts.models.SparkJobDefinitionResource;
import com.azure.analytics.synapse.artifacts.models.SparkJobDefinitionsListResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SparkJobDefinitionsImpl {
    private final SparkJobDefinitionsService service;
    private final ArtifactsClientImpl client;

    SparkJobDefinitionsImpl(ArtifactsClientImpl client) {
        this.service = (SparkJobDefinitionsService)RestProxy.create(SparkJobDefinitionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkJobDefinitionResource>> getSparkJobDefinitionsByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkJobDefinitionsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkJobDefinitionsListResponse)res.getValue()).getValue(), ((SparkJobDefinitionsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkJobDefinitionResource>> getSparkJobDefinitionsByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getSparkJobDefinitionsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkJobDefinitionsListResponse)res.getValue()).getValue(), ((SparkJobDefinitionsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspaceAsync() {
        return new PagedFlux(() -> this.getSparkJobDefinitionsByWorkspaceSinglePageAsync(), nextLink -> this.getSparkJobDefinitionsByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getSparkJobDefinitionsByWorkspaceSinglePageAsync(context), nextLink -> this.getSparkJobDefinitionsByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspaceSinglePage() {
        return (PagedResponse)this.getSparkJobDefinitionsByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getSparkJobDefinitionsByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspace() {
        return new PagedIterable(this.getSparkJobDefinitionsByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspace(Context context) {
        return new PagedIterable(this.getSparkJobDefinitionsByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkJobDefinitionResource>> createOrUpdateSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", ifMatch, sparkJobDefinition, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkJobDefinitionResource>> createOrUpdateSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", ifMatch, sparkJobDefinition, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> createOrUpdateSparkJobDefinitionAsync(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch) {
        return this.createOrUpdateSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, sparkJobDefinition, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((SparkJobDefinitionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> createOrUpdateSparkJobDefinitionAsync(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition) {
        String ifMatch = null;
        return this.createOrUpdateSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, sparkJobDefinition, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((SparkJobDefinitionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> createOrUpdateSparkJobDefinitionAsync(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch, Context context) {
        return this.createOrUpdateSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, sparkJobDefinition, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((SparkJobDefinitionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkJobDefinitionResource> createOrUpdateSparkJobDefinitionWithResponse(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch, Context context) {
        return (Response)this.createOrUpdateSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, sparkJobDefinition, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource createOrUpdateSparkJobDefinition(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition, String ifMatch) {
        return (SparkJobDefinitionResource)this.createOrUpdateSparkJobDefinitionWithResponse(sparkJobDefinitionName, sparkJobDefinition, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource createOrUpdateSparkJobDefinition(String sparkJobDefinitionName, SparkJobDefinitionResource sparkJobDefinition) {
        String ifMatch = null;
        return (SparkJobDefinitionResource)this.createOrUpdateSparkJobDefinitionWithResponse(sparkJobDefinitionName, sparkJobDefinition, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkJobDefinitionResource>> getSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, String ifNoneMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", ifNoneMatch, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkJobDefinitionResource>> getSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> getSparkJobDefinitionAsync(String sparkJobDefinitionName, String ifNoneMatch) {
        return this.getSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((SparkJobDefinitionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> getSparkJobDefinitionAsync(String sparkJobDefinitionName) {
        String ifNoneMatch = null;
        return this.getSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((SparkJobDefinitionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkJobDefinitionResource> getSparkJobDefinitionAsync(String sparkJobDefinitionName, String ifNoneMatch, Context context) {
        return this.getSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((SparkJobDefinitionResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkJobDefinitionResource> getSparkJobDefinitionWithResponse(String sparkJobDefinitionName, String ifNoneMatch, Context context) {
        return (Response)this.getSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource getSparkJobDefinition(String sparkJobDefinitionName, String ifNoneMatch) {
        return (SparkJobDefinitionResource)this.getSparkJobDefinitionWithResponse(sparkJobDefinitionName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkJobDefinitionResource getSparkJobDefinition(String sparkJobDefinitionName) {
        String ifNoneMatch = null;
        return (SparkJobDefinitionResource)this.getSparkJobDefinitionWithResponse(sparkJobDefinitionName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSparkJobDefinitionAsync(String sparkJobDefinitionName) {
        return this.deleteSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSparkJobDefinitionAsync(String sparkJobDefinitionName, Context context) {
        return this.deleteSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSparkJobDefinitionWithResponse(String sparkJobDefinitionName, Context context) {
        return (Response)this.deleteSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSparkJobDefinition(String sparkJobDefinitionName) {
        this.deleteSparkJobDefinitionWithResponse(sparkJobDefinitionName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> executeSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.executeSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> executeSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.executeSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> executeSparkJobDefinitionAsync(String sparkJobDefinitionName) {
        return this.executeSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName).flatMap(res -> Mono.justOrEmpty((Object)((SparkBatchJob)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> executeSparkJobDefinitionAsync(String sparkJobDefinitionName, Context context) {
        return this.executeSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, context).flatMap(res -> Mono.justOrEmpty((Object)((SparkBatchJob)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> executeSparkJobDefinitionWithResponse(String sparkJobDefinitionName, Context context) {
        return (Response)this.executeSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob executeSparkJobDefinition(String sparkJobDefinitionName) {
        return (SparkBatchJob)this.executeSparkJobDefinitionWithResponse(sparkJobDefinitionName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, ArtifactRenameRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renameSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSparkJobDefinitionWithResponseAsync(String sparkJobDefinitionName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renameSparkJobDefinition(this.client.getEndpoint(), sparkJobDefinitionName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSparkJobDefinitionAsync(String sparkJobDefinitionName, ArtifactRenameRequest request) {
        return this.renameSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, request).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSparkJobDefinitionAsync(String sparkJobDefinitionName, ArtifactRenameRequest request, Context context) {
        return this.renameSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, request, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameSparkJobDefinitionWithResponse(String sparkJobDefinitionName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameSparkJobDefinitionWithResponseAsync(sparkJobDefinitionName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameSparkJobDefinition(String sparkJobDefinitionName, ArtifactRenameRequest request) {
        this.renameSparkJobDefinitionWithResponse(sparkJobDefinitionName, request, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> debugSparkJobDefinitionWithResponseAsync(SparkJobDefinitionResource sparkJobDefinitionAzureResource) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.debugSparkJobDefinition(this.client.getEndpoint(), "2020-12-01", sparkJobDefinitionAzureResource, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> debugSparkJobDefinitionWithResponseAsync(SparkJobDefinitionResource sparkJobDefinitionAzureResource, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.debugSparkJobDefinition(this.client.getEndpoint(), "2020-12-01", sparkJobDefinitionAzureResource, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> debugSparkJobDefinitionAsync(SparkJobDefinitionResource sparkJobDefinitionAzureResource) {
        return this.debugSparkJobDefinitionWithResponseAsync(sparkJobDefinitionAzureResource).flatMap(res -> Mono.justOrEmpty((Object)((SparkBatchJob)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> debugSparkJobDefinitionAsync(SparkJobDefinitionResource sparkJobDefinitionAzureResource, Context context) {
        return this.debugSparkJobDefinitionWithResponseAsync(sparkJobDefinitionAzureResource, context).flatMap(res -> Mono.justOrEmpty((Object)((SparkBatchJob)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> debugSparkJobDefinitionWithResponse(SparkJobDefinitionResource sparkJobDefinitionAzureResource, Context context) {
        return (Response)this.debugSparkJobDefinitionWithResponseAsync(sparkJobDefinitionAzureResource, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob debugSparkJobDefinition(SparkJobDefinitionResource sparkJobDefinitionAzureResource) {
        return (SparkBatchJob)this.debugSparkJobDefinitionWithResponse(sparkJobDefinitionAzureResource, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkJobDefinitionResource>> getSparkJobDefinitionsByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkJobDefinitionsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkJobDefinitionsListResponse)res.getValue()).getValue(), ((SparkJobDefinitionsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkJobDefinitionResource>> getSparkJobDefinitionsByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getSparkJobDefinitionsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkJobDefinitionsListResponse)res.getValue()).getValue(), ((SparkJobDefinitionsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getSparkJobDefinitionsByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SparkJobDefinitionResource> getSparkJobDefinitionsByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getSparkJobDefinitionsByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientSpark")
    public static interface SparkJobDefinitionsService {
        @Get(value="/sparkJobDefinitions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkJobDefinitionsListResponse>> getSparkJobDefinitionsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/sparkJobDefinitions/{sparkJobDefinitionName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkJobDefinitionResource>> createOrUpdateSparkJobDefinition(@HostParam(value="endpoint") String var1, @PathParam(value="sparkJobDefinitionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") SparkJobDefinitionResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/sparkJobDefinitions/{sparkJobDefinitionName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkJobDefinitionResource>> getSparkJobDefinition(@HostParam(value="endpoint") String var1, @PathParam(value="sparkJobDefinitionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/sparkJobDefinitions/{sparkJobDefinitionName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteSparkJobDefinition(@HostParam(value="endpoint") String var1, @PathParam(value="sparkJobDefinitionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/sparkJobDefinitions/{sparkJobDefinitionName}/execute")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkBatchJob>> executeSparkJobDefinition(@HostParam(value="endpoint") String var1, @PathParam(value="sparkJobDefinitionName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/sparkJobDefinitions/{sparkJobDefinitionName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renameSparkJobDefinition(@HostParam(value="endpoint") String var1, @PathParam(value="sparkJobDefinitionName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/debugSparkJobDefinition")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkBatchJob>> debugSparkJobDefinition(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") SparkJobDefinitionResource var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkJobDefinitionsListResponse>> getSparkJobDefinitionsByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

