/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.SqlScriptResource;
import com.azure.analytics.synapse.artifacts.models.SqlScriptsListResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SqlScriptsImpl {
    private final SqlScriptsService service;
    private final ArtifactsClientImpl client;

    SqlScriptsImpl(ArtifactsClientImpl client) {
        this.service = (SqlScriptsService)RestProxy.create(SqlScriptsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SqlScriptResource>> getSqlScriptsByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSqlScriptsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlScriptsListResponse)res.getValue()).getValue(), ((SqlScriptsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SqlScriptResource>> getSqlScriptsByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getSqlScriptsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlScriptsListResponse)res.getValue()).getValue(), ((SqlScriptsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SqlScriptResource> getSqlScriptsByWorkspaceAsync() {
        return new PagedFlux(() -> this.getSqlScriptsByWorkspaceSinglePageAsync(), nextLink -> this.getSqlScriptsByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SqlScriptResource> getSqlScriptsByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getSqlScriptsByWorkspaceSinglePageAsync(context), nextLink -> this.getSqlScriptsByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SqlScriptResource> getSqlScriptsByWorkspaceSinglePage() {
        return (PagedResponse)this.getSqlScriptsByWorkspaceSinglePageAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SqlScriptResource> getSqlScriptsByWorkspaceSinglePage(Context context) {
        return (PagedResponse)this.getSqlScriptsByWorkspaceSinglePageAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlScriptResource> getSqlScriptsByWorkspace() {
        return new PagedIterable(this.getSqlScriptsByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlScriptResource> getSqlScriptsByWorkspace(Context context) {
        return new PagedIterable(this.getSqlScriptsByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlScriptResource>> createOrUpdateSqlScriptWithResponseAsync(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", ifMatch, sqlScript, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlScriptResource>> createOrUpdateSqlScriptWithResponseAsync(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", ifMatch, sqlScript, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> createOrUpdateSqlScriptAsync(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch) {
        return this.createOrUpdateSqlScriptWithResponseAsync(sqlScriptName, sqlScript, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((SqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> createOrUpdateSqlScriptAsync(String sqlScriptName, SqlScriptResource sqlScript) {
        String ifMatch = null;
        return this.createOrUpdateSqlScriptWithResponseAsync(sqlScriptName, sqlScript, ifMatch).flatMap(res -> Mono.justOrEmpty((Object)((SqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> createOrUpdateSqlScriptAsync(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch, Context context) {
        return this.createOrUpdateSqlScriptWithResponseAsync(sqlScriptName, sqlScript, ifMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((SqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlScriptResource> createOrUpdateSqlScriptWithResponse(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch, Context context) {
        return (Response)this.createOrUpdateSqlScriptWithResponseAsync(sqlScriptName, sqlScript, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource createOrUpdateSqlScript(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch) {
        return (SqlScriptResource)this.createOrUpdateSqlScriptWithResponse(sqlScriptName, sqlScript, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource createOrUpdateSqlScript(String sqlScriptName, SqlScriptResource sqlScript) {
        String ifMatch = null;
        return (SqlScriptResource)this.createOrUpdateSqlScriptWithResponse(sqlScriptName, sqlScript, ifMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlScriptResource>> getSqlScriptWithResponseAsync(String sqlScriptName, String ifNoneMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", ifNoneMatch, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlScriptResource>> getSqlScriptWithResponseAsync(String sqlScriptName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> getSqlScriptAsync(String sqlScriptName, String ifNoneMatch) {
        return this.getSqlScriptWithResponseAsync(sqlScriptName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((SqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> getSqlScriptAsync(String sqlScriptName) {
        String ifNoneMatch = null;
        return this.getSqlScriptWithResponseAsync(sqlScriptName, ifNoneMatch).flatMap(res -> Mono.justOrEmpty((Object)((SqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlScriptResource> getSqlScriptAsync(String sqlScriptName, String ifNoneMatch, Context context) {
        return this.getSqlScriptWithResponseAsync(sqlScriptName, ifNoneMatch, context).flatMap(res -> Mono.justOrEmpty((Object)((SqlScriptResource)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlScriptResource> getSqlScriptWithResponse(String sqlScriptName, String ifNoneMatch, Context context) {
        return (Response)this.getSqlScriptWithResponseAsync(sqlScriptName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource getSqlScript(String sqlScriptName, String ifNoneMatch) {
        return (SqlScriptResource)this.getSqlScriptWithResponse(sqlScriptName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource getSqlScript(String sqlScriptName) {
        String ifNoneMatch = null;
        return (SqlScriptResource)this.getSqlScriptWithResponse(sqlScriptName, ifNoneMatch, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSqlScriptWithResponseAsync(String sqlScriptName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSqlScriptWithResponseAsync(String sqlScriptName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSqlScriptAsync(String sqlScriptName) {
        return this.deleteSqlScriptWithResponseAsync(sqlScriptName).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSqlScriptAsync(String sqlScriptName, Context context) {
        return this.deleteSqlScriptWithResponseAsync(sqlScriptName, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSqlScriptWithResponse(String sqlScriptName, Context context) {
        return (Response)this.deleteSqlScriptWithResponseAsync(sqlScriptName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSqlScript(String sqlScriptName) {
        this.deleteSqlScriptWithResponse(sqlScriptName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSqlScriptWithResponseAsync(String sqlScriptName, ArtifactRenameRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renameSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSqlScriptWithResponseAsync(String sqlScriptName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renameSqlScript(this.client.getEndpoint(), sqlScriptName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSqlScriptAsync(String sqlScriptName, ArtifactRenameRequest request) {
        return this.renameSqlScriptWithResponseAsync(sqlScriptName, request).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSqlScriptAsync(String sqlScriptName, ArtifactRenameRequest request, Context context) {
        return this.renameSqlScriptWithResponseAsync(sqlScriptName, request, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameSqlScriptWithResponse(String sqlScriptName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameSqlScriptWithResponseAsync(sqlScriptName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameSqlScript(String sqlScriptName, ArtifactRenameRequest request) {
        this.renameSqlScriptWithResponse(sqlScriptName, request, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SqlScriptResource>> getSqlScriptsByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSqlScriptsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlScriptsListResponse)res.getValue()).getValue(), ((SqlScriptsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SqlScriptResource>> getSqlScriptsByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getSqlScriptsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SqlScriptsListResponse)res.getValue()).getValue(), ((SqlScriptsListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SqlScriptResource> getSqlScriptsByWorkspaceNextSinglePage(String nextLink) {
        return (PagedResponse)this.getSqlScriptsByWorkspaceNextSinglePageAsync(nextLink).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PagedResponse<SqlScriptResource> getSqlScriptsByWorkspaceNextSinglePage(String nextLink, Context context) {
        return (PagedResponse)this.getSqlScriptsByWorkspaceNextSinglePageAsync(nextLink, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientSqlSc")
    public static interface SqlScriptsService {
        @Get(value="/sqlScripts")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SqlScriptsListResponse>> getSqlScriptsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/sqlScripts/{sqlScriptName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SqlScriptResource>> createOrUpdateSqlScript(@HostParam(value="endpoint") String var1, @PathParam(value="sqlScriptName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") SqlScriptResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/sqlScripts/{sqlScriptName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SqlScriptResource>> getSqlScript(@HostParam(value="endpoint") String var1, @PathParam(value="sqlScriptName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/sqlScripts/{sqlScriptName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteSqlScript(@HostParam(value="endpoint") String var1, @PathParam(value="sqlScriptName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/sqlScripts/{sqlScriptName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renameSqlScript(@HostParam(value="endpoint") String var1, @PathParam(value="sqlScriptName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SqlScriptsListResponse>> getSqlScriptsByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

