/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.RunFilterParameters;
import com.azure.analytics.synapse.artifacts.models.TriggerRunsQueryResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class TriggerRunsImpl {
    private final TriggerRunsService service;
    private final ArtifactsClientImpl client;

    TriggerRunsImpl(ArtifactsClientImpl client) {
        this.service = (TriggerRunsService)RestProxy.create(TriggerRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rerunTriggerInstanceWithResponseAsync(String triggerName, String runId) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.rerunTriggerInstance(this.client.getEndpoint(), triggerName, runId, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rerunTriggerInstanceWithResponseAsync(String triggerName, String runId, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.rerunTriggerInstance(this.client.getEndpoint(), triggerName, runId, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rerunTriggerInstanceAsync(String triggerName, String runId) {
        return this.rerunTriggerInstanceWithResponseAsync(triggerName, runId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rerunTriggerInstanceAsync(String triggerName, String runId, Context context) {
        return this.rerunTriggerInstanceWithResponseAsync(triggerName, runId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rerunTriggerInstanceWithResponse(String triggerName, String runId, Context context) {
        return (Response)this.rerunTriggerInstanceWithResponseAsync(triggerName, runId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rerunTriggerInstance(String triggerName, String runId) {
        this.rerunTriggerInstanceWithResponse(triggerName, runId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelTriggerInstanceWithResponseAsync(String triggerName, String runId) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelTriggerInstance(this.client.getEndpoint(), triggerName, runId, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelTriggerInstanceWithResponseAsync(String triggerName, String runId, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.cancelTriggerInstance(this.client.getEndpoint(), triggerName, runId, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelTriggerInstanceAsync(String triggerName, String runId) {
        return this.cancelTriggerInstanceWithResponseAsync(triggerName, runId).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelTriggerInstanceAsync(String triggerName, String runId, Context context) {
        return this.cancelTriggerInstanceWithResponseAsync(triggerName, runId, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelTriggerInstanceWithResponse(String triggerName, String runId, Context context) {
        return (Response)this.cancelTriggerInstanceWithResponseAsync(triggerName, runId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelTriggerInstance(String triggerName, String runId) {
        this.cancelTriggerInstanceWithResponse(triggerName, runId, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerRunsQueryResponse>> queryTriggerRunsByWorkspaceWithResponseAsync(RunFilterParameters filterParameters) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryTriggerRunsByWorkspace(this.client.getEndpoint(), "2020-12-01", filterParameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<TriggerRunsQueryResponse>> queryTriggerRunsByWorkspaceWithResponseAsync(RunFilterParameters filterParameters, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.queryTriggerRunsByWorkspace(this.client.getEndpoint(), "2020-12-01", filterParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerRunsQueryResponse> queryTriggerRunsByWorkspaceAsync(RunFilterParameters filterParameters) {
        return this.queryTriggerRunsByWorkspaceWithResponseAsync(filterParameters).flatMap(res -> Mono.justOrEmpty((Object)((TriggerRunsQueryResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<TriggerRunsQueryResponse> queryTriggerRunsByWorkspaceAsync(RunFilterParameters filterParameters, Context context) {
        return this.queryTriggerRunsByWorkspaceWithResponseAsync(filterParameters, context).flatMap(res -> Mono.justOrEmpty((Object)((TriggerRunsQueryResponse)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<TriggerRunsQueryResponse> queryTriggerRunsByWorkspaceWithResponse(RunFilterParameters filterParameters, Context context) {
        return (Response)this.queryTriggerRunsByWorkspaceWithResponseAsync(filterParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public TriggerRunsQueryResponse queryTriggerRunsByWorkspace(RunFilterParameters filterParameters) {
        return (TriggerRunsQueryResponse)this.queryTriggerRunsByWorkspaceWithResponse(filterParameters, Context.NONE).getValue();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientTrigg")
    public static interface TriggerRunsService {
        @Post(value="/triggers/{triggerName}/triggerRuns/{runId}/rerun")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> rerunTriggerInstance(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @PathParam(value="runId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/triggers/{triggerName}/triggerRuns/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> cancelTriggerInstance(@HostParam(value="endpoint") String var1, @PathParam(value="triggerName") String var2, @PathParam(value="runId") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/queryTriggerRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<TriggerRunsQueryResponse>> queryTriggerRunsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RunFilterParameters var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

