/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.DatasetsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.DatasetResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class DatasetClient {
    private final DatasetsImpl serviceClient;

    DatasetClient(DatasetsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatasetResource> getDatasetsByWorkspace() {
        return this.serviceClient.getDatasetsByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DatasetResource> getDatasetsByWorkspace(Context context) {
        return this.serviceClient.getDatasetsByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource createOrUpdateDataset(String datasetName, DatasetResource dataset, String ifMatch) {
        return this.serviceClient.createOrUpdateDataset(datasetName, dataset, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource createOrUpdateDataset(String datasetName, DatasetResource dataset) {
        return this.serviceClient.createOrUpdateDataset(datasetName, dataset);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatasetResource> createOrUpdateDatasetWithResponse(String datasetName, DatasetResource dataset, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateDatasetWithResponse(datasetName, dataset, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource getDataset(String datasetName, String ifNoneMatch) {
        return this.serviceClient.getDataset(datasetName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatasetResource getDataset(String datasetName) {
        return this.serviceClient.getDataset(datasetName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatasetResource> getDatasetWithResponse(String datasetName, String ifNoneMatch, Context context) {
        return this.serviceClient.getDatasetWithResponse(datasetName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataset(String datasetName) {
        this.serviceClient.deleteDataset(datasetName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDatasetWithResponse(String datasetName, Context context) {
        return this.serviceClient.deleteDatasetWithResponse(datasetName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameDataset(String datasetName, ArtifactRenameRequest request) {
        this.serviceClient.renameDataset(datasetName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameDatasetWithResponse(String datasetName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameDatasetWithResponse(datasetName, request, context);
    }
}

