/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.NotebooksImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.NotebookResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class NotebookClient {
    private final NotebooksImpl serviceClient;

    NotebookClient(NotebooksImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebooksByWorkspace() {
        return this.serviceClient.getNotebooksByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebooksByWorkspace(Context context) {
        return this.serviceClient.getNotebooksByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebookSummaryByWorkSpace() {
        return this.serviceClient.getNotebookSummaryByWorkSpace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<NotebookResource> getNotebookSummaryByWorkSpace(Context context) {
        return this.serviceClient.getNotebookSummaryByWorkSpace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource createOrUpdateNotebook(String notebookName, NotebookResource notebook, String ifMatch) {
        return this.serviceClient.createOrUpdateNotebook(notebookName, notebook, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource createOrUpdateNotebook(String notebookName, NotebookResource notebook) {
        return this.serviceClient.createOrUpdateNotebook(notebookName, notebook);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotebookResource> createOrUpdateNotebookWithResponse(String notebookName, NotebookResource notebook, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateNotebookWithResponse(notebookName, notebook, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource getNotebook(String notebookName, String ifNoneMatch) {
        return this.serviceClient.getNotebook(notebookName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public NotebookResource getNotebook(String notebookName) {
        return this.serviceClient.getNotebook(notebookName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NotebookResource> getNotebookWithResponse(String notebookName, String ifNoneMatch, Context context) {
        return this.serviceClient.getNotebookWithResponse(notebookName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteNotebook(String notebookName) {
        this.serviceClient.deleteNotebook(notebookName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteNotebookWithResponse(String notebookName, Context context) {
        return this.serviceClient.deleteNotebookWithResponse(notebookName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameNotebook(String notebookName, ArtifactRenameRequest request) {
        this.serviceClient.renameNotebook(notebookName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameNotebookWithResponse(String notebookName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameNotebookWithResponse(notebookName, request, context);
    }
}

