/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.PipelinesImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CreateRunResponse;
import com.azure.analytics.synapse.artifacts.models.PipelineResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.util.Map;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class PipelineClient {
    private final PipelinesImpl serviceClient;

    PipelineClient(PipelinesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PipelineResource> getPipelinesByWorkspace() {
        return this.serviceClient.getPipelinesByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<PipelineResource> getPipelinesByWorkspace(Context context) {
        return this.serviceClient.getPipelinesByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource createOrUpdatePipeline(String pipelineName, PipelineResource pipeline, String ifMatch) {
        return this.serviceClient.createOrUpdatePipeline(pipelineName, pipeline, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource createOrUpdatePipeline(String pipelineName, PipelineResource pipeline) {
        return this.serviceClient.createOrUpdatePipeline(pipelineName, pipeline);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineResource> createOrUpdatePipelineWithResponse(String pipelineName, PipelineResource pipeline, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdatePipelineWithResponse(pipelineName, pipeline, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource getPipeline(String pipelineName, String ifNoneMatch) {
        return this.serviceClient.getPipeline(pipelineName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineResource getPipeline(String pipelineName) {
        return this.serviceClient.getPipeline(pipelineName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineResource> getPipelineWithResponse(String pipelineName, String ifNoneMatch, Context context) {
        return this.serviceClient.getPipelineWithResponse(pipelineName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deletePipeline(String pipelineName) {
        this.serviceClient.deletePipeline(pipelineName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deletePipelineWithResponse(String pipelineName, Context context) {
        return this.serviceClient.deletePipelineWithResponse(pipelineName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renamePipeline(String pipelineName, ArtifactRenameRequest request) {
        this.serviceClient.renamePipeline(pipelineName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renamePipelineWithResponse(String pipelineName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renamePipelineWithResponse(pipelineName, request, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateRunResponse createPipelineRun(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters) {
        return this.serviceClient.createPipelineRun(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateRunResponse createPipelineRun(String pipelineName) {
        return this.serviceClient.createPipelineRun(pipelineName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CreateRunResponse> createPipelineRunWithResponse(String pipelineName, String referencePipelineRunId, Boolean isRecovery, String startActivityName, Map<String, Object> parameters, Context context) {
        return this.serviceClient.createPipelineRunWithResponse(pipelineName, referencePipelineRunId, isRecovery, startActivityName, parameters, context);
    }
}

