/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SparkConfigurationsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class SparkConfigurationClient {
    private final SparkConfigurationsImpl serviceClient;

    SparkConfigurationClient(SparkConfigurationsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkConfigurationResource> getSparkConfigurationsByWorkspace() {
        return this.serviceClient.getSparkConfigurationsByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkConfigurationResource> getSparkConfigurationsByWorkspace(Context context) {
        return this.serviceClient.getSparkConfigurationsByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource createOrUpdateSparkConfiguration(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch) {
        return this.serviceClient.createOrUpdateSparkConfiguration(sparkConfigurationName, sparkConfiguration, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource createOrUpdateSparkConfiguration(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration) {
        return this.serviceClient.createOrUpdateSparkConfiguration(sparkConfigurationName, sparkConfiguration);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkConfigurationResource> createOrUpdateSparkConfigurationWithResponse(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateSparkConfigurationWithResponse(sparkConfigurationName, sparkConfiguration, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource getSparkConfiguration(String sparkConfigurationName, String ifNoneMatch) {
        return this.serviceClient.getSparkConfiguration(sparkConfigurationName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource getSparkConfiguration(String sparkConfigurationName) {
        return this.serviceClient.getSparkConfiguration(sparkConfigurationName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkConfigurationResource> getSparkConfigurationWithResponse(String sparkConfigurationName, String ifNoneMatch, Context context) {
        return this.serviceClient.getSparkConfigurationWithResponse(sparkConfigurationName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSparkConfiguration(String sparkConfigurationName) {
        this.serviceClient.deleteSparkConfiguration(sparkConfigurationName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSparkConfigurationWithResponse(String sparkConfigurationName, Context context) {
        return this.serviceClient.deleteSparkConfigurationWithResponse(sparkConfigurationName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameSparkConfiguration(String sparkConfigurationName, ArtifactRenameRequest request) {
        this.serviceClient.renameSparkConfiguration(sparkConfigurationName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameSparkConfigurationWithResponse(String sparkConfigurationName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameSparkConfigurationWithResponse(sparkConfigurationName, request, context);
    }
}

