/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorAutoGeneratedException;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceListResponse;
import com.azure.analytics.synapse.artifacts.models.LinkedServiceResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class LinkedServicesImpl {
    private final LinkedServicesService service;
    private final ArtifactsClientImpl client;

    LinkedServicesImpl(ArtifactsClientImpl client) {
        this.service = (LinkedServicesService)RestProxy.create(LinkedServicesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkedServiceResource>> getLinkedServicesByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLinkedServicesByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkedServiceListResponse)res.getValue()).getValue(), ((LinkedServiceListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkedServiceResource>> getLinkedServicesByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getLinkedServicesByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkedServiceListResponse)res.getValue()).getValue(), ((LinkedServiceListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LinkedServiceResource> getLinkedServicesByWorkspaceAsync() {
        return new PagedFlux(() -> this.getLinkedServicesByWorkspaceSinglePageAsync(), nextLink -> this.getLinkedServicesByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LinkedServiceResource> getLinkedServicesByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getLinkedServicesByWorkspaceSinglePageAsync(context), nextLink -> this.getLinkedServicesByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkedServiceResource> getLinkedServicesByWorkspace() {
        return new PagedIterable(this.getLinkedServicesByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LinkedServiceResource> getLinkedServicesByWorkspace(Context context) {
        return new PagedIterable(this.getLinkedServicesByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkedServiceResource>> createOrUpdateLinkedServiceWithResponseAsync(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", ifMatch, linkedService, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkedServiceResource>> createOrUpdateLinkedServiceWithResponseAsync(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createOrUpdateLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", ifMatch, linkedService, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> createOrUpdateLinkedServiceAsync(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch) {
        return this.createOrUpdateLinkedServiceWithResponseAsync(linkedServiceName, linkedService, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LinkedServiceResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> createOrUpdateLinkedServiceAsync(String linkedServiceName, LinkedServiceResource linkedService) {
        String ifMatch = null;
        return this.createOrUpdateLinkedServiceWithResponseAsync(linkedServiceName, linkedService, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LinkedServiceResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> createOrUpdateLinkedServiceAsync(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch, Context context) {
        return this.createOrUpdateLinkedServiceWithResponseAsync(linkedServiceName, linkedService, ifMatch, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LinkedServiceResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource createOrUpdateLinkedService(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch) {
        return (LinkedServiceResource)this.createOrUpdateLinkedServiceAsync(linkedServiceName, linkedService, ifMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource createOrUpdateLinkedService(String linkedServiceName, LinkedServiceResource linkedService) {
        String ifMatch = null;
        return (LinkedServiceResource)this.createOrUpdateLinkedServiceAsync(linkedServiceName, linkedService, ifMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkedServiceResource> createOrUpdateLinkedServiceWithResponse(String linkedServiceName, LinkedServiceResource linkedService, String ifMatch, Context context) {
        return (Response)this.createOrUpdateLinkedServiceWithResponseAsync(linkedServiceName, linkedService, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkedServiceResource>> getLinkedServiceWithResponseAsync(String linkedServiceName, String ifNoneMatch) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", ifNoneMatch, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LinkedServiceResource>> getLinkedServiceWithResponseAsync(String linkedServiceName, String ifNoneMatch, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> getLinkedServiceAsync(String linkedServiceName, String ifNoneMatch) {
        return this.getLinkedServiceWithResponseAsync(linkedServiceName, ifNoneMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LinkedServiceResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> getLinkedServiceAsync(String linkedServiceName) {
        String ifNoneMatch = null;
        return this.getLinkedServiceWithResponseAsync(linkedServiceName, ifNoneMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LinkedServiceResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LinkedServiceResource> getLinkedServiceAsync(String linkedServiceName, String ifNoneMatch, Context context) {
        return this.getLinkedServiceWithResponseAsync(linkedServiceName, ifNoneMatch, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LinkedServiceResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource getLinkedService(String linkedServiceName, String ifNoneMatch) {
        return (LinkedServiceResource)this.getLinkedServiceAsync(linkedServiceName, ifNoneMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LinkedServiceResource getLinkedService(String linkedServiceName) {
        String ifNoneMatch = null;
        return (LinkedServiceResource)this.getLinkedServiceAsync(linkedServiceName, ifNoneMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LinkedServiceResource> getLinkedServiceWithResponse(String linkedServiceName, String ifNoneMatch, Context context) {
        return (Response)this.getLinkedServiceWithResponseAsync(linkedServiceName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteLinkedServiceWithResponseAsync(String linkedServiceName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteLinkedServiceWithResponseAsync(String linkedServiceName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteLinkedServiceAsync(String linkedServiceName) {
        return this.deleteLinkedServiceWithResponseAsync(linkedServiceName).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteLinkedServiceAsync(String linkedServiceName, Context context) {
        return this.deleteLinkedServiceWithResponseAsync(linkedServiceName, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteLinkedService(String linkedServiceName) {
        this.deleteLinkedServiceAsync(linkedServiceName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteLinkedServiceWithResponse(String linkedServiceName, Context context) {
        return (Response)this.deleteLinkedServiceWithResponseAsync(linkedServiceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameLinkedServiceWithResponseAsync(String linkedServiceName, ArtifactRenameRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renameLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameLinkedServiceWithResponseAsync(String linkedServiceName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.renameLinkedService(this.client.getEndpoint(), linkedServiceName, "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameLinkedServiceAsync(String linkedServiceName, ArtifactRenameRequest request) {
        return this.renameLinkedServiceWithResponseAsync(linkedServiceName, request).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameLinkedServiceAsync(String linkedServiceName, ArtifactRenameRequest request, Context context) {
        return this.renameLinkedServiceWithResponseAsync(linkedServiceName, request, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameLinkedService(String linkedServiceName, ArtifactRenameRequest request) {
        this.renameLinkedServiceAsync(linkedServiceName, request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameLinkedServiceWithResponse(String linkedServiceName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameLinkedServiceWithResponseAsync(linkedServiceName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkedServiceResource>> getLinkedServicesByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getLinkedServicesByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkedServiceListResponse)res.getValue()).getValue(), ((LinkedServiceListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LinkedServiceResource>> getLinkedServicesByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getLinkedServicesByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LinkedServiceListResponse)res.getValue()).getValue(), ((LinkedServiceListResponse)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientLinke")
    private static interface LinkedServicesService {
        @Get(value="/linkedservices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LinkedServiceListResponse>> getLinkedServicesByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/linkedservices/{linkedServiceName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LinkedServiceResource>> createOrUpdateLinkedService(@HostParam(value="endpoint") String var1, @PathParam(value="linkedServiceName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") LinkedServiceResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/linkedservices/{linkedServiceName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LinkedServiceResource>> getLinkedService(@HostParam(value="endpoint") String var1, @PathParam(value="linkedServiceName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/linkedservices/{linkedServiceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<Void>> deleteLinkedService(@HostParam(value="endpoint") String var1, @PathParam(value="linkedServiceName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/linkedservices/{linkedServiceName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<Void>> renameLinkedService(@HostParam(value="endpoint") String var1, @PathParam(value="linkedServiceName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LinkedServiceListResponse>> getLinkedServicesByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

