/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.CloudErrorException;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationListResponse;
import com.azure.analytics.synapse.artifacts.models.SparkConfigurationResource;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SparkConfigurationsImpl {
    private final SparkConfigurationsService service;
    private final ArtifactsClientImpl client;

    SparkConfigurationsImpl(ArtifactsClientImpl client) {
        this.service = (SparkConfigurationsService)RestProxy.create(SparkConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkConfigurationResource>> getSparkConfigurationsByWorkspaceSinglePageAsync() {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkConfigurationsByWorkspace(this.client.getEndpoint(), "2021-06-01-preview", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkConfigurationListResponse)res.getValue()).getValue(), ((SparkConfigurationListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkConfigurationResource>> getSparkConfigurationsByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return this.service.getSparkConfigurationsByWorkspace(this.client.getEndpoint(), "2021-06-01-preview", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkConfigurationListResponse)res.getValue()).getValue(), ((SparkConfigurationListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SparkConfigurationResource> getSparkConfigurationsByWorkspaceAsync() {
        return new PagedFlux(() -> this.getSparkConfigurationsByWorkspaceSinglePageAsync(), nextLink -> this.getSparkConfigurationsByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<SparkConfigurationResource> getSparkConfigurationsByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.getSparkConfigurationsByWorkspaceSinglePageAsync(context), nextLink -> this.getSparkConfigurationsByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkConfigurationResource> getSparkConfigurationsByWorkspace() {
        return new PagedIterable(this.getSparkConfigurationsByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SparkConfigurationResource> getSparkConfigurationsByWorkspace(Context context) {
        return new PagedIterable(this.getSparkConfigurationsByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkConfigurationResource>> createOrUpdateSparkConfigurationWithResponseAsync(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdateSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", ifMatch, sparkConfiguration, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkConfigurationResource>> createOrUpdateSparkConfigurationWithResponseAsync(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch, Context context) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return this.service.createOrUpdateSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", ifMatch, sparkConfiguration, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> createOrUpdateSparkConfigurationAsync(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch) {
        return this.createOrUpdateSparkConfigurationWithResponseAsync(sparkConfigurationName, sparkConfiguration, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkConfigurationResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> createOrUpdateSparkConfigurationAsync(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration) {
        String ifMatch = null;
        return this.createOrUpdateSparkConfigurationWithResponseAsync(sparkConfigurationName, sparkConfiguration, ifMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkConfigurationResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> createOrUpdateSparkConfigurationAsync(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch, Context context) {
        return this.createOrUpdateSparkConfigurationWithResponseAsync(sparkConfigurationName, sparkConfiguration, ifMatch, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkConfigurationResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource createOrUpdateSparkConfiguration(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch) {
        return (SparkConfigurationResource)this.createOrUpdateSparkConfigurationAsync(sparkConfigurationName, sparkConfiguration, ifMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource createOrUpdateSparkConfiguration(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration) {
        String ifMatch = null;
        return (SparkConfigurationResource)this.createOrUpdateSparkConfigurationAsync(sparkConfigurationName, sparkConfiguration, ifMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkConfigurationResource> createOrUpdateSparkConfigurationWithResponse(String sparkConfigurationName, SparkConfigurationResource sparkConfiguration, String ifMatch, Context context) {
        return (Response)this.createOrUpdateSparkConfigurationWithResponseAsync(sparkConfigurationName, sparkConfiguration, ifMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkConfigurationResource>> getSparkConfigurationWithResponseAsync(String sparkConfigurationName, String ifNoneMatch) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", ifNoneMatch, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkConfigurationResource>> getSparkConfigurationWithResponseAsync(String sparkConfigurationName, String ifNoneMatch, Context context) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return this.service.getSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> getSparkConfigurationAsync(String sparkConfigurationName, String ifNoneMatch) {
        return this.getSparkConfigurationWithResponseAsync(sparkConfigurationName, ifNoneMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkConfigurationResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> getSparkConfigurationAsync(String sparkConfigurationName) {
        String ifNoneMatch = null;
        return this.getSparkConfigurationWithResponseAsync(sparkConfigurationName, ifNoneMatch).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkConfigurationResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkConfigurationResource> getSparkConfigurationAsync(String sparkConfigurationName, String ifNoneMatch, Context context) {
        return this.getSparkConfigurationWithResponseAsync(sparkConfigurationName, ifNoneMatch, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkConfigurationResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource getSparkConfiguration(String sparkConfigurationName, String ifNoneMatch) {
        return (SparkConfigurationResource)this.getSparkConfigurationAsync(sparkConfigurationName, ifNoneMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkConfigurationResource getSparkConfiguration(String sparkConfigurationName) {
        String ifNoneMatch = null;
        return (SparkConfigurationResource)this.getSparkConfigurationAsync(sparkConfigurationName, ifNoneMatch).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkConfigurationResource> getSparkConfigurationWithResponse(String sparkConfigurationName, String ifNoneMatch, Context context) {
        return (Response)this.getSparkConfigurationWithResponseAsync(sparkConfigurationName, ifNoneMatch, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSparkConfigurationWithResponseAsync(String sparkConfigurationName) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteSparkConfigurationWithResponseAsync(String sparkConfigurationName, Context context) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return this.service.deleteSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSparkConfigurationAsync(String sparkConfigurationName) {
        return this.deleteSparkConfigurationWithResponseAsync(sparkConfigurationName).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteSparkConfigurationAsync(String sparkConfigurationName, Context context) {
        return this.deleteSparkConfigurationWithResponseAsync(sparkConfigurationName, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSparkConfiguration(String sparkConfigurationName) {
        this.deleteSparkConfigurationAsync(sparkConfigurationName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSparkConfigurationWithResponse(String sparkConfigurationName, Context context) {
        return (Response)this.deleteSparkConfigurationWithResponseAsync(sparkConfigurationName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSparkConfigurationWithResponseAsync(String sparkConfigurationName, ArtifactRenameRequest request) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.renameSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> renameSparkConfigurationWithResponseAsync(String sparkConfigurationName, ArtifactRenameRequest request, Context context) {
        String apiVersion = "2021-06-01-preview";
        String accept = "application/json";
        return this.service.renameSparkConfiguration(this.client.getEndpoint(), sparkConfigurationName, "2021-06-01-preview", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSparkConfigurationAsync(String sparkConfigurationName, ArtifactRenameRequest request) {
        return this.renameSparkConfigurationWithResponseAsync(sparkConfigurationName, request).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> renameSparkConfigurationAsync(String sparkConfigurationName, ArtifactRenameRequest request, Context context) {
        return this.renameSparkConfigurationWithResponseAsync(sparkConfigurationName, request, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameSparkConfiguration(String sparkConfigurationName, ArtifactRenameRequest request) {
        this.renameSparkConfigurationAsync(sparkConfigurationName, request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameSparkConfigurationWithResponse(String sparkConfigurationName, ArtifactRenameRequest request, Context context) {
        return (Response)this.renameSparkConfigurationWithResponseAsync(sparkConfigurationName, request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkConfigurationResource>> getSparkConfigurationsByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkConfigurationsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkConfigurationListResponse)res.getValue()).getValue(), ((SparkConfigurationListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<SparkConfigurationResource>> getSparkConfigurationsByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.getSparkConfigurationsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((SparkConfigurationListResponse)res.getValue()).getValue(), ((SparkConfigurationListResponse)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientSpark")
    private static interface SparkConfigurationsService {
        @Get(value="/sparkconfigurations")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkConfigurationListResponse>> getSparkConfigurationsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Put(value="/sparkconfigurations/{sparkConfigurationName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkConfigurationResource>> createOrUpdateSparkConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="sparkConfigurationName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-Match") String var4, @BodyParam(value="application/json") SparkConfigurationResource var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/sparkconfigurations/{sparkConfigurationName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkConfigurationResource>> getSparkConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="sparkConfigurationName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="If-None-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Delete(value="/sparkconfigurations/{sparkConfigurationName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> deleteSparkConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="sparkConfigurationName") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/sparkconfigurations/{sparkConfigurationName}/rename")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<Void>> renameSparkConfiguration(@HostParam(value="endpoint") String var1, @PathParam(value="sparkConfigurationName") String var2, @QueryParam(value="api-version") String var3, @BodyParam(value="application/json") ArtifactRenameRequest var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorException.class)
        public Mono<Response<SparkConfigurationListResponse>> getSparkConfigurationsByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

