/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.DataFlowsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.DataFlowResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class DataFlowClient {
    private final DataFlowsImpl serviceClient;

    DataFlowClient(DataFlowsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource createOrUpdateDataFlow(String dataFlowName, DataFlowResource dataFlow, String ifMatch) {
        return this.serviceClient.createOrUpdateDataFlow(dataFlowName, dataFlow, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource createOrUpdateDataFlow(String dataFlowName, DataFlowResource dataFlow) {
        return this.serviceClient.createOrUpdateDataFlow(dataFlowName, dataFlow);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFlowResource> createOrUpdateDataFlowWithResponse(String dataFlowName, DataFlowResource dataFlow, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateDataFlowWithResponse(dataFlowName, dataFlow, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource getDataFlow(String dataFlowName, String ifNoneMatch) {
        return this.serviceClient.getDataFlow(dataFlowName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowResource getDataFlow(String dataFlowName) {
        return this.serviceClient.getDataFlow(dataFlowName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DataFlowResource> getDataFlowWithResponse(String dataFlowName, String ifNoneMatch, Context context) {
        return this.serviceClient.getDataFlowWithResponse(dataFlowName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataFlow(String dataFlowName) {
        this.serviceClient.deleteDataFlow(dataFlowName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataFlowWithResponse(String dataFlowName, Context context) {
        return this.serviceClient.deleteDataFlowWithResponse(dataFlowName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameDataFlow(String dataFlowName, ArtifactRenameRequest request) {
        this.serviceClient.renameDataFlow(dataFlowName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameDataFlowWithResponse(String dataFlowName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameDataFlowWithResponse(dataFlowName, request, context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFlowResource> getDataFlowsByWorkspace() {
        return this.serviceClient.getDataFlowsByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFlowResource> getDataFlowsByWorkspace(Context context) {
        return this.serviceClient.getDataFlowsByWorkspace(context);
    }
}

