/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts;

import com.azure.analytics.synapse.artifacts.ArtifactsClientBuilder;
import com.azure.analytics.synapse.artifacts.implementation.SqlScriptsImpl;
import com.azure.analytics.synapse.artifacts.models.ArtifactRenameRequest;
import com.azure.analytics.synapse.artifacts.models.SqlScriptResource;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=ArtifactsClientBuilder.class)
public final class SqlScriptClient {
    private final SqlScriptsImpl serviceClient;

    SqlScriptClient(SqlScriptsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlScriptResource> getSqlScriptsByWorkspace() {
        return this.serviceClient.getSqlScriptsByWorkspace();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<SqlScriptResource> getSqlScriptsByWorkspace(Context context) {
        return this.serviceClient.getSqlScriptsByWorkspace(context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource createOrUpdateSqlScript(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch) {
        return this.serviceClient.createOrUpdateSqlScript(sqlScriptName, sqlScript, ifMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource createOrUpdateSqlScript(String sqlScriptName, SqlScriptResource sqlScript) {
        return this.serviceClient.createOrUpdateSqlScript(sqlScriptName, sqlScript);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlScriptResource> createOrUpdateSqlScriptWithResponse(String sqlScriptName, SqlScriptResource sqlScript, String ifMatch, Context context) {
        return this.serviceClient.createOrUpdateSqlScriptWithResponse(sqlScriptName, sqlScript, ifMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource getSqlScript(String sqlScriptName, String ifNoneMatch) {
        return this.serviceClient.getSqlScript(sqlScriptName, ifNoneMatch);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlScriptResource getSqlScript(String sqlScriptName) {
        return this.serviceClient.getSqlScript(sqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlScriptResource> getSqlScriptWithResponse(String sqlScriptName, String ifNoneMatch, Context context) {
        return this.serviceClient.getSqlScriptWithResponse(sqlScriptName, ifNoneMatch, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteSqlScript(String sqlScriptName) {
        this.serviceClient.deleteSqlScript(sqlScriptName);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteSqlScriptWithResponse(String sqlScriptName, Context context) {
        return this.serviceClient.deleteSqlScriptWithResponse(sqlScriptName, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void renameSqlScript(String sqlScriptName, ArtifactRenameRequest request) {
        this.serviceClient.renameSqlScript(sqlScriptName, request);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> renameSqlScriptWithResponse(String sqlScriptName, ArtifactRenameRequest request, Context context) {
        return this.serviceClient.renameSqlScriptWithResponse(sqlScriptName, request, context);
    }
}

