/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.AddDataFlowToDebugSessionResponse;
import com.azure.analytics.synapse.artifacts.models.CloudErrorAutoGeneratedException;
import com.azure.analytics.synapse.artifacts.models.CreateDataFlowDebugSessionRequest;
import com.azure.analytics.synapse.artifacts.models.CreateDataFlowDebugSessionResponse;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugCommandRequest;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugCommandResponse;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugPackage;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugSessionInfo;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugSessionsCreateDataFlowDebugSessionResponse;
import com.azure.analytics.synapse.artifacts.models.DataFlowDebugSessionsExecuteCommandResponse;
import com.azure.analytics.synapse.artifacts.models.DeleteDataFlowDebugSessionRequest;
import com.azure.analytics.synapse.artifacts.models.QueryDataFlowDebugSessionsResponse;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class DataFlowDebugSessionsImpl {
    private final DataFlowDebugSessionsService service;
    private final ArtifactsClientImpl client;

    DataFlowDebugSessionsImpl(ArtifactsClientImpl client) {
        this.service = (DataFlowDebugSessionsService)RestProxy.create(DataFlowDebugSessionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowDebugSessionsCreateDataFlowDebugSessionResponse> createDataFlowDebugSessionWithResponseAsync(CreateDataFlowDebugSessionRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createDataFlowDebugSession(this.client.getEndpoint(), "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowDebugSessionsCreateDataFlowDebugSessionResponse> createDataFlowDebugSessionWithResponseAsync(CreateDataFlowDebugSessionRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.createDataFlowDebugSession(this.client.getEndpoint(), "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateDataFlowDebugSessionResponse> createDataFlowDebugSessionAsync(CreateDataFlowDebugSessionRequest request) {
        return this.createDataFlowDebugSessionWithResponseAsync(request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CreateDataFlowDebugSessionResponse> createDataFlowDebugSessionAsync(CreateDataFlowDebugSessionRequest request, Context context) {
        return this.createDataFlowDebugSessionWithResponseAsync(request, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CreateDataFlowDebugSessionResponse createDataFlowDebugSession(CreateDataFlowDebugSessionRequest request) {
        return (CreateDataFlowDebugSessionResponse)this.createDataFlowDebugSessionAsync(request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowDebugSessionsCreateDataFlowDebugSessionResponse createDataFlowDebugSessionWithResponse(CreateDataFlowDebugSessionRequest request, Context context) {
        return (DataFlowDebugSessionsCreateDataFlowDebugSessionResponse)((Object)this.createDataFlowDebugSessionWithResponseAsync(request, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowDebugSessionInfo>> queryDataFlowDebugSessionsByWorkspaceSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryDataFlowDebugSessionsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getValue(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowDebugSessionInfo>> queryDataFlowDebugSessionsByWorkspaceSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.queryDataFlowDebugSessionsByWorkspace(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getValue(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFlowDebugSessionInfo> queryDataFlowDebugSessionsByWorkspaceAsync() {
        return new PagedFlux(() -> this.queryDataFlowDebugSessionsByWorkspaceSinglePageAsync(), nextLink -> this.queryDataFlowDebugSessionsByWorkspaceNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DataFlowDebugSessionInfo> queryDataFlowDebugSessionsByWorkspaceAsync(Context context) {
        return new PagedFlux(() -> this.queryDataFlowDebugSessionsByWorkspaceSinglePageAsync(context), nextLink -> this.queryDataFlowDebugSessionsByWorkspaceNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFlowDebugSessionInfo> queryDataFlowDebugSessionsByWorkspace() {
        return new PagedIterable(this.queryDataFlowDebugSessionsByWorkspaceAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DataFlowDebugSessionInfo> queryDataFlowDebugSessionsByWorkspace(Context context) {
        return new PagedIterable(this.queryDataFlowDebugSessionsByWorkspaceAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddDataFlowToDebugSessionResponse>> addDataFlowWithResponseAsync(DataFlowDebugPackage request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.addDataFlow(this.client.getEndpoint(), "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddDataFlowToDebugSessionResponse>> addDataFlowWithResponseAsync(DataFlowDebugPackage request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.addDataFlow(this.client.getEndpoint(), "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddDataFlowToDebugSessionResponse> addDataFlowAsync(DataFlowDebugPackage request) {
        return this.addDataFlowWithResponseAsync(request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddDataFlowToDebugSessionResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddDataFlowToDebugSessionResponse> addDataFlowAsync(DataFlowDebugPackage request, Context context) {
        return this.addDataFlowWithResponseAsync(request, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AddDataFlowToDebugSessionResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddDataFlowToDebugSessionResponse addDataFlow(DataFlowDebugPackage request) {
        return (AddDataFlowToDebugSessionResponse)this.addDataFlowAsync(request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddDataFlowToDebugSessionResponse> addDataFlowWithResponse(DataFlowDebugPackage request, Context context) {
        return (Response)this.addDataFlowWithResponseAsync(request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFlowDebugSessionWithResponseAsync(DeleteDataFlowDebugSessionRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteDataFlowDebugSession(this.client.getEndpoint(), "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteDataFlowDebugSessionWithResponseAsync(DeleteDataFlowDebugSessionRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.deleteDataFlowDebugSession(this.client.getEndpoint(), "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFlowDebugSessionAsync(DeleteDataFlowDebugSessionRequest request) {
        return this.deleteDataFlowDebugSessionWithResponseAsync(request).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteDataFlowDebugSessionAsync(DeleteDataFlowDebugSessionRequest request, Context context) {
        return this.deleteDataFlowDebugSessionWithResponseAsync(request, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void deleteDataFlowDebugSession(DeleteDataFlowDebugSessionRequest request) {
        this.deleteDataFlowDebugSessionAsync(request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteDataFlowDebugSessionWithResponse(DeleteDataFlowDebugSessionRequest request, Context context) {
        return (Response)this.deleteDataFlowDebugSessionWithResponseAsync(request, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowDebugSessionsExecuteCommandResponse> executeCommandWithResponseAsync(DataFlowDebugCommandRequest request) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.executeCommand(this.client.getEndpoint(), "2020-12-01", request, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowDebugSessionsExecuteCommandResponse> executeCommandWithResponseAsync(DataFlowDebugCommandRequest request, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.executeCommand(this.client.getEndpoint(), "2020-12-01", request, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowDebugCommandResponse> executeCommandAsync(DataFlowDebugCommandRequest request) {
        return this.executeCommandWithResponseAsync(request).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DataFlowDebugCommandResponse> executeCommandAsync(DataFlowDebugCommandRequest request, Context context) {
        return this.executeCommandWithResponseAsync(request, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)res.getValue());
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowDebugCommandResponse executeCommand(DataFlowDebugCommandRequest request) {
        return (DataFlowDebugCommandResponse)this.executeCommandAsync(request).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DataFlowDebugSessionsExecuteCommandResponse executeCommandWithResponse(DataFlowDebugCommandRequest request, Context context) {
        return (DataFlowDebugSessionsExecuteCommandResponse)((Object)this.executeCommandWithResponseAsync(request, context).block());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowDebugSessionInfo>> queryDataFlowDebugSessionsByWorkspaceNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryDataFlowDebugSessionsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getValue(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<DataFlowDebugSessionInfo>> queryDataFlowDebugSessionsByWorkspaceNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.queryDataFlowDebugSessionsByWorkspaceNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getValue(), ((QueryDataFlowDebugSessionsResponse)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientDataF")
    private static interface DataFlowDebugSessionsService {
        @Post(value="/createDataFlowDebugSession")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<DataFlowDebugSessionsCreateDataFlowDebugSessionResponse> createDataFlowDebugSession(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CreateDataFlowDebugSessionRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/queryDataFlowDebugSessions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<QueryDataFlowDebugSessionsResponse>> queryDataFlowDebugSessionsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/addDataFlowToDebugSession")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<AddDataFlowToDebugSessionResponse>> addDataFlow(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") DataFlowDebugPackage var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/deleteDataFlowDebugSession")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<Void>> deleteDataFlowDebugSession(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") DeleteDataFlowDebugSessionRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/executeDataFlowDebugCommand")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<DataFlowDebugSessionsExecuteCommandResponse> executeCommand(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") DataFlowDebugCommandRequest var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<QueryDataFlowDebugSessionsResponse>> queryDataFlowDebugSessionsByWorkspaceNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

