/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.CloudErrorAutoGeneratedException;
import com.azure.analytics.synapse.artifacts.models.LibraryListResponse;
import com.azure.analytics.synapse.artifacts.models.LibraryResource;
import com.azure.analytics.synapse.artifacts.models.LibraryResourceInfo;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class LibrariesImpl {
    private final LibrariesService service;
    private final ArtifactsClientImpl client;

    LibrariesImpl(ArtifactsClientImpl client) {
        this.service = (LibrariesService)RestProxy.create(LibrariesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LibraryResource>> listSinglePageAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LibraryListResponse)res.getValue()).getValue(), ((LibraryListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LibraryResource>> listSinglePageAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LibraryListResponse)res.getValue()).getValue(), ((LibraryListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LibraryResource> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<LibraryResource> listAsync(Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LibraryResource> list() {
        return new PagedIterable(this.listAsync());
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<LibraryResource> list(Context context) {
        return new PagedIterable(this.listAsync(context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> flushWithResponseAsync(String libraryName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.flush(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> flushWithResponseAsync(String libraryName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.flush(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> flushAsync(String libraryName) {
        return this.flushWithResponseAsync(libraryName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResourceInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> flushAsync(String libraryName, Context context) {
        return this.flushWithResponseAsync(libraryName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResourceInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResourceInfo flush(String libraryName) {
        return (LibraryResourceInfo)this.flushAsync(libraryName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResourceInfo> flushWithResponse(String libraryName, Context context) {
        return (Response)this.flushWithResponseAsync(libraryName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResource>> getOperationResultWithResponseAsync(String operationId) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getOperationResult(this.client.getEndpoint(), "2020-12-01", operationId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResource>> getOperationResultWithResponseAsync(String operationId, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getOperationResult(this.client.getEndpoint(), "2020-12-01", operationId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResource> getOperationResultAsync(String operationId) {
        return this.getOperationResultWithResponseAsync(operationId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResource> getOperationResultAsync(String operationId, Context context) {
        return this.getOperationResultWithResponseAsync(operationId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResource getOperationResult(String operationId) {
        return (LibraryResource)this.getOperationResultAsync(operationId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResource> getOperationResultWithResponse(String operationId, Context context) {
        return (Response)this.getOperationResultWithResponseAsync(operationId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> deleteWithResponseAsync(String libraryName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> deleteWithResponseAsync(String libraryName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.delete(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> deleteAsync(String libraryName) {
        return this.deleteWithResponseAsync(libraryName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResourceInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> deleteAsync(String libraryName, Context context) {
        return this.deleteWithResponseAsync(libraryName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResourceInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResourceInfo delete(String libraryName) {
        return (LibraryResourceInfo)this.deleteAsync(libraryName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResourceInfo> deleteWithResponse(String libraryName, Context context) {
        return (Response)this.deleteWithResponseAsync(libraryName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResource>> getWithResponseAsync(String libraryName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResource>> getWithResponseAsync(String libraryName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResource> getAsync(String libraryName) {
        return this.getWithResponseAsync(libraryName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResource> getAsync(String libraryName, Context context) {
        return this.getWithResponseAsync(libraryName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResource)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResource get(String libraryName) {
        return (LibraryResource)this.getAsync(libraryName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResource> getWithResponse(String libraryName, Context context) {
        return (Response)this.getWithResponseAsync(libraryName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> createWithResponseAsync(String libraryName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<LibraryResourceInfo>> createWithResponseAsync(String libraryName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.create(this.client.getEndpoint(), "2020-12-01", libraryName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> createAsync(String libraryName) {
        return this.createWithResponseAsync(libraryName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResourceInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<LibraryResourceInfo> createAsync(String libraryName, Context context) {
        return this.createWithResponseAsync(libraryName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((LibraryResourceInfo)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public LibraryResourceInfo create(String libraryName) {
        return (LibraryResourceInfo)this.createAsync(libraryName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<LibraryResourceInfo> createWithResponse(String libraryName, Context context) {
        return (Response)this.createWithResponseAsync(libraryName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponseAsync(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition) {
        String comp = "appendblock";
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.append(this.client.getEndpoint(), "appendblock", "2020-12-01", libraryName, blobConditionAppendPosition, content, contentLength, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> appendWithResponseAsync(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition, Context context) {
        String comp = "appendblock";
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.append(this.client.getEndpoint(), "appendblock", "2020-12-01", libraryName, blobConditionAppendPosition, content, contentLength, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendAsync(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition) {
        return this.appendWithResponseAsync(libraryName, content, contentLength, blobConditionAppendPosition).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendAsync(String libraryName, Flux<ByteBuffer> content, long contentLength) {
        Long blobConditionAppendPosition = null;
        return this.appendWithResponseAsync(libraryName, content, contentLength, blobConditionAppendPosition).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> appendAsync(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition, Context context) {
        return this.appendWithResponseAsync(libraryName, content, contentLength, blobConditionAppendPosition, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition) {
        this.appendAsync(libraryName, content, contentLength, blobConditionAppendPosition).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void append(String libraryName, Flux<ByteBuffer> content, long contentLength) {
        Long blobConditionAppendPosition = null;
        this.appendAsync(libraryName, content, contentLength, blobConditionAppendPosition).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> appendWithResponse(String libraryName, Flux<ByteBuffer> content, long contentLength, Long blobConditionAppendPosition, Context context) {
        return (Response)this.appendWithResponseAsync(libraryName, content, contentLength, blobConditionAppendPosition, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LibraryResource>> listNextSinglePageAsync(String nextLink) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LibraryListResponse)res.getValue()).getValue(), ((LibraryListResponse)res.getValue()).getNextLink(), null));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PagedResponse<LibraryResource>> listNextSinglePageAsync(String nextLink, Context context) {
        String accept = "application/json";
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((LibraryListResponse)res.getValue()).getValue(), ((LibraryListResponse)res.getValue()).getNextLink(), null));
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientLibra")
    private static interface LibrariesService {
        @Get(value="/libraries")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryListResponse>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Post(value="/libraries/{libraryName}/flush")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryResourceInfo>> flush(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="libraryName") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/libraryOperationResults/{operationId}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryResource>> getOperationResult(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="operationId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Delete(value="/libraries/{libraryName}")
        @ExpectedResponses(value={200, 202, 409})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryResourceInfo>> delete(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="libraryName") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/libraries/{libraryName}")
        @ExpectedResponses(value={200, 304})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryResource>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="libraryName") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/libraries/{libraryName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryResourceInfo>> create(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="libraryName") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Put(value="/libraries/{libraryName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<Void>> append(@HostParam(value="endpoint") String var1, @QueryParam(value="comp") String var2, @QueryParam(value="api-version") String var3, @PathParam(value="libraryName") String var4, @HeaderParam(value="x-ms-blob-condition-appendpos") Long var5, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var6, @HeaderParam(value="Content-Length") long var7, @HeaderParam(value="Accept") String var9, Context var10);

        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<LibraryListResponse>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="endpoint") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

