/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ActivityRunsQueryResponse;
import com.azure.analytics.synapse.artifacts.models.CloudErrorAutoGeneratedException;
import com.azure.analytics.synapse.artifacts.models.PipelineRun;
import com.azure.analytics.synapse.artifacts.models.PipelineRunsQueryResponse;
import com.azure.analytics.synapse.artifacts.models.RunFilterParameters;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class PipelineRunsImpl {
    private final PipelineRunsService service;
    private final ArtifactsClientImpl client;

    PipelineRunsImpl(ArtifactsClientImpl client) {
        this.service = (PipelineRunsService)RestProxy.create(PipelineRunsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineRunsQueryResponse>> queryPipelineRunsByWorkspaceWithResponseAsync(RunFilterParameters filterParameters) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryPipelineRunsByWorkspace(this.client.getEndpoint(), "2020-12-01", filterParameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineRunsQueryResponse>> queryPipelineRunsByWorkspaceWithResponseAsync(RunFilterParameters filterParameters, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.queryPipelineRunsByWorkspace(this.client.getEndpoint(), "2020-12-01", filterParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineRunsQueryResponse> queryPipelineRunsByWorkspaceAsync(RunFilterParameters filterParameters) {
        return this.queryPipelineRunsByWorkspaceWithResponseAsync(filterParameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PipelineRunsQueryResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineRunsQueryResponse> queryPipelineRunsByWorkspaceAsync(RunFilterParameters filterParameters, Context context) {
        return this.queryPipelineRunsByWorkspaceWithResponseAsync(filterParameters, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PipelineRunsQueryResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineRunsQueryResponse queryPipelineRunsByWorkspace(RunFilterParameters filterParameters) {
        return (PipelineRunsQueryResponse)this.queryPipelineRunsByWorkspaceAsync(filterParameters).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineRunsQueryResponse> queryPipelineRunsByWorkspaceWithResponse(RunFilterParameters filterParameters, Context context) {
        return (Response)this.queryPipelineRunsByWorkspaceWithResponseAsync(filterParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineRun>> getPipelineRunWithResponseAsync(String runId) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getPipelineRun(this.client.getEndpoint(), runId, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PipelineRun>> getPipelineRunWithResponseAsync(String runId, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.getPipelineRun(this.client.getEndpoint(), runId, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineRun> getPipelineRunAsync(String runId) {
        return this.getPipelineRunWithResponseAsync(runId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PipelineRun)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PipelineRun> getPipelineRunAsync(String runId, Context context) {
        return this.getPipelineRunWithResponseAsync(runId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((PipelineRun)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PipelineRun getPipelineRun(String runId) {
        return (PipelineRun)this.getPipelineRunAsync(runId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PipelineRun> getPipelineRunWithResponse(String runId, Context context) {
        return (Response)this.getPipelineRunWithResponseAsync(runId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ActivityRunsQueryResponse>> queryActivityRunsWithResponseAsync(String pipelineName, String runId, RunFilterParameters filterParameters) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.queryActivityRuns(this.client.getEndpoint(), pipelineName, runId, "2020-12-01", filterParameters, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ActivityRunsQueryResponse>> queryActivityRunsWithResponseAsync(String pipelineName, String runId, RunFilterParameters filterParameters, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.queryActivityRuns(this.client.getEndpoint(), pipelineName, runId, "2020-12-01", filterParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ActivityRunsQueryResponse> queryActivityRunsAsync(String pipelineName, String runId, RunFilterParameters filterParameters) {
        return this.queryActivityRunsWithResponseAsync(pipelineName, runId, filterParameters).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ActivityRunsQueryResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ActivityRunsQueryResponse> queryActivityRunsAsync(String pipelineName, String runId, RunFilterParameters filterParameters, Context context) {
        return this.queryActivityRunsWithResponseAsync(pipelineName, runId, filterParameters, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((ActivityRunsQueryResponse)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ActivityRunsQueryResponse queryActivityRuns(String pipelineName, String runId, RunFilterParameters filterParameters) {
        return (ActivityRunsQueryResponse)this.queryActivityRunsAsync(pipelineName, runId, filterParameters).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ActivityRunsQueryResponse> queryActivityRunsWithResponse(String pipelineName, String runId, RunFilterParameters filterParameters, Context context) {
        return (Response)this.queryActivityRunsWithResponseAsync(pipelineName, runId, filterParameters, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelPipelineRunWithResponseAsync(String runId, Boolean isRecursive) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelPipelineRun(this.client.getEndpoint(), runId, isRecursive, "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelPipelineRunWithResponseAsync(String runId, Boolean isRecursive, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.cancelPipelineRun(this.client.getEndpoint(), runId, isRecursive, "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelPipelineRunAsync(String runId, Boolean isRecursive) {
        return this.cancelPipelineRunWithResponseAsync(runId, isRecursive).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelPipelineRunAsync(String runId) {
        Boolean isRecursive = null;
        return this.cancelPipelineRunWithResponseAsync(runId, isRecursive).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelPipelineRunAsync(String runId, Boolean isRecursive, Context context) {
        return this.cancelPipelineRunWithResponseAsync(runId, isRecursive, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelPipelineRun(String runId, Boolean isRecursive) {
        this.cancelPipelineRunAsync(runId, isRecursive).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelPipelineRun(String runId) {
        Boolean isRecursive = null;
        this.cancelPipelineRunAsync(runId, isRecursive).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelPipelineRunWithResponse(String runId, Boolean isRecursive, Context context) {
        return (Response)this.cancelPipelineRunWithResponseAsync(runId, isRecursive, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientPipel")
    private static interface PipelineRunsService {
        @Post(value="/queryPipelineRuns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<PipelineRunsQueryResponse>> queryPipelineRunsByWorkspace(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RunFilterParameters var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Get(value="/pipelineruns/{runId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<PipelineRun>> getPipelineRun(@HostParam(value="endpoint") String var1, @PathParam(value="runId") String var2, @QueryParam(value="api-version") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Post(value="/pipelines/{pipelineName}/pipelineruns/{runId}/queryActivityruns")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<ActivityRunsQueryResponse>> queryActivityRuns(@HostParam(value="endpoint") String var1, @PathParam(value="pipelineName") String var2, @PathParam(value="runId") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RunFilterParameters var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/pipelineruns/{runId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CloudErrorAutoGeneratedException.class)
        public Mono<Response<Void>> cancelPipelineRun(@HostParam(value="endpoint") String var1, @PathParam(value="runId") String var2, @QueryParam(value="isRecursive") Boolean var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);
    }
}

