/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.artifacts.implementation;

import com.azure.analytics.synapse.artifacts.implementation.ArtifactsClientImpl;
import com.azure.analytics.synapse.artifacts.models.ErrorContractException;
import com.azure.analytics.synapse.artifacts.models.SqlPool;
import com.azure.analytics.synapse.artifacts.models.SqlPoolInfoListResult;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SqlPoolsImpl {
    private final SqlPoolsService service;
    private final ArtifactsClientImpl client;

    SqlPoolsImpl(ArtifactsClientImpl client) {
        this.service = (SqlPoolsService)RestProxy.create(SqlPoolsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlPoolInfoListResult>> listWithResponseAsync() {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlPoolInfoListResult>> listWithResponseAsync(Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.list(this.client.getEndpoint(), "2020-12-01", "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlPoolInfoListResult> listAsync() {
        return this.listWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SqlPoolInfoListResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlPoolInfoListResult> listAsync(Context context) {
        return this.listWithResponseAsync(context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SqlPoolInfoListResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlPoolInfoListResult list() {
        return (SqlPoolInfoListResult)this.listAsync().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlPoolInfoListResult> listWithResponse(Context context) {
        return (Response)this.listWithResponseAsync(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlPool>> getWithResponseAsync(String sqlPoolName) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), "2020-12-01", sqlPoolName, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SqlPool>> getWithResponseAsync(String sqlPoolName, Context context) {
        String apiVersion = "2020-12-01";
        String accept = "application/json";
        return this.service.get(this.client.getEndpoint(), "2020-12-01", sqlPoolName, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlPool> getAsync(String sqlPoolName) {
        return this.getWithResponseAsync(sqlPoolName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SqlPool)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SqlPool> getAsync(String sqlPoolName, Context context) {
        return this.getWithResponseAsync(sqlPoolName, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SqlPool)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SqlPool get(String sqlPoolName) {
        return (SqlPool)this.getAsync(sqlPoolName).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SqlPool> getWithResponse(String sqlPoolName, Context context) {
        return (Response)this.getWithResponseAsync(sqlPoolName, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="ArtifactsClientSqlPo")
    private static interface SqlPoolsService {
        @Get(value="/sqlPools")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<SqlPoolInfoListResult>> list(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Get(value="/sqlPools/{sqlPoolName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ErrorContractException.class)
        public Mono<Response<SqlPool>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="sqlPoolName") String var3, @HeaderParam(value="Accept") String var4, Context var5);
    }
}

