// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.analytics.synapse.spark;

import com.azure.analytics.synapse.spark.implementation.SparkBatchesImpl;
import com.azure.analytics.synapse.spark.models.SparkBatchJob;
import com.azure.analytics.synapse.spark.models.SparkBatchJobCollection;
import com.azure.analytics.synapse.spark.models.SparkBatchJobOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

/** Initializes a new instance of the asynchronous SparkClient type. */
@ServiceClient(builder = SparkClientBuilder.class, isAsync = true)
public final class SparkBatchAsyncClient {
    private final SparkBatchesImpl serviceClient;

    /**
     * Initializes an instance of SparkBatches client.
     *
     * @param serviceClient the service client implementation.
     */
    SparkBatchAsyncClient(SparkBatchesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    /**
     * List all spark batch jobs which are running under a particular spark pool.
     *
     * @param from Optional param specifying which index the list should begin from.
     * @param size Optional param specifying the size of the returned list. By default it is 20 and that is the maximum.
     * @param detailed Optional query param specifying whether detailed response is returned beyond plain livy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for batch list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SparkBatchJobCollection>> getSparkBatchJobsWithResponse(
            Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobsWithResponseAsync(from, size, detailed);
    }

    /**
     * List all spark batch jobs which are running under a particular spark pool.
     *
     * @param from Optional param specifying which index the list should begin from.
     * @param size Optional param specifying the size of the returned list. By default it is 20 and that is the maximum.
     * @param detailed Optional query param specifying whether detailed response is returned beyond plain livy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for batch list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobs(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobsAsync(from, size, detailed);
    }

    /**
     * List all spark batch jobs which are running under a particular spark pool.
     *
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for batch list operation.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobs() {
        return this.serviceClient.getSparkBatchJobsAsync();
    }

    /**
     * Create new spark batch job.
     *
     * @param sparkBatchJobOptions Livy compatible batch job request payload.
     * @param detailed Optional query param specifying whether detailed response is returned beyond plain livy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> createSparkBatchJobWithResponse(
            SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return this.serviceClient.createSparkBatchJobWithResponseAsync(sparkBatchJobOptions, detailed);
    }

    /**
     * Create new spark batch job.
     *
     * @param sparkBatchJobOptions Livy compatible batch job request payload.
     * @param detailed Optional query param specifying whether detailed response is returned beyond plain livy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return this.serviceClient.createSparkBatchJobAsync(sparkBatchJobOptions, detailed);
    }

    /**
     * Create new spark batch job.
     *
     * @param sparkBatchJobOptions Livy compatible batch job request payload.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions) {
        return this.serviceClient.createSparkBatchJobAsync(sparkBatchJobOptions);
    }

    /**
     * Gets a single spark batch job.
     *
     * @param batchId Identifier for the batch job.
     * @param detailed Optional query param specifying whether detailed response is returned beyond plain livy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single spark batch job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> getSparkBatchJobWithResponse(int batchId, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobWithResponseAsync(batchId, detailed);
    }

    /**
     * Gets a single spark batch job.
     *
     * @param batchId Identifier for the batch job.
     * @param detailed Optional query param specifying whether detailed response is returned beyond plain livy.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single spark batch job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJob(int batchId, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobAsync(batchId, detailed);
    }

    /**
     * Gets a single spark batch job.
     *
     * @param batchId Identifier for the batch job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single spark batch job.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJob(int batchId) {
        return this.serviceClient.getSparkBatchJobAsync(batchId);
    }

    /**
     * Cancels a running spark batch job.
     *
     * @param batchId Identifier for the batch job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkBatchJobWithResponse(int batchId) {
        return this.serviceClient.cancelSparkBatchJobWithResponseAsync(batchId);
    }

    /**
     * Cancels a running spark batch job.
     *
     * @param batchId Identifier for the batch job.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws HttpResponseException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the completion.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> cancelSparkBatchJob(int batchId) {
        return this.serviceClient.cancelSparkBatchJobAsync(batchId);
    }
}
