// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.analytics.synapse.spark.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for batch list operation. */
@Fluent
public final class SparkBatchJobCollection {
    /*
     * The start index of fetched sessions.
     */
    @JsonProperty(value = "from", required = true)
    private int from;

    /*
     * Number of sessions fetched.
     */
    @JsonProperty(value = "total", required = true)
    private int total;

    /*
     * Batch list
     */
    @JsonProperty(value = "sessions")
    private List<SparkBatchJob> sessions;

    /**
     * Get the from property: The start index of fetched sessions.
     *
     * @return the from value.
     */
    public int getFrom() {
        return this.from;
    }

    /**
     * Set the from property: The start index of fetched sessions.
     *
     * @param from the from value to set.
     * @return the SparkBatchJobCollection object itself.
     */
    public SparkBatchJobCollection setFrom(int from) {
        this.from = from;
        return this;
    }

    /**
     * Get the total property: Number of sessions fetched.
     *
     * @return the total value.
     */
    public int getTotal() {
        return this.total;
    }

    /**
     * Set the total property: Number of sessions fetched.
     *
     * @param total the total value to set.
     * @return the SparkBatchJobCollection object itself.
     */
    public SparkBatchJobCollection setTotal(int total) {
        this.total = total;
        return this;
    }

    /**
     * Get the sessions property: Batch list.
     *
     * @return the sessions value.
     */
    public List<SparkBatchJob> getSessions() {
        return this.sessions;
    }

    /**
     * Set the sessions property: Batch list.
     *
     * @param sessions the sessions value to set.
     * @return the SparkBatchJobCollection object itself.
     */
    public SparkBatchJobCollection setSessions(List<SparkBatchJob> sessions) {
        this.sessions = sessions;
        return this;
    }
}
