// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.analytics.synapse.spark.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SparkBatchJobResultType. */
public final class SparkBatchJobResultType extends ExpandableStringEnum<SparkBatchJobResultType> {
    /** Static value Uncertain for SparkBatchJobResultType. */
    public static final SparkBatchJobResultType UNCERTAIN = fromString("Uncertain");

    /** Static value Succeeded for SparkBatchJobResultType. */
    public static final SparkBatchJobResultType SUCCEEDED = fromString("Succeeded");

    /** Static value Failed for SparkBatchJobResultType. */
    public static final SparkBatchJobResultType FAILED = fromString("Failed");

    /** Static value Cancelled for SparkBatchJobResultType. */
    public static final SparkBatchJobResultType CANCELLED = fromString("Cancelled");

    /**
     * Creates or finds a SparkBatchJobResultType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SparkBatchJobResultType.
     */
    @JsonCreator
    public static SparkBatchJobResultType fromString(String name) {
        return fromString(name, SparkBatchJobResultType.class);
    }

    /** @return known SparkBatchJobResultType values. */
    public static Collection<SparkBatchJobResultType> values() {
        return values(SparkBatchJobResultType.class);
    }
}
