// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.analytics.synapse.spark.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;

/** The SparkBatchJobState model. */
@Fluent
public final class SparkBatchJobState {
    /*
     * the time that at which "not_started" livy state was first seen.
     */
    @JsonProperty(value = "notStartedAt")
    private OffsetDateTime notStartedAt;

    /*
     * the time that at which "starting" livy state was first seen.
     */
    @JsonProperty(value = "startingAt")
    private OffsetDateTime startingAt;

    /*
     * the time that at which "running" livy state was first seen.
     */
    @JsonProperty(value = "runningAt")
    private OffsetDateTime runningAt;

    /*
     * time that at which "dead" livy state was first seen.
     */
    @JsonProperty(value = "deadAt")
    private OffsetDateTime deadAt;

    /*
     * the time that at which "success" livy state was first seen.
     */
    @JsonProperty(value = "successAt")
    private OffsetDateTime successAt;

    /*
     * the time that at which "killed" livy state was first seen.
     */
    @JsonProperty(value = "killedAt")
    private OffsetDateTime terminatedAt;

    /*
     * the time that at which "recovering" livy state was first seen.
     */
    @JsonProperty(value = "recoveringAt")
    private OffsetDateTime recoveringAt;

    /*
     * the Spark job state.
     */
    @JsonProperty(value = "currentState")
    private String currentState;

    /*
     * The jobCreationRequest property.
     */
    @JsonProperty(value = "jobCreationRequest")
    private SparkRequest jobCreationRequest;

    /**
     * Get the notStartedAt property: the time that at which "not_started" livy state was first seen.
     *
     * @return the notStartedAt value.
     */
    public OffsetDateTime getNotStartedAt() {
        return this.notStartedAt;
    }

    /**
     * Set the notStartedAt property: the time that at which "not_started" livy state was first seen.
     *
     * @param notStartedAt the notStartedAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setNotStartedAt(OffsetDateTime notStartedAt) {
        this.notStartedAt = notStartedAt;
        return this;
    }

    /**
     * Get the startingAt property: the time that at which "starting" livy state was first seen.
     *
     * @return the startingAt value.
     */
    public OffsetDateTime getStartingAt() {
        return this.startingAt;
    }

    /**
     * Set the startingAt property: the time that at which "starting" livy state was first seen.
     *
     * @param startingAt the startingAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setStartingAt(OffsetDateTime startingAt) {
        this.startingAt = startingAt;
        return this;
    }

    /**
     * Get the runningAt property: the time that at which "running" livy state was first seen.
     *
     * @return the runningAt value.
     */
    public OffsetDateTime getRunningAt() {
        return this.runningAt;
    }

    /**
     * Set the runningAt property: the time that at which "running" livy state was first seen.
     *
     * @param runningAt the runningAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setRunningAt(OffsetDateTime runningAt) {
        this.runningAt = runningAt;
        return this;
    }

    /**
     * Get the deadAt property: time that at which "dead" livy state was first seen.
     *
     * @return the deadAt value.
     */
    public OffsetDateTime getDeadAt() {
        return this.deadAt;
    }

    /**
     * Set the deadAt property: time that at which "dead" livy state was first seen.
     *
     * @param deadAt the deadAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setDeadAt(OffsetDateTime deadAt) {
        this.deadAt = deadAt;
        return this;
    }

    /**
     * Get the successAt property: the time that at which "success" livy state was first seen.
     *
     * @return the successAt value.
     */
    public OffsetDateTime getSuccessAt() {
        return this.successAt;
    }

    /**
     * Set the successAt property: the time that at which "success" livy state was first seen.
     *
     * @param successAt the successAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setSuccessAt(OffsetDateTime successAt) {
        this.successAt = successAt;
        return this;
    }

    /**
     * Get the terminatedAt property: the time that at which "killed" livy state was first seen.
     *
     * @return the terminatedAt value.
     */
    public OffsetDateTime getTerminatedAt() {
        return this.terminatedAt;
    }

    /**
     * Set the terminatedAt property: the time that at which "killed" livy state was first seen.
     *
     * @param terminatedAt the terminatedAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setTerminatedAt(OffsetDateTime terminatedAt) {
        this.terminatedAt = terminatedAt;
        return this;
    }

    /**
     * Get the recoveringAt property: the time that at which "recovering" livy state was first seen.
     *
     * @return the recoveringAt value.
     */
    public OffsetDateTime getRecoveringAt() {
        return this.recoveringAt;
    }

    /**
     * Set the recoveringAt property: the time that at which "recovering" livy state was first seen.
     *
     * @param recoveringAt the recoveringAt value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setRecoveringAt(OffsetDateTime recoveringAt) {
        this.recoveringAt = recoveringAt;
        return this;
    }

    /**
     * Get the currentState property: the Spark job state.
     *
     * @return the currentState value.
     */
    public String getCurrentState() {
        return this.currentState;
    }

    /**
     * Set the currentState property: the Spark job state.
     *
     * @param currentState the currentState value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setCurrentState(String currentState) {
        this.currentState = currentState;
        return this;
    }

    /**
     * Get the jobCreationRequest property: The jobCreationRequest property.
     *
     * @return the jobCreationRequest value.
     */
    public SparkRequest getJobCreationRequest() {
        return this.jobCreationRequest;
    }

    /**
     * Set the jobCreationRequest property: The jobCreationRequest property.
     *
     * @param jobCreationRequest the jobCreationRequest value to set.
     * @return the SparkBatchJobState object itself.
     */
    public SparkBatchJobState setJobCreationRequest(SparkRequest jobCreationRequest) {
        this.jobCreationRequest = jobCreationRequest;
        return this;
    }
}
