// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.analytics.synapse.spark.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SparkJobType. */
public final class SparkJobType extends ExpandableStringEnum<SparkJobType> {
    /** Static value SparkBatch for SparkJobType. */
    public static final SparkJobType SPARK_BATCH = fromString("SparkBatch");

    /** Static value SparkSession for SparkJobType. */
    public static final SparkJobType SPARK_SESSION = fromString("SparkSession");

    /**
     * Creates or finds a SparkJobType from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SparkJobType.
     */
    @JsonCreator
    public static SparkJobType fromString(String name) {
        return fromString(name, SparkJobType.class);
    }

    /** @return known SparkJobType values. */
    public static Collection<SparkJobType> values() {
        return values(SparkJobType.class);
    }
}
