// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.analytics.synapse.spark.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The SparkStatementOutput model. */
@Fluent
public final class SparkStatementOutput {
    /*
     * The status property.
     */
    @JsonProperty(value = "status")
    private String status;

    /*
     * The execution_count property.
     */
    @JsonProperty(value = "execution_count", required = true)
    private int executionCount;

    /*
     * Any object
     */
    @JsonProperty(value = "data")
    private Object data;

    /*
     * The ename property.
     */
    @JsonProperty(value = "ename")
    private String errorName;

    /*
     * The evalue property.
     */
    @JsonProperty(value = "evalue")
    private String errorValue;

    /*
     * The traceback property.
     */
    @JsonProperty(value = "traceback")
    private List<String> traceback;

    /**
     * Get the status property: The status property.
     *
     * @return the status value.
     */
    public String getStatus() {
        return this.status;
    }

    /**
     * Set the status property: The status property.
     *
     * @param status the status value to set.
     * @return the SparkStatementOutput object itself.
     */
    public SparkStatementOutput setStatus(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get the executionCount property: The execution_count property.
     *
     * @return the executionCount value.
     */
    public int getExecutionCount() {
        return this.executionCount;
    }

    /**
     * Set the executionCount property: The execution_count property.
     *
     * @param executionCount the executionCount value to set.
     * @return the SparkStatementOutput object itself.
     */
    public SparkStatementOutput setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
        return this;
    }

    /**
     * Get the data property: Any object.
     *
     * @return the data value.
     */
    public Object getData() {
        return this.data;
    }

    /**
     * Set the data property: Any object.
     *
     * @param data the data value to set.
     * @return the SparkStatementOutput object itself.
     */
    public SparkStatementOutput setData(Object data) {
        this.data = data;
        return this;
    }

    /**
     * Get the errorName property: The ename property.
     *
     * @return the errorName value.
     */
    public String getErrorName() {
        return this.errorName;
    }

    /**
     * Set the errorName property: The ename property.
     *
     * @param errorName the errorName value to set.
     * @return the SparkStatementOutput object itself.
     */
    public SparkStatementOutput setErrorName(String errorName) {
        this.errorName = errorName;
        return this;
    }

    /**
     * Get the errorValue property: The evalue property.
     *
     * @return the errorValue value.
     */
    public String getErrorValue() {
        return this.errorValue;
    }

    /**
     * Set the errorValue property: The evalue property.
     *
     * @param errorValue the errorValue value to set.
     * @return the SparkStatementOutput object itself.
     */
    public SparkStatementOutput setErrorValue(String errorValue) {
        this.errorValue = errorValue;
        return this;
    }

    /**
     * Get the traceback property: The traceback property.
     *
     * @return the traceback value.
     */
    public List<String> getTraceback() {
        return this.traceback;
    }

    /**
     * Set the traceback property: The traceback property.
     *
     * @param traceback the traceback value to set.
     * @return the SparkStatementOutput object itself.
     */
    public SparkStatementOutput setTraceback(List<String> traceback) {
        this.traceback = traceback;
        return this;
    }
}
