/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark;

import com.azure.analytics.synapse.spark.SparkClientBuilder;
import com.azure.analytics.synapse.spark.implementation.SparkBatchesImpl;
import com.azure.analytics.synapse.spark.models.SparkBatchJob;
import com.azure.analytics.synapse.spark.models.SparkBatchJobCollection;
import com.azure.analytics.synapse.spark.models.SparkBatchJobOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SparkClientBuilder.class, isAsync=true)
public final class SparkBatchAsyncClient {
    private final SparkBatchesImpl serviceClient;

    SparkBatchAsyncClient(SparkBatchesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJobCollection>> getSparkBatchJobsWithResponse(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobsWithResponseAsync(from, size, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobs(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobsAsync(from, size, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobs() {
        return this.serviceClient.getSparkBatchJobsAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> createSparkBatchJobWithResponse(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return this.serviceClient.createSparkBatchJobWithResponseAsync(sparkBatchJobOptions, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return this.serviceClient.createSparkBatchJobAsync(sparkBatchJobOptions, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions) {
        return this.serviceClient.createSparkBatchJobAsync(sparkBatchJobOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> getSparkBatchJobWithResponse(int batchId, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobWithResponseAsync(batchId, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJob(int batchId, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobAsync(batchId, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJob(int batchId) {
        return this.serviceClient.getSparkBatchJobAsync(batchId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkBatchJobWithResponse(int batchId) {
        return this.serviceClient.cancelSparkBatchJobWithResponseAsync(batchId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelSparkBatchJob(int batchId) {
        return this.serviceClient.cancelSparkBatchJobAsync(batchId);
    }
}

