/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark;

import com.azure.analytics.synapse.spark.SparkClientBuilder;
import com.azure.analytics.synapse.spark.implementation.SparkBatchesImpl;
import com.azure.analytics.synapse.spark.models.SparkBatchJob;
import com.azure.analytics.synapse.spark.models.SparkBatchJobCollection;
import com.azure.analytics.synapse.spark.models.SparkBatchJobOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=SparkClientBuilder.class)
public final class SparkBatchClient {
    private final SparkBatchesImpl serviceClient;

    SparkBatchClient(SparkBatchesImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJobCollection getSparkBatchJobs(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkBatchJobs(from, size, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJobCollection getSparkBatchJobs() {
        return this.serviceClient.getSparkBatchJobs();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJobCollection> getSparkBatchJobsWithResponse(Integer from, Integer size, Boolean detailed, Context context) {
        return this.serviceClient.getSparkBatchJobsWithResponse(from, size, detailed, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return this.serviceClient.createSparkBatchJob(sparkBatchJobOptions, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions) {
        return this.serviceClient.createSparkBatchJob(sparkBatchJobOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> createSparkBatchJobWithResponse(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed, Context context) {
        return this.serviceClient.createSparkBatchJobWithResponse(sparkBatchJobOptions, detailed, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob getSparkBatchJob(int batchId, Boolean detailed) {
        return this.serviceClient.getSparkBatchJob(batchId, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob getSparkBatchJob(int batchId) {
        return this.serviceClient.getSparkBatchJob(batchId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> getSparkBatchJobWithResponse(int batchId, Boolean detailed, Context context) {
        return this.serviceClient.getSparkBatchJobWithResponse(batchId, detailed, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelSparkBatchJob(int batchId) {
        this.serviceClient.cancelSparkBatchJob(batchId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelSparkBatchJobWithResponse(int batchId, Context context) {
        return this.serviceClient.cancelSparkBatchJobWithResponse(batchId, context);
    }
}

