/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark;

import com.azure.analytics.synapse.spark.SparkClientBuilder;
import com.azure.analytics.synapse.spark.implementation.SparkSessionsImpl;
import com.azure.analytics.synapse.spark.models.SparkSession;
import com.azure.analytics.synapse.spark.models.SparkSessionCollection;
import com.azure.analytics.synapse.spark.models.SparkSessionOptions;
import com.azure.analytics.synapse.spark.models.SparkStatement;
import com.azure.analytics.synapse.spark.models.SparkStatementCancellationResult;
import com.azure.analytics.synapse.spark.models.SparkStatementCollection;
import com.azure.analytics.synapse.spark.models.SparkStatementOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SparkClientBuilder.class, isAsync=true)
public final class SparkSessionAsyncClient {
    private final SparkSessionsImpl serviceClient;

    SparkSessionAsyncClient(SparkSessionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSessionCollection>> getSparkSessionsWithResponse(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkSessionsWithResponseAsync(from, size, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSessionCollection> getSparkSessions(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkSessionsAsync(from, size, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSessionCollection> getSparkSessions() {
        return this.serviceClient.getSparkSessionsAsync();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSession>> createSparkSessionWithResponse(SparkSessionOptions sparkSessionOptions, Boolean detailed) {
        return this.serviceClient.createSparkSessionWithResponseAsync(sparkSessionOptions, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> createSparkSession(SparkSessionOptions sparkSessionOptions, Boolean detailed) {
        return this.serviceClient.createSparkSessionAsync(sparkSessionOptions, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> createSparkSession(SparkSessionOptions sparkSessionOptions) {
        return this.serviceClient.createSparkSessionAsync(sparkSessionOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSession>> getSparkSessionWithResponse(int sessionId, Boolean detailed) {
        return this.serviceClient.getSparkSessionWithResponseAsync(sessionId, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> getSparkSession(int sessionId, Boolean detailed) {
        return this.serviceClient.getSparkSessionAsync(sessionId, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> getSparkSession(int sessionId) {
        return this.serviceClient.getSparkSessionAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkSessionWithResponse(int sessionId) {
        return this.serviceClient.cancelSparkSessionWithResponseAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelSparkSession(int sessionId) {
        return this.serviceClient.cancelSparkSessionAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetSparkSessionTimeoutWithResponse(int sessionId) {
        return this.serviceClient.resetSparkSessionTimeoutWithResponseAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetSparkSessionTimeout(int sessionId) {
        return this.serviceClient.resetSparkSessionTimeoutAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatementCollection>> getSparkStatementsWithResponse(int sessionId) {
        return this.serviceClient.getSparkStatementsWithResponseAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatementCollection> getSparkStatements(int sessionId) {
        return this.serviceClient.getSparkStatementsAsync(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatement>> createSparkStatementWithResponse(int sessionId, SparkStatementOptions sparkStatementOptions) {
        return this.serviceClient.createSparkStatementWithResponseAsync(sessionId, sparkStatementOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatement> createSparkStatement(int sessionId, SparkStatementOptions sparkStatementOptions) {
        return this.serviceClient.createSparkStatementAsync(sessionId, sparkStatementOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatement>> getSparkStatementWithResponse(int sessionId, int statementId) {
        return this.serviceClient.getSparkStatementWithResponseAsync(sessionId, statementId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatement> getSparkStatement(int sessionId, int statementId) {
        return this.serviceClient.getSparkStatementAsync(sessionId, statementId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatementCancellationResult>> cancelSparkStatementWithResponse(int sessionId, int statementId) {
        return this.serviceClient.cancelSparkStatementWithResponseAsync(sessionId, statementId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatementCancellationResult> cancelSparkStatement(int sessionId, int statementId) {
        return this.serviceClient.cancelSparkStatementAsync(sessionId, statementId);
    }
}

