/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark;

import com.azure.analytics.synapse.spark.SparkClientBuilder;
import com.azure.analytics.synapse.spark.implementation.SparkSessionsImpl;
import com.azure.analytics.synapse.spark.models.SparkSession;
import com.azure.analytics.synapse.spark.models.SparkSessionCollection;
import com.azure.analytics.synapse.spark.models.SparkSessionOptions;
import com.azure.analytics.synapse.spark.models.SparkStatement;
import com.azure.analytics.synapse.spark.models.SparkStatementCancellationResult;
import com.azure.analytics.synapse.spark.models.SparkStatementCollection;
import com.azure.analytics.synapse.spark.models.SparkStatementOptions;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

@ServiceClient(builder=SparkClientBuilder.class)
public final class SparkSessionClient {
    private final SparkSessionsImpl serviceClient;

    SparkSessionClient(SparkSessionsImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSessionCollection getSparkSessions(Integer from, Integer size, Boolean detailed) {
        return this.serviceClient.getSparkSessions(from, size, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSessionCollection getSparkSessions() {
        return this.serviceClient.getSparkSessions();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkSessionCollection> getSparkSessionsWithResponse(Integer from, Integer size, Boolean detailed, Context context) {
        return this.serviceClient.getSparkSessionsWithResponse(from, size, detailed, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession createSparkSession(SparkSessionOptions sparkSessionOptions, Boolean detailed) {
        return this.serviceClient.createSparkSession(sparkSessionOptions, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession createSparkSession(SparkSessionOptions sparkSessionOptions) {
        return this.serviceClient.createSparkSession(sparkSessionOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkSession> createSparkSessionWithResponse(SparkSessionOptions sparkSessionOptions, Boolean detailed, Context context) {
        return this.serviceClient.createSparkSessionWithResponse(sparkSessionOptions, detailed, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession getSparkSession(int sessionId, Boolean detailed) {
        return this.serviceClient.getSparkSession(sessionId, detailed);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession getSparkSession(int sessionId) {
        return this.serviceClient.getSparkSession(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkSession> getSparkSessionWithResponse(int sessionId, Boolean detailed, Context context) {
        return this.serviceClient.getSparkSessionWithResponse(sessionId, detailed, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelSparkSession(int sessionId) {
        this.serviceClient.cancelSparkSession(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelSparkSessionWithResponse(int sessionId, Context context) {
        return this.serviceClient.cancelSparkSessionWithResponse(sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetSparkSessionTimeout(int sessionId) {
        this.serviceClient.resetSparkSessionTimeout(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetSparkSessionTimeoutWithResponse(int sessionId, Context context) {
        return this.serviceClient.resetSparkSessionTimeoutWithResponse(sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatementCollection getSparkStatements(int sessionId) {
        return this.serviceClient.getSparkStatements(sessionId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatementCollection> getSparkStatementsWithResponse(int sessionId, Context context) {
        return this.serviceClient.getSparkStatementsWithResponse(sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatement createSparkStatement(int sessionId, SparkStatementOptions sparkStatementOptions) {
        return this.serviceClient.createSparkStatement(sessionId, sparkStatementOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatement> createSparkStatementWithResponse(int sessionId, SparkStatementOptions sparkStatementOptions, Context context) {
        return this.serviceClient.createSparkStatementWithResponse(sessionId, sparkStatementOptions, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatement getSparkStatement(int sessionId, int statementId) {
        return this.serviceClient.getSparkStatement(sessionId, statementId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatement> getSparkStatementWithResponse(int sessionId, int statementId, Context context) {
        return this.serviceClient.getSparkStatementWithResponse(sessionId, statementId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatementCancellationResult cancelSparkStatement(int sessionId, int statementId) {
        return this.serviceClient.cancelSparkStatement(sessionId, statementId);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatementCancellationResult> cancelSparkStatementWithResponse(int sessionId, int statementId, Context context) {
        return this.serviceClient.cancelSparkStatementWithResponse(sessionId, statementId, context);
    }
}

