/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark.implementation;

import com.azure.analytics.synapse.spark.implementation.SparkClientImpl;
import com.azure.analytics.synapse.spark.models.SparkBatchJob;
import com.azure.analytics.synapse.spark.models.SparkBatchJobCollection;
import com.azure.analytics.synapse.spark.models.SparkBatchJobOptions;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SparkBatchesImpl {
    private final SparkBatchesService service;
    private final SparkClientImpl client;

    SparkBatchesImpl(SparkClientImpl client) {
        this.service = (SparkBatchesService)RestProxy.create(SparkBatchesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJobCollection>> getSparkBatchJobsWithResponseAsync(Integer from, Integer size, Boolean detailed) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkBatchJobs(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), from, size, detailed, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJobCollection>> getSparkBatchJobsWithResponseAsync(Integer from, Integer size, Boolean detailed, Context context) {
        String accept = "application/json";
        return this.service.getSparkBatchJobs(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), from, size, detailed, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobsAsync(Integer from, Integer size, Boolean detailed) {
        return this.getSparkBatchJobsWithResponseAsync(from, size, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJobCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobsAsync() {
        Integer from = null;
        Integer size = null;
        Boolean detailed = null;
        return this.getSparkBatchJobsWithResponseAsync(from, size, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJobCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJobCollection> getSparkBatchJobsAsync(Integer from, Integer size, Boolean detailed, Context context) {
        return this.getSparkBatchJobsWithResponseAsync(from, size, detailed, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJobCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJobCollection getSparkBatchJobs(Integer from, Integer size, Boolean detailed) {
        return (SparkBatchJobCollection)this.getSparkBatchJobsAsync(from, size, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJobCollection getSparkBatchJobs() {
        Integer from = null;
        Integer size = null;
        Boolean detailed = null;
        return (SparkBatchJobCollection)this.getSparkBatchJobsAsync(from, size, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJobCollection> getSparkBatchJobsWithResponse(Integer from, Integer size, Boolean detailed, Context context) {
        return (Response)this.getSparkBatchJobsWithResponseAsync(from, size, detailed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> createSparkBatchJobWithResponseAsync(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createSparkBatchJob(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), detailed, sparkBatchJobOptions, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> createSparkBatchJobWithResponseAsync(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed, Context context) {
        String accept = "application/json";
        return this.service.createSparkBatchJob(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), detailed, sparkBatchJobOptions, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJobAsync(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return this.createSparkBatchJobWithResponseAsync(sparkBatchJobOptions, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJob)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJobAsync(SparkBatchJobOptions sparkBatchJobOptions) {
        Boolean detailed = null;
        return this.createSparkBatchJobWithResponseAsync(sparkBatchJobOptions, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJob)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> createSparkBatchJobAsync(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed, Context context) {
        return this.createSparkBatchJobWithResponseAsync(sparkBatchJobOptions, detailed, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJob)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed) {
        return (SparkBatchJob)this.createSparkBatchJobAsync(sparkBatchJobOptions, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob createSparkBatchJob(SparkBatchJobOptions sparkBatchJobOptions) {
        Boolean detailed = null;
        return (SparkBatchJob)this.createSparkBatchJobAsync(sparkBatchJobOptions, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> createSparkBatchJobWithResponse(SparkBatchJobOptions sparkBatchJobOptions, Boolean detailed, Context context) {
        return (Response)this.createSparkBatchJobWithResponseAsync(sparkBatchJobOptions, detailed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> getSparkBatchJobWithResponseAsync(int batchId, Boolean detailed) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkBatchJob(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), batchId, detailed, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkBatchJob>> getSparkBatchJobWithResponseAsync(int batchId, Boolean detailed, Context context) {
        String accept = "application/json";
        return this.service.getSparkBatchJob(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), batchId, detailed, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJobAsync(int batchId, Boolean detailed) {
        return this.getSparkBatchJobWithResponseAsync(batchId, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJob)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJobAsync(int batchId) {
        Boolean detailed = null;
        return this.getSparkBatchJobWithResponseAsync(batchId, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJob)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkBatchJob> getSparkBatchJobAsync(int batchId, Boolean detailed, Context context) {
        return this.getSparkBatchJobWithResponseAsync(batchId, detailed, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkBatchJob)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob getSparkBatchJob(int batchId, Boolean detailed) {
        return (SparkBatchJob)this.getSparkBatchJobAsync(batchId, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkBatchJob getSparkBatchJob(int batchId) {
        Boolean detailed = null;
        return (SparkBatchJob)this.getSparkBatchJobAsync(batchId, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkBatchJob> getSparkBatchJobWithResponse(int batchId, Boolean detailed, Context context) {
        return (Response)this.getSparkBatchJobWithResponseAsync(batchId, detailed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkBatchJobWithResponseAsync(int batchId) {
        return FluxUtil.withContext(context -> this.service.cancelSparkBatchJob(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), batchId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkBatchJobWithResponseAsync(int batchId, Context context) {
        return this.service.cancelSparkBatchJob(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), batchId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelSparkBatchJobAsync(int batchId) {
        return this.cancelSparkBatchJobWithResponseAsync(batchId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelSparkBatchJobAsync(int batchId, Context context) {
        return this.cancelSparkBatchJobWithResponseAsync(batchId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelSparkBatchJob(int batchId) {
        this.cancelSparkBatchJobAsync(batchId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelSparkBatchJobWithResponse(int batchId, Context context) {
        return (Response)this.cancelSparkBatchJobWithResponseAsync(batchId, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SparkClientSparkBatc")
    private static interface SparkBatchesService {
        @Get(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/batches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkBatchJobCollection>> getSparkBatchJobs(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @QueryParam(value="from") Integer var4, @QueryParam(value="size") Integer var5, @QueryParam(value="detailed") Boolean var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/batches")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkBatchJob>> createSparkBatchJob(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @QueryParam(value="detailed") Boolean var4, @BodyParam(value="application/json") SparkBatchJobOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/batches/{batchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkBatchJob>> getSparkBatchJob(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="batchId") int var4, @QueryParam(value="detailed") Boolean var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/batches/{batchId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> cancelSparkBatchJob(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="batchId") int var4, Context var5);
    }
}

