/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark.implementation;

import com.azure.analytics.synapse.spark.implementation.SparkBatchesImpl;
import com.azure.analytics.synapse.spark.implementation.SparkSessionsImpl;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;

public final class SparkClientImpl {
    private final String endpoint;
    private final String livyApiVersion;
    private final String sparkPoolName;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final SparkBatchesImpl sparkBatches;
    private final SparkSessionsImpl sparkSessions;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getLivyApiVersion() {
        return this.livyApiVersion;
    }

    public String getSparkPoolName() {
        return this.sparkPoolName;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public SparkBatchesImpl getSparkBatches() {
        return this.sparkBatches;
    }

    public SparkSessionsImpl getSparkSessions() {
        return this.sparkSessions;
    }

    public SparkClientImpl(String endpoint, String livyApiVersion, String sparkPoolName) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy(), new CookiePolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, livyApiVersion, sparkPoolName);
    }

    public SparkClientImpl(HttpPipeline httpPipeline, String endpoint, String livyApiVersion, String sparkPoolName) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, livyApiVersion, sparkPoolName);
    }

    public SparkClientImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String livyApiVersion, String sparkPoolName) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.livyApiVersion = livyApiVersion;
        this.sparkPoolName = sparkPoolName;
        this.sparkBatches = new SparkBatchesImpl(this);
        this.sparkSessions = new SparkSessionsImpl(this);
    }
}

