/*
 * Decompiled with CFR 0.152.
 */
package com.azure.analytics.synapse.spark.implementation;

import com.azure.analytics.synapse.spark.implementation.SparkClientImpl;
import com.azure.analytics.synapse.spark.models.SparkSession;
import com.azure.analytics.synapse.spark.models.SparkSessionCollection;
import com.azure.analytics.synapse.spark.models.SparkSessionOptions;
import com.azure.analytics.synapse.spark.models.SparkStatement;
import com.azure.analytics.synapse.spark.models.SparkStatementCancellationResult;
import com.azure.analytics.synapse.spark.models.SparkStatementCollection;
import com.azure.analytics.synapse.spark.models.SparkStatementOptions;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import reactor.core.publisher.Mono;

public final class SparkSessionsImpl {
    private final SparkSessionsService service;
    private final SparkClientImpl client;

    SparkSessionsImpl(SparkClientImpl client) {
        this.service = (SparkSessionsService)RestProxy.create(SparkSessionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSessionCollection>> getSparkSessionsWithResponseAsync(Integer from, Integer size, Boolean detailed) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkSessions(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), from, size, detailed, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSessionCollection>> getSparkSessionsWithResponseAsync(Integer from, Integer size, Boolean detailed, Context context) {
        String accept = "application/json";
        return this.service.getSparkSessions(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), from, size, detailed, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSessionCollection> getSparkSessionsAsync(Integer from, Integer size, Boolean detailed) {
        return this.getSparkSessionsWithResponseAsync(from, size, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSessionCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSessionCollection> getSparkSessionsAsync() {
        Integer from = null;
        Integer size = null;
        Boolean detailed = null;
        return this.getSparkSessionsWithResponseAsync(from, size, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSessionCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSessionCollection> getSparkSessionsAsync(Integer from, Integer size, Boolean detailed, Context context) {
        return this.getSparkSessionsWithResponseAsync(from, size, detailed, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSessionCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSessionCollection getSparkSessions(Integer from, Integer size, Boolean detailed) {
        return (SparkSessionCollection)this.getSparkSessionsAsync(from, size, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSessionCollection getSparkSessions() {
        Integer from = null;
        Integer size = null;
        Boolean detailed = null;
        return (SparkSessionCollection)this.getSparkSessionsAsync(from, size, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkSessionCollection> getSparkSessionsWithResponse(Integer from, Integer size, Boolean detailed, Context context) {
        return (Response)this.getSparkSessionsWithResponseAsync(from, size, detailed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSession>> createSparkSessionWithResponseAsync(SparkSessionOptions sparkSessionOptions, Boolean detailed) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createSparkSession(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), detailed, sparkSessionOptions, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSession>> createSparkSessionWithResponseAsync(SparkSessionOptions sparkSessionOptions, Boolean detailed, Context context) {
        String accept = "application/json";
        return this.service.createSparkSession(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), detailed, sparkSessionOptions, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> createSparkSessionAsync(SparkSessionOptions sparkSessionOptions, Boolean detailed) {
        return this.createSparkSessionWithResponseAsync(sparkSessionOptions, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSession)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> createSparkSessionAsync(SparkSessionOptions sparkSessionOptions) {
        Boolean detailed = null;
        return this.createSparkSessionWithResponseAsync(sparkSessionOptions, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSession)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> createSparkSessionAsync(SparkSessionOptions sparkSessionOptions, Boolean detailed, Context context) {
        return this.createSparkSessionWithResponseAsync(sparkSessionOptions, detailed, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSession)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession createSparkSession(SparkSessionOptions sparkSessionOptions, Boolean detailed) {
        return (SparkSession)this.createSparkSessionAsync(sparkSessionOptions, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession createSparkSession(SparkSessionOptions sparkSessionOptions) {
        Boolean detailed = null;
        return (SparkSession)this.createSparkSessionAsync(sparkSessionOptions, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkSession> createSparkSessionWithResponse(SparkSessionOptions sparkSessionOptions, Boolean detailed, Context context) {
        return (Response)this.createSparkSessionWithResponseAsync(sparkSessionOptions, detailed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSession>> getSparkSessionWithResponseAsync(int sessionId, Boolean detailed) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkSession(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, detailed, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkSession>> getSparkSessionWithResponseAsync(int sessionId, Boolean detailed, Context context) {
        String accept = "application/json";
        return this.service.getSparkSession(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, detailed, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> getSparkSessionAsync(int sessionId, Boolean detailed) {
        return this.getSparkSessionWithResponseAsync(sessionId, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSession)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> getSparkSessionAsync(int sessionId) {
        Boolean detailed = null;
        return this.getSparkSessionWithResponseAsync(sessionId, detailed).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSession)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkSession> getSparkSessionAsync(int sessionId, Boolean detailed, Context context) {
        return this.getSparkSessionWithResponseAsync(sessionId, detailed, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkSession)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession getSparkSession(int sessionId, Boolean detailed) {
        return (SparkSession)this.getSparkSessionAsync(sessionId, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkSession getSparkSession(int sessionId) {
        Boolean detailed = null;
        return (SparkSession)this.getSparkSessionAsync(sessionId, detailed).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkSession> getSparkSessionWithResponse(int sessionId, Boolean detailed, Context context) {
        return (Response)this.getSparkSessionWithResponseAsync(sessionId, detailed, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkSessionWithResponseAsync(int sessionId) {
        return FluxUtil.withContext(context -> this.service.cancelSparkSession(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelSparkSessionWithResponseAsync(int sessionId, Context context) {
        return this.service.cancelSparkSession(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelSparkSessionAsync(int sessionId) {
        return this.cancelSparkSessionWithResponseAsync(sessionId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelSparkSessionAsync(int sessionId, Context context) {
        return this.cancelSparkSessionWithResponseAsync(sessionId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelSparkSession(int sessionId) {
        this.cancelSparkSessionAsync(sessionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelSparkSessionWithResponse(int sessionId, Context context) {
        return (Response)this.cancelSparkSessionWithResponseAsync(sessionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetSparkSessionTimeoutWithResponseAsync(int sessionId) {
        return FluxUtil.withContext(context -> this.service.resetSparkSessionTimeout(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> resetSparkSessionTimeoutWithResponseAsync(int sessionId, Context context) {
        return this.service.resetSparkSessionTimeout(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetSparkSessionTimeoutAsync(int sessionId) {
        return this.resetSparkSessionTimeoutWithResponseAsync(sessionId).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> resetSparkSessionTimeoutAsync(int sessionId, Context context) {
        return this.resetSparkSessionTimeoutWithResponseAsync(sessionId, context).flatMap(res -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void resetSparkSessionTimeout(int sessionId) {
        this.resetSparkSessionTimeoutAsync(sessionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> resetSparkSessionTimeoutWithResponse(int sessionId, Context context) {
        return (Response)this.resetSparkSessionTimeoutWithResponseAsync(sessionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatementCollection>> getSparkStatementsWithResponseAsync(int sessionId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkStatements(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatementCollection>> getSparkStatementsWithResponseAsync(int sessionId, Context context) {
        String accept = "application/json";
        return this.service.getSparkStatements(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatementCollection> getSparkStatementsAsync(int sessionId) {
        return this.getSparkStatementsWithResponseAsync(sessionId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatementCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatementCollection> getSparkStatementsAsync(int sessionId, Context context) {
        return this.getSparkStatementsWithResponseAsync(sessionId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatementCollection)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatementCollection getSparkStatements(int sessionId) {
        return (SparkStatementCollection)this.getSparkStatementsAsync(sessionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatementCollection> getSparkStatementsWithResponse(int sessionId, Context context) {
        return (Response)this.getSparkStatementsWithResponseAsync(sessionId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatement>> createSparkStatementWithResponseAsync(int sessionId, SparkStatementOptions sparkStatementOptions) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createSparkStatement(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, sparkStatementOptions, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatement>> createSparkStatementWithResponseAsync(int sessionId, SparkStatementOptions sparkStatementOptions, Context context) {
        String accept = "application/json";
        return this.service.createSparkStatement(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, sparkStatementOptions, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatement> createSparkStatementAsync(int sessionId, SparkStatementOptions sparkStatementOptions) {
        return this.createSparkStatementWithResponseAsync(sessionId, sparkStatementOptions).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatement)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatement> createSparkStatementAsync(int sessionId, SparkStatementOptions sparkStatementOptions, Context context) {
        return this.createSparkStatementWithResponseAsync(sessionId, sparkStatementOptions, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatement)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatement createSparkStatement(int sessionId, SparkStatementOptions sparkStatementOptions) {
        return (SparkStatement)this.createSparkStatementAsync(sessionId, sparkStatementOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatement> createSparkStatementWithResponse(int sessionId, SparkStatementOptions sparkStatementOptions, Context context) {
        return (Response)this.createSparkStatementWithResponseAsync(sessionId, sparkStatementOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatement>> getSparkStatementWithResponseAsync(int sessionId, int statementId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getSparkStatement(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, statementId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatement>> getSparkStatementWithResponseAsync(int sessionId, int statementId, Context context) {
        String accept = "application/json";
        return this.service.getSparkStatement(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, statementId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatement> getSparkStatementAsync(int sessionId, int statementId) {
        return this.getSparkStatementWithResponseAsync(sessionId, statementId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatement)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatement> getSparkStatementAsync(int sessionId, int statementId, Context context) {
        return this.getSparkStatementWithResponseAsync(sessionId, statementId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatement)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatement getSparkStatement(int sessionId, int statementId) {
        return (SparkStatement)this.getSparkStatementAsync(sessionId, statementId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatement> getSparkStatementWithResponse(int sessionId, int statementId, Context context) {
        return (Response)this.getSparkStatementWithResponseAsync(sessionId, statementId, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatementCancellationResult>> cancelSparkStatementWithResponseAsync(int sessionId, int statementId) {
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancelSparkStatement(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, statementId, "application/json", (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<SparkStatementCancellationResult>> cancelSparkStatementWithResponseAsync(int sessionId, int statementId, Context context) {
        String accept = "application/json";
        return this.service.cancelSparkStatement(this.client.getEndpoint(), this.client.getLivyApiVersion(), this.client.getSparkPoolName(), sessionId, statementId, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatementCancellationResult> cancelSparkStatementAsync(int sessionId, int statementId) {
        return this.cancelSparkStatementWithResponseAsync(sessionId, statementId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatementCancellationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<SparkStatementCancellationResult> cancelSparkStatementAsync(int sessionId, int statementId, Context context) {
        return this.cancelSparkStatementWithResponseAsync(sessionId, statementId, context).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((SparkStatementCancellationResult)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SparkStatementCancellationResult cancelSparkStatement(int sessionId, int statementId) {
        return (SparkStatementCancellationResult)this.cancelSparkStatementAsync(sessionId, statementId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SparkStatementCancellationResult> cancelSparkStatementWithResponse(int sessionId, int statementId, Context context) {
        return (Response)this.cancelSparkStatementWithResponseAsync(sessionId, statementId, context).block();
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="SparkClientSparkSess")
    private static interface SparkSessionsService {
        @Get(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkSessionCollection>> getSparkSessions(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @QueryParam(value="from") Integer var4, @QueryParam(value="size") Integer var5, @QueryParam(value="detailed") Boolean var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Post(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkSession>> createSparkSession(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @QueryParam(value="detailed") Boolean var4, @BodyParam(value="application/json") SparkSessionOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkSession>> getSparkSession(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, @QueryParam(value="detailed") Boolean var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Delete(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> cancelSparkSession(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, Context var5);

        @Put(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}/reset-timeout")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<Void>> resetSparkSessionTimeout(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, Context var5);

        @Get(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}/statements")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkStatementCollection>> getSparkStatements(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Post(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}/statements")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkStatement>> createSparkStatement(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, @BodyParam(value="application/json") SparkStatementOptions var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Get(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}/statements/{statementId}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkStatement>> getSparkStatement(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, @PathParam(value="statementId") int var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Post(value="/livyApi/versions/{livyApiVersion}/sparkPools/{sparkPoolName}/sessions/{sessionId}/statements/{statementId}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=HttpResponseException.class)
        public Mono<Response<SparkStatementCancellationResult>> cancelSparkStatement(@HostParam(value="endpoint") String var1, @PathParam(value="livyApiVersion", encoded=true) String var2, @PathParam(value="sparkPoolName", encoded=true) String var3, @PathParam(value="sessionId") int var4, @PathParam(value="statementId") int var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

