/*
 * Decompiled with CFR 0.152.
 */
package com.azure.aot.graalvm.support.netty.implementation.features;

import com.azure.aot.graalvm.support.netty.implementation.features.TargetIoNettyHandlerSslJdkDefaultApplicationProtocolNegotiator;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;

@TargetClass(className="io.netty.handler.ssl.JdkSslContext")
final class TargetIoNettyHandlerSslJdkSslContext {
    TargetIoNettyHandlerSslJdkSslContext() {
    }

    @Substitute
    static JdkApplicationProtocolNegotiator toNegotiator(ApplicationProtocolConfig config, boolean isServer) {
        if (config == null) {
            return (JdkApplicationProtocolNegotiator)TargetIoNettyHandlerSslJdkDefaultApplicationProtocolNegotiator.INSTANCE;
        }
        switch (config.protocol()) {
            case NONE: {
                return (JdkApplicationProtocolNegotiator)TargetIoNettyHandlerSslJdkDefaultApplicationProtocolNegotiator.INSTANCE;
            }
            case ALPN: {
                if (isServer) {
                    ApplicationProtocolConfig.SelectorFailureBehavior behavior = config.selectorFailureBehavior();
                    if (behavior == ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT) {
                        return new JdkAlpnApplicationProtocolNegotiator(true, (Iterable)config.supportedProtocols());
                    }
                    if (behavior == ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE) {
                        return new JdkAlpnApplicationProtocolNegotiator(false, (Iterable)config.supportedProtocols());
                    }
                    throw new UnsupportedOperationException("JDK provider does not support " + config.selectorFailureBehavior() + " failure behavior");
                }
                switch (config.selectedListenerFailureBehavior()) {
                    case ACCEPT: {
                        return new JdkAlpnApplicationProtocolNegotiator(false, (Iterable)config.supportedProtocols());
                    }
                    case FATAL_ALERT: {
                        return new JdkAlpnApplicationProtocolNegotiator(true, (Iterable)config.supportedProtocols());
                    }
                }
                throw new UnsupportedOperationException("JDK provider does not support " + config.selectedListenerFailureBehavior() + " failure behavior");
            }
        }
        throw new UnsupportedOperationException("JDK provider does not support " + config.protocol() + " protocol");
    }
}

