/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cognitiveservices.vision.customvision.training.implementation;

import com.google.common.base.Joiner;
import com.google.common.reflect.TypeToken;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.implementation.CustomVisionTrainingClientImpl;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.CreateImageRegionsOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.CreateImageTagsOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.CreateImagesFromDataOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.CreateProjectOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.CreateTagOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.CustomVisionErrorException;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.Domain;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.Export;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ExportIterationOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetImagePerformanceCountOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetImagePerformancesOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetImagesByIdsOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetIterationPerformanceOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetTagOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetTaggedImageCountOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetTaggedImagesOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetTagsOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetUntaggedImageCountOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.GetUntaggedImagesOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.Image;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageCreateSummary;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageFileCreateBatch;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageIdCreateBatch;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImagePerformance;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImagePrediction;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageRegionCreateBatch;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageRegionCreateEntry;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageRegionCreateSummary;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageRegionProposal;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageTagCreateBatch;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageTagCreateEntry;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageTagCreateSummary;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageUrl;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.ImageUrlCreateBatch;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.Iteration;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.IterationPerformance;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.PredictionQueryResult;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.PredictionQueryToken;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.Project;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.QuickTestImageOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.QuickTestImageUrlOptionalParameter;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.Tag;
import com.microsoft.azure.cognitiveservices.vision.customvision.training.models.TrainProjectOptionalParameter;
import com.microsoft.rest.CollectionFormat;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class TrainingsImpl
implements Trainings {
    private TrainingsService service;
    private CustomVisionTrainingClientImpl client;

    public TrainingsImpl(Retrofit retrofit, CustomVisionTrainingClientImpl client) {
        this.service = (TrainingsService)retrofit.create(TrainingsService.class);
        this.client = client;
    }

    @Override
    public Tag createTag(UUID projectId, String name, CreateTagOptionalParameter createTagOptionalParameter) {
        return (Tag)((ServiceResponse)this.createTagWithServiceResponseAsync(projectId, name, createTagOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Tag> createTagAsync(UUID projectId, String name, CreateTagOptionalParameter createTagOptionalParameter, ServiceCallback<Tag> serviceCallback) {
        return ServiceFuture.fromResponse(this.createTagWithServiceResponseAsync(projectId, name, createTagOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Tag> createTagAsync(UUID projectId, String name, CreateTagOptionalParameter createTagOptionalParameter) {
        return this.createTagWithServiceResponseAsync(projectId, name, createTagOptionalParameter).map((Func1)new Func1<ServiceResponse<Tag>, Tag>(){

            public Tag call(ServiceResponse<Tag> response) {
                return (Tag)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Tag>> createTagWithServiceResponseAsync(UUID projectId, String name, CreateTagOptionalParameter createTagOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String description = createTagOptionalParameter != null ? createTagOptionalParameter.description() : null;
        String type = createTagOptionalParameter != null ? createTagOptionalParameter.type() : null;
        return this.createTagWithServiceResponseAsync(projectId, name, description, type);
    }

    public Observable<ServiceResponse<Tag>> createTagWithServiceResponseAsync(UUID projectId, String name, String description, String type) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.createTag(projectId, name, description, type, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Tag>>>(){

            public Observable<ServiceResponse<Tag>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createTagDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Tag> createTagDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Tag>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsCreateTagParameters createTag() {
        return new TrainingsCreateTagParameters(this);
    }

    @Override
    public List<Tag> getTags(UUID projectId, GetTagsOptionalParameter getTagsOptionalParameter) {
        return (List)((ServiceResponse)this.getTagsWithServiceResponseAsync(projectId, getTagsOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<List<Tag>> getTagsAsync(UUID projectId, GetTagsOptionalParameter getTagsOptionalParameter, ServiceCallback<List<Tag>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTagsWithServiceResponseAsync(projectId, getTagsOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<List<Tag>> getTagsAsync(UUID projectId, GetTagsOptionalParameter getTagsOptionalParameter) {
        return this.getTagsWithServiceResponseAsync(projectId, getTagsOptionalParameter).map((Func1)new Func1<ServiceResponse<List<Tag>>, List<Tag>>(){

            public List<Tag> call(ServiceResponse<List<Tag>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Tag>>> getTagsWithServiceResponseAsync(UUID projectId, GetTagsOptionalParameter getTagsOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = getTagsOptionalParameter != null ? getTagsOptionalParameter.iterationId() : null;
        return this.getTagsWithServiceResponseAsync(projectId, iterationId);
    }

    public Observable<ServiceResponse<List<Tag>>> getTagsWithServiceResponseAsync(UUID projectId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getTags(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Tag>>>>(){

            public Observable<ServiceResponse<List<Tag>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Tag>> getTagsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Tag>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetTagsParameters getTags() {
        return new TrainingsGetTagsParameters(this);
    }

    @Override
    public Tag updateTag(UUID projectId, UUID tagId, Tag updatedTag) {
        return (Tag)((ServiceResponse)this.updateTagWithServiceResponseAsync(projectId, tagId, updatedTag).toBlocking().single()).body();
    }

    public ServiceFuture<Tag> updateTagAsync(UUID projectId, UUID tagId, Tag updatedTag, ServiceCallback<Tag> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateTagWithServiceResponseAsync(projectId, tagId, updatedTag), serviceCallback);
    }

    @Override
    public Observable<Tag> updateTagAsync(UUID projectId, UUID tagId, Tag updatedTag) {
        return this.updateTagWithServiceResponseAsync(projectId, tagId, updatedTag).map((Func1)new Func1<ServiceResponse<Tag>, Tag>(){

            public Tag call(ServiceResponse<Tag> response) {
                return (Tag)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Tag>> updateTagWithServiceResponseAsync(UUID projectId, UUID tagId, Tag updatedTag) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (tagId == null) {
            throw new IllegalArgumentException("Parameter tagId is required and cannot be null.");
        }
        if (updatedTag == null) {
            throw new IllegalArgumentException("Parameter updatedTag is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate((Object)updatedTag);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.updateTag(projectId, tagId, updatedTag, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Tag>>>(){

            public Observable<ServiceResponse<Tag>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.updateTagDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Tag> updateTagDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Tag>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public void deleteTag(UUID projectId, UUID tagId) {
        ((ServiceResponse)this.deleteTagWithServiceResponseAsync(projectId, tagId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteTagAsync(UUID projectId, UUID tagId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteTagWithServiceResponseAsync(projectId, tagId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteTagAsync(UUID projectId, UUID tagId) {
        return this.deleteTagWithServiceResponseAsync(projectId, tagId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteTagWithServiceResponseAsync(UUID projectId, UUID tagId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (tagId == null) {
            throw new IllegalArgumentException("Parameter tagId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.deleteTag(projectId, tagId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deleteTagDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteTagDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public Tag getTag(UUID projectId, UUID tagId, GetTagOptionalParameter getTagOptionalParameter) {
        return (Tag)((ServiceResponse)this.getTagWithServiceResponseAsync(projectId, tagId, getTagOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Tag> getTagAsync(UUID projectId, UUID tagId, GetTagOptionalParameter getTagOptionalParameter, ServiceCallback<Tag> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTagWithServiceResponseAsync(projectId, tagId, getTagOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Tag> getTagAsync(UUID projectId, UUID tagId, GetTagOptionalParameter getTagOptionalParameter) {
        return this.getTagWithServiceResponseAsync(projectId, tagId, getTagOptionalParameter).map((Func1)new Func1<ServiceResponse<Tag>, Tag>(){

            public Tag call(ServiceResponse<Tag> response) {
                return (Tag)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Tag>> getTagWithServiceResponseAsync(UUID projectId, UUID tagId, GetTagOptionalParameter getTagOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (tagId == null) {
            throw new IllegalArgumentException("Parameter tagId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = getTagOptionalParameter != null ? getTagOptionalParameter.iterationId() : null;
        return this.getTagWithServiceResponseAsync(projectId, tagId, iterationId);
    }

    public Observable<ServiceResponse<Tag>> getTagWithServiceResponseAsync(UUID projectId, UUID tagId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (tagId == null) {
            throw new IllegalArgumentException("Parameter tagId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getTag(projectId, tagId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Tag>>>(){

            public Observable<ServiceResponse<Tag>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getTagDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Tag> getTagDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Tag>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetTagParameters getTag() {
        return new TrainingsGetTagParameters(this);
    }

    @Override
    public Export exportIteration(UUID projectId, UUID iterationId, String platform, ExportIterationOptionalParameter exportIterationOptionalParameter) {
        return (Export)((ServiceResponse)this.exportIterationWithServiceResponseAsync(projectId, iterationId, platform, exportIterationOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Export> exportIterationAsync(UUID projectId, UUID iterationId, String platform, ExportIterationOptionalParameter exportIterationOptionalParameter, ServiceCallback<Export> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportIterationWithServiceResponseAsync(projectId, iterationId, platform, exportIterationOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Export> exportIterationAsync(UUID projectId, UUID iterationId, String platform, ExportIterationOptionalParameter exportIterationOptionalParameter) {
        return this.exportIterationWithServiceResponseAsync(projectId, iterationId, platform, exportIterationOptionalParameter).map((Func1)new Func1<ServiceResponse<Export>, Export>(){

            public Export call(ServiceResponse<Export> response) {
                return (Export)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Export>> exportIterationWithServiceResponseAsync(UUID projectId, UUID iterationId, String platform, ExportIterationOptionalParameter exportIterationOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (platform == null) {
            throw new IllegalArgumentException("Parameter platform is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String flavor = exportIterationOptionalParameter != null ? exportIterationOptionalParameter.flavor() : null;
        return this.exportIterationWithServiceResponseAsync(projectId, iterationId, platform, flavor);
    }

    public Observable<ServiceResponse<Export>> exportIterationWithServiceResponseAsync(UUID projectId, UUID iterationId, String platform, String flavor) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (platform == null) {
            throw new IllegalArgumentException("Parameter platform is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.exportIteration(projectId, iterationId, platform, flavor, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Export>>>(){

            public Observable<ServiceResponse<Export>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.exportIterationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Export> exportIterationDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Export>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsExportIterationParameters exportIteration() {
        return new TrainingsExportIterationParameters(this);
    }

    @Override
    public List<Export> getExports(UUID projectId, UUID iterationId) {
        return (List)((ServiceResponse)this.getExportsWithServiceResponseAsync(projectId, iterationId).toBlocking().single()).body();
    }

    public ServiceFuture<List<Export>> getExportsAsync(UUID projectId, UUID iterationId, ServiceCallback<List<Export>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getExportsWithServiceResponseAsync(projectId, iterationId), serviceCallback);
    }

    @Override
    public Observable<List<Export>> getExportsAsync(UUID projectId, UUID iterationId) {
        return this.getExportsWithServiceResponseAsync(projectId, iterationId).map((Func1)new Func1<ServiceResponse<List<Export>>, List<Export>>(){

            public List<Export> call(ServiceResponse<List<Export>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Export>>> getExportsWithServiceResponseAsync(UUID projectId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getExports(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Export>>>>(){

            public Observable<ServiceResponse<List<Export>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getExportsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Export>> getExportsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Export>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public void unpublishIteration(UUID projectId, UUID iterationId) {
        ((ServiceResponse)this.unpublishIterationWithServiceResponseAsync(projectId, iterationId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> unpublishIterationAsync(UUID projectId, UUID iterationId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.unpublishIterationWithServiceResponseAsync(projectId, iterationId), serviceCallback);
    }

    @Override
    public Observable<Void> unpublishIterationAsync(UUID projectId, UUID iterationId) {
        return this.unpublishIterationWithServiceResponseAsync(projectId, iterationId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> unpublishIterationWithServiceResponseAsync(UUID projectId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.unpublishIteration(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.unpublishIterationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> unpublishIterationDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public boolean publishIteration(UUID projectId, UUID iterationId, String publishName, String predictionId) {
        return (Boolean)((ServiceResponse)this.publishIterationWithServiceResponseAsync(projectId, iterationId, publishName, predictionId).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> publishIterationAsync(UUID projectId, UUID iterationId, String publishName, String predictionId, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.publishIterationWithServiceResponseAsync(projectId, iterationId, publishName, predictionId), serviceCallback);
    }

    @Override
    public Observable<Boolean> publishIterationAsync(UUID projectId, UUID iterationId, String publishName, String predictionId) {
        return this.publishIterationWithServiceResponseAsync(projectId, iterationId, publishName, predictionId).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> publishIterationWithServiceResponseAsync(UUID projectId, UUID iterationId, String publishName, String predictionId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (publishName == null) {
            throw new IllegalArgumentException("Parameter publishName is required and cannot be null.");
        }
        if (predictionId == null) {
            throw new IllegalArgumentException("Parameter predictionId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.publishIteration(projectId, iterationId, publishName, predictionId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.publishIterationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> publishIterationDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Boolean>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public Iteration updateIteration(UUID projectId, UUID iterationId, String name) {
        return (Iteration)((ServiceResponse)this.updateIterationWithServiceResponseAsync(projectId, iterationId, name).toBlocking().single()).body();
    }

    public ServiceFuture<Iteration> updateIterationAsync(UUID projectId, UUID iterationId, String name, ServiceCallback<Iteration> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateIterationWithServiceResponseAsync(projectId, iterationId, name), serviceCallback);
    }

    @Override
    public Observable<Iteration> updateIterationAsync(UUID projectId, UUID iterationId, String name) {
        return this.updateIterationWithServiceResponseAsync(projectId, iterationId, name).map((Func1)new Func1<ServiceResponse<Iteration>, Iteration>(){

            public Iteration call(ServiceResponse<Iteration> response) {
                return (Iteration)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Iteration>> updateIterationWithServiceResponseAsync(UUID projectId, UUID iterationId, String name) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        Iteration updatedIteration = new Iteration();
        updatedIteration.withName(name);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.updateIteration(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), updatedIteration, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Iteration>>>(){

            public Observable<ServiceResponse<Iteration>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.updateIterationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Iteration> updateIterationDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Iteration>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public void deleteIteration(UUID projectId, UUID iterationId) {
        ((ServiceResponse)this.deleteIterationWithServiceResponseAsync(projectId, iterationId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteIterationAsync(UUID projectId, UUID iterationId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteIterationWithServiceResponseAsync(projectId, iterationId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteIterationAsync(UUID projectId, UUID iterationId) {
        return this.deleteIterationWithServiceResponseAsync(projectId, iterationId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteIterationWithServiceResponseAsync(UUID projectId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.deleteIteration(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deleteIterationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteIterationDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public Iteration getIteration(UUID projectId, UUID iterationId) {
        return (Iteration)((ServiceResponse)this.getIterationWithServiceResponseAsync(projectId, iterationId).toBlocking().single()).body();
    }

    public ServiceFuture<Iteration> getIterationAsync(UUID projectId, UUID iterationId, ServiceCallback<Iteration> serviceCallback) {
        return ServiceFuture.fromResponse(this.getIterationWithServiceResponseAsync(projectId, iterationId), serviceCallback);
    }

    @Override
    public Observable<Iteration> getIterationAsync(UUID projectId, UUID iterationId) {
        return this.getIterationWithServiceResponseAsync(projectId, iterationId).map((Func1)new Func1<ServiceResponse<Iteration>, Iteration>(){

            public Iteration call(ServiceResponse<Iteration> response) {
                return (Iteration)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Iteration>> getIterationWithServiceResponseAsync(UUID projectId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getIteration(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Iteration>>>(){

            public Observable<ServiceResponse<Iteration>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getIterationDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Iteration> getIterationDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Iteration>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public List<Iteration> getIterations(UUID projectId) {
        return (List)((ServiceResponse)this.getIterationsWithServiceResponseAsync(projectId).toBlocking().single()).body();
    }

    public ServiceFuture<List<Iteration>> getIterationsAsync(UUID projectId, ServiceCallback<List<Iteration>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getIterationsWithServiceResponseAsync(projectId), serviceCallback);
    }

    @Override
    public Observable<List<Iteration>> getIterationsAsync(UUID projectId) {
        return this.getIterationsWithServiceResponseAsync(projectId).map((Func1)new Func1<ServiceResponse<List<Iteration>>, List<Iteration>>(){

            public List<Iteration> call(ServiceResponse<List<Iteration>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Iteration>>> getIterationsWithServiceResponseAsync(UUID projectId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getIterations(projectId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Iteration>>>>(){

            public Observable<ServiceResponse<List<Iteration>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getIterationsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Iteration>> getIterationsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Iteration>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public Iteration trainProject(UUID projectId, TrainProjectOptionalParameter trainProjectOptionalParameter) {
        return (Iteration)((ServiceResponse)this.trainProjectWithServiceResponseAsync(projectId, trainProjectOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Iteration> trainProjectAsync(UUID projectId, TrainProjectOptionalParameter trainProjectOptionalParameter, ServiceCallback<Iteration> serviceCallback) {
        return ServiceFuture.fromResponse(this.trainProjectWithServiceResponseAsync(projectId, trainProjectOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Iteration> trainProjectAsync(UUID projectId, TrainProjectOptionalParameter trainProjectOptionalParameter) {
        return this.trainProjectWithServiceResponseAsync(projectId, trainProjectOptionalParameter).map((Func1)new Func1<ServiceResponse<Iteration>, Iteration>(){

            public Iteration call(ServiceResponse<Iteration> response) {
                return (Iteration)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Iteration>> trainProjectWithServiceResponseAsync(UUID projectId, TrainProjectOptionalParameter trainProjectOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String trainingType = trainProjectOptionalParameter != null ? trainProjectOptionalParameter.trainingType() : null;
        Integer reservedBudgetInHours = trainProjectOptionalParameter != null ? trainProjectOptionalParameter.reservedBudgetInHours() : null;
        Boolean forceTrain = trainProjectOptionalParameter != null ? trainProjectOptionalParameter.forceTrain() : null;
        String notificationEmailAddress = trainProjectOptionalParameter != null ? trainProjectOptionalParameter.notificationEmailAddress() : null;
        return this.trainProjectWithServiceResponseAsync(projectId, trainingType, reservedBudgetInHours, forceTrain, notificationEmailAddress);
    }

    public Observable<ServiceResponse<Iteration>> trainProjectWithServiceResponseAsync(UUID projectId, String trainingType, Integer reservedBudgetInHours, Boolean forceTrain, String notificationEmailAddress) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.trainProject(projectId, trainingType, reservedBudgetInHours, forceTrain, notificationEmailAddress, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Iteration>>>(){

            public Observable<ServiceResponse<Iteration>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.trainProjectDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Iteration> trainProjectDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Iteration>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsTrainProjectParameters trainProject() {
        return new TrainingsTrainProjectParameters(this);
    }

    @Override
    public Project updateProject(UUID projectId, Project updatedProject) {
        return (Project)((ServiceResponse)this.updateProjectWithServiceResponseAsync(projectId, updatedProject).toBlocking().single()).body();
    }

    public ServiceFuture<Project> updateProjectAsync(UUID projectId, Project updatedProject, ServiceCallback<Project> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateProjectWithServiceResponseAsync(projectId, updatedProject), serviceCallback);
    }

    @Override
    public Observable<Project> updateProjectAsync(UUID projectId, Project updatedProject) {
        return this.updateProjectWithServiceResponseAsync(projectId, updatedProject).map((Func1)new Func1<ServiceResponse<Project>, Project>(){

            public Project call(ServiceResponse<Project> response) {
                return (Project)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Project>> updateProjectWithServiceResponseAsync(UUID projectId, Project updatedProject) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (updatedProject == null) {
            throw new IllegalArgumentException("Parameter updatedProject is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate((Object)updatedProject);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.updateProject(projectId, updatedProject, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Project>>>(){

            public Observable<ServiceResponse<Project>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.updateProjectDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Project> updateProjectDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Project>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public void deleteProject(UUID projectId) {
        ((ServiceResponse)this.deleteProjectWithServiceResponseAsync(projectId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteProjectAsync(UUID projectId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteProjectWithServiceResponseAsync(projectId), serviceCallback);
    }

    @Override
    public Observable<Void> deleteProjectAsync(UUID projectId) {
        return this.deleteProjectWithServiceResponseAsync(projectId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteProjectWithServiceResponseAsync(UUID projectId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.deleteProject(projectId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deleteProjectDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteProjectDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public Project getProject(UUID projectId) {
        return (Project)((ServiceResponse)this.getProjectWithServiceResponseAsync(projectId).toBlocking().single()).body();
    }

    public ServiceFuture<Project> getProjectAsync(UUID projectId, ServiceCallback<Project> serviceCallback) {
        return ServiceFuture.fromResponse(this.getProjectWithServiceResponseAsync(projectId), serviceCallback);
    }

    @Override
    public Observable<Project> getProjectAsync(UUID projectId) {
        return this.getProjectWithServiceResponseAsync(projectId).map((Func1)new Func1<ServiceResponse<Project>, Project>(){

            public Project call(ServiceResponse<Project> response) {
                return (Project)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Project>> getProjectWithServiceResponseAsync(UUID projectId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getProject(projectId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Project>>>(){

            public Observable<ServiceResponse<Project>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getProjectDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Project> getProjectDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Project>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public Project createProject(String name, CreateProjectOptionalParameter createProjectOptionalParameter) {
        return (Project)((ServiceResponse)this.createProjectWithServiceResponseAsync(name, createProjectOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Project> createProjectAsync(String name, CreateProjectOptionalParameter createProjectOptionalParameter, ServiceCallback<Project> serviceCallback) {
        return ServiceFuture.fromResponse(this.createProjectWithServiceResponseAsync(name, createProjectOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Project> createProjectAsync(String name, CreateProjectOptionalParameter createProjectOptionalParameter) {
        return this.createProjectWithServiceResponseAsync(name, createProjectOptionalParameter).map((Func1)new Func1<ServiceResponse<Project>, Project>(){

            public Project call(ServiceResponse<Project> response) {
                return (Project)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Project>> createProjectWithServiceResponseAsync(String name, CreateProjectOptionalParameter createProjectOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String description = createProjectOptionalParameter != null ? createProjectOptionalParameter.description() : null;
        UUID domainId = createProjectOptionalParameter != null ? createProjectOptionalParameter.domainId() : null;
        String classificationType = createProjectOptionalParameter != null ? createProjectOptionalParameter.classificationType() : null;
        List<String> targetExportPlatforms = createProjectOptionalParameter != null ? createProjectOptionalParameter.targetExportPlatforms() : null;
        return this.createProjectWithServiceResponseAsync(name, description, domainId, classificationType, targetExportPlatforms);
    }

    public Observable<ServiceResponse<Project>> createProjectWithServiceResponseAsync(String name, String description, UUID domainId, String classificationType, List<String> targetExportPlatforms) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (name == null) {
            throw new IllegalArgumentException("Parameter name is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(targetExportPlatforms);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String targetExportPlatformsConverted = this.client.serializerAdapter().serializeList(targetExportPlatforms, CollectionFormat.CSV);
        return this.service.createProject(name, description, domainId, classificationType, targetExportPlatformsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Project>>>(){

            public Observable<ServiceResponse<Project>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createProjectDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Project> createProjectDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Project>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsCreateProjectParameters createProject() {
        return new TrainingsCreateProjectParameters(this);
    }

    @Override
    public List<Project> getProjects() {
        return (List)((ServiceResponse)this.getProjectsWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<Project>> getProjectsAsync(ServiceCallback<List<Project>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getProjectsWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<List<Project>> getProjectsAsync() {
        return this.getProjectsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<Project>>, List<Project>>(){

            public List<Project> call(ServiceResponse<List<Project>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Project>>> getProjectsWithServiceResponseAsync() {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getProjects(this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Project>>>>(){

            public Observable<ServiceResponse<List<Project>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getProjectsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Project>> getProjectsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Project>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public int getImagePerformanceCount(UUID projectId, UUID iterationId, GetImagePerformanceCountOptionalParameter getImagePerformanceCountOptionalParameter) {
        return (Integer)((ServiceResponse)this.getImagePerformanceCountWithServiceResponseAsync(projectId, iterationId, getImagePerformanceCountOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Integer> getImagePerformanceCountAsync(UUID projectId, UUID iterationId, GetImagePerformanceCountOptionalParameter getImagePerformanceCountOptionalParameter, ServiceCallback<Integer> serviceCallback) {
        return ServiceFuture.fromResponse(this.getImagePerformanceCountWithServiceResponseAsync(projectId, iterationId, getImagePerformanceCountOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Integer> getImagePerformanceCountAsync(UUID projectId, UUID iterationId, GetImagePerformanceCountOptionalParameter getImagePerformanceCountOptionalParameter) {
        return this.getImagePerformanceCountWithServiceResponseAsync(projectId, iterationId, getImagePerformanceCountOptionalParameter).map((Func1)new Func1<ServiceResponse<Integer>, Integer>(){

            public Integer call(ServiceResponse<Integer> response) {
                return (Integer)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Integer>> getImagePerformanceCountWithServiceResponseAsync(UUID projectId, UUID iterationId, GetImagePerformanceCountOptionalParameter getImagePerformanceCountOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        List<UUID> tagIds = getImagePerformanceCountOptionalParameter != null ? getImagePerformanceCountOptionalParameter.tagIds() : null;
        return this.getImagePerformanceCountWithServiceResponseAsync(projectId, iterationId, tagIds);
    }

    public Observable<ServiceResponse<Integer>> getImagePerformanceCountWithServiceResponseAsync(UUID projectId, UUID iterationId, List<UUID> tagIds) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(tagIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String tagIdsConverted = this.client.serializerAdapter().serializeList(tagIds, CollectionFormat.CSV);
        return this.service.getImagePerformanceCount(projectId, iterationId, tagIdsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Integer>>>(){

            public Observable<ServiceResponse<Integer>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getImagePerformanceCountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Integer> getImagePerformanceCountDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Integer>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetImagePerformanceCountParameters getImagePerformanceCount() {
        return new TrainingsGetImagePerformanceCountParameters(this);
    }

    @Override
    public List<ImagePerformance> getImagePerformances(UUID projectId, UUID iterationId, GetImagePerformancesOptionalParameter getImagePerformancesOptionalParameter) {
        return (List)((ServiceResponse)this.getImagePerformancesWithServiceResponseAsync(projectId, iterationId, getImagePerformancesOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<List<ImagePerformance>> getImagePerformancesAsync(UUID projectId, UUID iterationId, GetImagePerformancesOptionalParameter getImagePerformancesOptionalParameter, ServiceCallback<List<ImagePerformance>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getImagePerformancesWithServiceResponseAsync(projectId, iterationId, getImagePerformancesOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<List<ImagePerformance>> getImagePerformancesAsync(UUID projectId, UUID iterationId, GetImagePerformancesOptionalParameter getImagePerformancesOptionalParameter) {
        return this.getImagePerformancesWithServiceResponseAsync(projectId, iterationId, getImagePerformancesOptionalParameter).map((Func1)new Func1<ServiceResponse<List<ImagePerformance>>, List<ImagePerformance>>(){

            public List<ImagePerformance> call(ServiceResponse<List<ImagePerformance>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<ImagePerformance>>> getImagePerformancesWithServiceResponseAsync(UUID projectId, UUID iterationId, GetImagePerformancesOptionalParameter getImagePerformancesOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        List<UUID> tagIds = getImagePerformancesOptionalParameter != null ? getImagePerformancesOptionalParameter.tagIds() : null;
        String orderBy = getImagePerformancesOptionalParameter != null ? getImagePerformancesOptionalParameter.orderBy() : null;
        Integer take = getImagePerformancesOptionalParameter != null ? getImagePerformancesOptionalParameter.take() : null;
        Integer skip = getImagePerformancesOptionalParameter != null ? getImagePerformancesOptionalParameter.skip() : null;
        return this.getImagePerformancesWithServiceResponseAsync(projectId, iterationId, tagIds, orderBy, take, skip);
    }

    public Observable<ServiceResponse<List<ImagePerformance>>> getImagePerformancesWithServiceResponseAsync(UUID projectId, UUID iterationId, List<UUID> tagIds, String orderBy, Integer take, Integer skip) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(tagIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String tagIdsConverted = this.client.serializerAdapter().serializeList(tagIds, CollectionFormat.CSV);
        return this.service.getImagePerformances(projectId, iterationId, tagIdsConverted, orderBy, take, skip, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<ImagePerformance>>>>(){

            public Observable<ServiceResponse<List<ImagePerformance>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getImagePerformancesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<ImagePerformance>> getImagePerformancesDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<ImagePerformance>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetImagePerformancesParameters getImagePerformances() {
        return new TrainingsGetImagePerformancesParameters(this);
    }

    @Override
    public IterationPerformance getIterationPerformance(UUID projectId, UUID iterationId, GetIterationPerformanceOptionalParameter getIterationPerformanceOptionalParameter) {
        return (IterationPerformance)((ServiceResponse)this.getIterationPerformanceWithServiceResponseAsync(projectId, iterationId, getIterationPerformanceOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<IterationPerformance> getIterationPerformanceAsync(UUID projectId, UUID iterationId, GetIterationPerformanceOptionalParameter getIterationPerformanceOptionalParameter, ServiceCallback<IterationPerformance> serviceCallback) {
        return ServiceFuture.fromResponse(this.getIterationPerformanceWithServiceResponseAsync(projectId, iterationId, getIterationPerformanceOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<IterationPerformance> getIterationPerformanceAsync(UUID projectId, UUID iterationId, GetIterationPerformanceOptionalParameter getIterationPerformanceOptionalParameter) {
        return this.getIterationPerformanceWithServiceResponseAsync(projectId, iterationId, getIterationPerformanceOptionalParameter).map((Func1)new Func1<ServiceResponse<IterationPerformance>, IterationPerformance>(){

            public IterationPerformance call(ServiceResponse<IterationPerformance> response) {
                return (IterationPerformance)response.body();
            }
        });
    }

    public Observable<ServiceResponse<IterationPerformance>> getIterationPerformanceWithServiceResponseAsync(UUID projectId, UUID iterationId, GetIterationPerformanceOptionalParameter getIterationPerformanceOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Double threshold = getIterationPerformanceOptionalParameter != null ? getIterationPerformanceOptionalParameter.threshold() : null;
        Double overlapThreshold = getIterationPerformanceOptionalParameter != null ? getIterationPerformanceOptionalParameter.overlapThreshold() : null;
        return this.getIterationPerformanceWithServiceResponseAsync(projectId, iterationId, threshold, overlapThreshold);
    }

    public Observable<ServiceResponse<IterationPerformance>> getIterationPerformanceWithServiceResponseAsync(UUID projectId, UUID iterationId, Double threshold, Double overlapThreshold) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (iterationId == null) {
            throw new IllegalArgumentException("Parameter iterationId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getIterationPerformance(projectId, iterationId, threshold, overlapThreshold, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<IterationPerformance>>>(){

            public Observable<ServiceResponse<IterationPerformance>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getIterationPerformanceDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<IterationPerformance> getIterationPerformanceDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<IterationPerformance>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetIterationPerformanceParameters getIterationPerformance() {
        return new TrainingsGetIterationPerformanceParameters(this);
    }

    @Override
    public PredictionQueryResult queryPredictions(UUID projectId, PredictionQueryToken query) {
        return (PredictionQueryResult)((ServiceResponse)this.queryPredictionsWithServiceResponseAsync(projectId, query).toBlocking().single()).body();
    }

    public ServiceFuture<PredictionQueryResult> queryPredictionsAsync(UUID projectId, PredictionQueryToken query, ServiceCallback<PredictionQueryResult> serviceCallback) {
        return ServiceFuture.fromResponse(this.queryPredictionsWithServiceResponseAsync(projectId, query), serviceCallback);
    }

    @Override
    public Observable<PredictionQueryResult> queryPredictionsAsync(UUID projectId, PredictionQueryToken query) {
        return this.queryPredictionsWithServiceResponseAsync(projectId, query).map((Func1)new Func1<ServiceResponse<PredictionQueryResult>, PredictionQueryResult>(){

            public PredictionQueryResult call(ServiceResponse<PredictionQueryResult> response) {
                return (PredictionQueryResult)response.body();
            }
        });
    }

    public Observable<ServiceResponse<PredictionQueryResult>> queryPredictionsWithServiceResponseAsync(UUID projectId, PredictionQueryToken query) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (query == null) {
            throw new IllegalArgumentException("Parameter query is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate((Object)query);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.queryPredictions(projectId, query, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<PredictionQueryResult>>>(){

            public Observable<ServiceResponse<PredictionQueryResult>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.queryPredictionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PredictionQueryResult> queryPredictionsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PredictionQueryResult>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImagePrediction quickTestImage(UUID projectId, byte[] imageData, QuickTestImageOptionalParameter quickTestImageOptionalParameter) {
        return (ImagePrediction)((ServiceResponse)this.quickTestImageWithServiceResponseAsync(projectId, imageData, quickTestImageOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<ImagePrediction> quickTestImageAsync(UUID projectId, byte[] imageData, QuickTestImageOptionalParameter quickTestImageOptionalParameter, ServiceCallback<ImagePrediction> serviceCallback) {
        return ServiceFuture.fromResponse(this.quickTestImageWithServiceResponseAsync(projectId, imageData, quickTestImageOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<ImagePrediction> quickTestImageAsync(UUID projectId, byte[] imageData, QuickTestImageOptionalParameter quickTestImageOptionalParameter) {
        return this.quickTestImageWithServiceResponseAsync(projectId, imageData, quickTestImageOptionalParameter).map((Func1)new Func1<ServiceResponse<ImagePrediction>, ImagePrediction>(){

            public ImagePrediction call(ServiceResponse<ImagePrediction> response) {
                return (ImagePrediction)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImagePrediction>> quickTestImageWithServiceResponseAsync(UUID projectId, byte[] imageData, QuickTestImageOptionalParameter quickTestImageOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageData == null) {
            throw new IllegalArgumentException("Parameter imageData is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = quickTestImageOptionalParameter != null ? quickTestImageOptionalParameter.iterationId() : null;
        return this.quickTestImageWithServiceResponseAsync(projectId, imageData, iterationId);
    }

    public Observable<ServiceResponse<ImagePrediction>> quickTestImageWithServiceResponseAsync(UUID projectId, byte[] imageData, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageData == null) {
            throw new IllegalArgumentException("Parameter imageData is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        RequestBody imageDataConverted = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (byte[])imageData);
        return this.service.quickTestImage(projectId, iterationId, imageDataConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImagePrediction>>>(){

            public Observable<ServiceResponse<ImagePrediction>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.quickTestImageDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImagePrediction> quickTestImageDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImagePrediction>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsQuickTestImageParameters quickTestImage() {
        return new TrainingsQuickTestImageParameters(this);
    }

    @Override
    public ImagePrediction quickTestImageUrl(UUID projectId, String url, QuickTestImageUrlOptionalParameter quickTestImageUrlOptionalParameter) {
        return (ImagePrediction)((ServiceResponse)this.quickTestImageUrlWithServiceResponseAsync(projectId, url, quickTestImageUrlOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<ImagePrediction> quickTestImageUrlAsync(UUID projectId, String url, QuickTestImageUrlOptionalParameter quickTestImageUrlOptionalParameter, ServiceCallback<ImagePrediction> serviceCallback) {
        return ServiceFuture.fromResponse(this.quickTestImageUrlWithServiceResponseAsync(projectId, url, quickTestImageUrlOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<ImagePrediction> quickTestImageUrlAsync(UUID projectId, String url, QuickTestImageUrlOptionalParameter quickTestImageUrlOptionalParameter) {
        return this.quickTestImageUrlWithServiceResponseAsync(projectId, url, quickTestImageUrlOptionalParameter).map((Func1)new Func1<ServiceResponse<ImagePrediction>, ImagePrediction>(){

            public ImagePrediction call(ServiceResponse<ImagePrediction> response) {
                return (ImagePrediction)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImagePrediction>> quickTestImageUrlWithServiceResponseAsync(UUID projectId, String url, QuickTestImageUrlOptionalParameter quickTestImageUrlOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Parameter url is required and cannot be null.");
        }
        UUID iterationId = quickTestImageUrlOptionalParameter != null ? quickTestImageUrlOptionalParameter.iterationId() : null;
        return this.quickTestImageUrlWithServiceResponseAsync(projectId, url, iterationId);
    }

    public Observable<ServiceResponse<ImagePrediction>> quickTestImageUrlWithServiceResponseAsync(UUID projectId, String url, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        if (url == null) {
            throw new IllegalArgumentException("Parameter url is required and cannot be null.");
        }
        ImageUrl imageUrl = new ImageUrl();
        imageUrl.withUrl(url);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.quickTestImageUrl(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), imageUrl, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImagePrediction>>>(){

            public Observable<ServiceResponse<ImagePrediction>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.quickTestImageUrlDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImagePrediction> quickTestImageUrlDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImagePrediction>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsQuickTestImageUrlParameters quickTestImageUrl() {
        return new TrainingsQuickTestImageUrlParameters(this);
    }

    @Override
    public void deletePrediction(UUID projectId, List<UUID> ids) {
        ((ServiceResponse)this.deletePredictionWithServiceResponseAsync(projectId, ids).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deletePredictionAsync(UUID projectId, List<UUID> ids, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deletePredictionWithServiceResponseAsync(projectId, ids), serviceCallback);
    }

    @Override
    public Observable<Void> deletePredictionAsync(UUID projectId, List<UUID> ids) {
        return this.deletePredictionWithServiceResponseAsync(projectId, ids).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deletePredictionWithServiceResponseAsync(UUID projectId, List<UUID> ids) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (ids == null) {
            throw new IllegalArgumentException("Parameter ids is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(ids);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String idsConverted = this.client.serializerAdapter().serializeList(ids, CollectionFormat.CSV);
        return this.service.deletePrediction(projectId, idsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deletePredictionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deletePredictionDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageRegionProposal getImageRegionProposals(UUID projectId, UUID imageId) {
        return (ImageRegionProposal)((ServiceResponse)this.getImageRegionProposalsWithServiceResponseAsync(projectId, imageId).toBlocking().single()).body();
    }

    public ServiceFuture<ImageRegionProposal> getImageRegionProposalsAsync(UUID projectId, UUID imageId, ServiceCallback<ImageRegionProposal> serviceCallback) {
        return ServiceFuture.fromResponse(this.getImageRegionProposalsWithServiceResponseAsync(projectId, imageId), serviceCallback);
    }

    @Override
    public Observable<ImageRegionProposal> getImageRegionProposalsAsync(UUID projectId, UUID imageId) {
        return this.getImageRegionProposalsWithServiceResponseAsync(projectId, imageId).map((Func1)new Func1<ServiceResponse<ImageRegionProposal>, ImageRegionProposal>(){

            public ImageRegionProposal call(ServiceResponse<ImageRegionProposal> response) {
                return (ImageRegionProposal)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageRegionProposal>> getImageRegionProposalsWithServiceResponseAsync(UUID projectId, UUID imageId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageId == null) {
            throw new IllegalArgumentException("Parameter imageId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getImageRegionProposals(projectId, imageId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageRegionProposal>>>(){

            public Observable<ServiceResponse<ImageRegionProposal>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getImageRegionProposalsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageRegionProposal> getImageRegionProposalsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageRegionProposal>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageCreateSummary createImagesFromPredictions(UUID projectId, ImageIdCreateBatch batch) {
        return (ImageCreateSummary)((ServiceResponse)this.createImagesFromPredictionsWithServiceResponseAsync(projectId, batch).toBlocking().single()).body();
    }

    public ServiceFuture<ImageCreateSummary> createImagesFromPredictionsAsync(UUID projectId, ImageIdCreateBatch batch, ServiceCallback<ImageCreateSummary> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImagesFromPredictionsWithServiceResponseAsync(projectId, batch), serviceCallback);
    }

    @Override
    public Observable<ImageCreateSummary> createImagesFromPredictionsAsync(UUID projectId, ImageIdCreateBatch batch) {
        return this.createImagesFromPredictionsWithServiceResponseAsync(projectId, batch).map((Func1)new Func1<ServiceResponse<ImageCreateSummary>, ImageCreateSummary>(){

            public ImageCreateSummary call(ServiceResponse<ImageCreateSummary> response) {
                return (ImageCreateSummary)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageCreateSummary>> createImagesFromPredictionsWithServiceResponseAsync(UUID projectId, ImageIdCreateBatch batch) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (batch == null) {
            throw new IllegalArgumentException("Parameter batch is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate((Object)batch);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.createImagesFromPredictions(projectId, batch, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageCreateSummary>>>(){

            public Observable<ServiceResponse<ImageCreateSummary>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createImagesFromPredictionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageCreateSummary> createImagesFromPredictionsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageCreateSummary>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageCreateSummary createImagesFromUrls(UUID projectId, ImageUrlCreateBatch batch) {
        return (ImageCreateSummary)((ServiceResponse)this.createImagesFromUrlsWithServiceResponseAsync(projectId, batch).toBlocking().single()).body();
    }

    public ServiceFuture<ImageCreateSummary> createImagesFromUrlsAsync(UUID projectId, ImageUrlCreateBatch batch, ServiceCallback<ImageCreateSummary> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImagesFromUrlsWithServiceResponseAsync(projectId, batch), serviceCallback);
    }

    @Override
    public Observable<ImageCreateSummary> createImagesFromUrlsAsync(UUID projectId, ImageUrlCreateBatch batch) {
        return this.createImagesFromUrlsWithServiceResponseAsync(projectId, batch).map((Func1)new Func1<ServiceResponse<ImageCreateSummary>, ImageCreateSummary>(){

            public ImageCreateSummary call(ServiceResponse<ImageCreateSummary> response) {
                return (ImageCreateSummary)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageCreateSummary>> createImagesFromUrlsWithServiceResponseAsync(UUID projectId, ImageUrlCreateBatch batch) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (batch == null) {
            throw new IllegalArgumentException("Parameter batch is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate((Object)batch);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.createImagesFromUrls(projectId, batch, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageCreateSummary>>>(){

            public Observable<ServiceResponse<ImageCreateSummary>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createImagesFromUrlsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageCreateSummary> createImagesFromUrlsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageCreateSummary>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageCreateSummary createImagesFromFiles(UUID projectId, ImageFileCreateBatch batch) {
        return (ImageCreateSummary)((ServiceResponse)this.createImagesFromFilesWithServiceResponseAsync(projectId, batch).toBlocking().single()).body();
    }

    public ServiceFuture<ImageCreateSummary> createImagesFromFilesAsync(UUID projectId, ImageFileCreateBatch batch, ServiceCallback<ImageCreateSummary> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImagesFromFilesWithServiceResponseAsync(projectId, batch), serviceCallback);
    }

    @Override
    public Observable<ImageCreateSummary> createImagesFromFilesAsync(UUID projectId, ImageFileCreateBatch batch) {
        return this.createImagesFromFilesWithServiceResponseAsync(projectId, batch).map((Func1)new Func1<ServiceResponse<ImageCreateSummary>, ImageCreateSummary>(){

            public ImageCreateSummary call(ServiceResponse<ImageCreateSummary> response) {
                return (ImageCreateSummary)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageCreateSummary>> createImagesFromFilesWithServiceResponseAsync(UUID projectId, ImageFileCreateBatch batch) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (batch == null) {
            throw new IllegalArgumentException("Parameter batch is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate((Object)batch);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.createImagesFromFiles(projectId, batch, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageCreateSummary>>>(){

            public Observable<ServiceResponse<ImageCreateSummary>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createImagesFromFilesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageCreateSummary> createImagesFromFilesDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageCreateSummary>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public void deleteImages(UUID projectId, List<UUID> imageIds) {
        ((ServiceResponse)this.deleteImagesWithServiceResponseAsync(projectId, imageIds).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteImagesAsync(UUID projectId, List<UUID> imageIds, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteImagesWithServiceResponseAsync(projectId, imageIds), serviceCallback);
    }

    @Override
    public Observable<Void> deleteImagesAsync(UUID projectId, List<UUID> imageIds) {
        return this.deleteImagesWithServiceResponseAsync(projectId, imageIds).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteImagesWithServiceResponseAsync(UUID projectId, List<UUID> imageIds) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageIds == null) {
            throw new IllegalArgumentException("Parameter imageIds is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(imageIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String imageIdsConverted = this.client.serializerAdapter().serializeList(imageIds, CollectionFormat.CSV);
        return this.service.deleteImages(projectId, imageIdsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deleteImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteImagesDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageCreateSummary createImagesFromData(UUID projectId, byte[] imageData, CreateImagesFromDataOptionalParameter createImagesFromDataOptionalParameter) {
        return (ImageCreateSummary)((ServiceResponse)this.createImagesFromDataWithServiceResponseAsync(projectId, imageData, createImagesFromDataOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<ImageCreateSummary> createImagesFromDataAsync(UUID projectId, byte[] imageData, CreateImagesFromDataOptionalParameter createImagesFromDataOptionalParameter, ServiceCallback<ImageCreateSummary> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImagesFromDataWithServiceResponseAsync(projectId, imageData, createImagesFromDataOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<ImageCreateSummary> createImagesFromDataAsync(UUID projectId, byte[] imageData, CreateImagesFromDataOptionalParameter createImagesFromDataOptionalParameter) {
        return this.createImagesFromDataWithServiceResponseAsync(projectId, imageData, createImagesFromDataOptionalParameter).map((Func1)new Func1<ServiceResponse<ImageCreateSummary>, ImageCreateSummary>(){

            public ImageCreateSummary call(ServiceResponse<ImageCreateSummary> response) {
                return (ImageCreateSummary)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageCreateSummary>> createImagesFromDataWithServiceResponseAsync(UUID projectId, byte[] imageData, CreateImagesFromDataOptionalParameter createImagesFromDataOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageData == null) {
            throw new IllegalArgumentException("Parameter imageData is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        List<UUID> tagIds = createImagesFromDataOptionalParameter != null ? createImagesFromDataOptionalParameter.tagIds() : null;
        return this.createImagesFromDataWithServiceResponseAsync(projectId, imageData, tagIds);
    }

    public Observable<ServiceResponse<ImageCreateSummary>> createImagesFromDataWithServiceResponseAsync(UUID projectId, byte[] imageData, List<UUID> tagIds) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageData == null) {
            throw new IllegalArgumentException("Parameter imageData is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(tagIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String tagIdsConverted = this.client.serializerAdapter().serializeList(tagIds, CollectionFormat.CSV);
        RequestBody imageDataConverted = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (byte[])imageData);
        return this.service.createImagesFromData(projectId, tagIdsConverted, imageDataConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageCreateSummary>>>(){

            public Observable<ServiceResponse<ImageCreateSummary>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createImagesFromDataDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageCreateSummary> createImagesFromDataDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageCreateSummary>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsCreateImagesFromDataParameters createImagesFromData() {
        return new TrainingsCreateImagesFromDataParameters(this);
    }

    @Override
    public List<Image> getImagesByIds(UUID projectId, GetImagesByIdsOptionalParameter getImagesByIdsOptionalParameter) {
        return (List)((ServiceResponse)this.getImagesByIdsWithServiceResponseAsync(projectId, getImagesByIdsOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<List<Image>> getImagesByIdsAsync(UUID projectId, GetImagesByIdsOptionalParameter getImagesByIdsOptionalParameter, ServiceCallback<List<Image>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getImagesByIdsWithServiceResponseAsync(projectId, getImagesByIdsOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<List<Image>> getImagesByIdsAsync(UUID projectId, GetImagesByIdsOptionalParameter getImagesByIdsOptionalParameter) {
        return this.getImagesByIdsWithServiceResponseAsync(projectId, getImagesByIdsOptionalParameter).map((Func1)new Func1<ServiceResponse<List<Image>>, List<Image>>(){

            public List<Image> call(ServiceResponse<List<Image>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Image>>> getImagesByIdsWithServiceResponseAsync(UUID projectId, GetImagesByIdsOptionalParameter getImagesByIdsOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        List<UUID> imageIds = getImagesByIdsOptionalParameter != null ? getImagesByIdsOptionalParameter.imageIds() : null;
        UUID iterationId = getImagesByIdsOptionalParameter != null ? getImagesByIdsOptionalParameter.iterationId() : null;
        return this.getImagesByIdsWithServiceResponseAsync(projectId, imageIds, iterationId);
    }

    public Observable<ServiceResponse<List<Image>>> getImagesByIdsWithServiceResponseAsync(UUID projectId, List<UUID> imageIds, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(imageIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String imageIdsConverted = this.client.serializerAdapter().serializeList(imageIds, CollectionFormat.CSV);
        return this.service.getImagesByIds(projectId, imageIdsConverted, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Image>>>>(){

            public Observable<ServiceResponse<List<Image>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getImagesByIdsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Image>> getImagesByIdsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Image>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetImagesByIdsParameters getImagesByIds() {
        return new TrainingsGetImagesByIdsParameters(this);
    }

    @Override
    public List<Image> getUntaggedImages(UUID projectId, GetUntaggedImagesOptionalParameter getUntaggedImagesOptionalParameter) {
        return (List)((ServiceResponse)this.getUntaggedImagesWithServiceResponseAsync(projectId, getUntaggedImagesOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<List<Image>> getUntaggedImagesAsync(UUID projectId, GetUntaggedImagesOptionalParameter getUntaggedImagesOptionalParameter, ServiceCallback<List<Image>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getUntaggedImagesWithServiceResponseAsync(projectId, getUntaggedImagesOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<List<Image>> getUntaggedImagesAsync(UUID projectId, GetUntaggedImagesOptionalParameter getUntaggedImagesOptionalParameter) {
        return this.getUntaggedImagesWithServiceResponseAsync(projectId, getUntaggedImagesOptionalParameter).map((Func1)new Func1<ServiceResponse<List<Image>>, List<Image>>(){

            public List<Image> call(ServiceResponse<List<Image>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Image>>> getUntaggedImagesWithServiceResponseAsync(UUID projectId, GetUntaggedImagesOptionalParameter getUntaggedImagesOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = getUntaggedImagesOptionalParameter != null ? getUntaggedImagesOptionalParameter.iterationId() : null;
        String orderBy = getUntaggedImagesOptionalParameter != null ? getUntaggedImagesOptionalParameter.orderBy() : null;
        Integer take = getUntaggedImagesOptionalParameter != null ? getUntaggedImagesOptionalParameter.take() : null;
        Integer skip = getUntaggedImagesOptionalParameter != null ? getUntaggedImagesOptionalParameter.skip() : null;
        return this.getUntaggedImagesWithServiceResponseAsync(projectId, iterationId, orderBy, take, skip);
    }

    public Observable<ServiceResponse<List<Image>>> getUntaggedImagesWithServiceResponseAsync(UUID projectId, UUID iterationId, String orderBy, Integer take, Integer skip) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getUntaggedImages(projectId, iterationId, orderBy, take, skip, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Image>>>>(){

            public Observable<ServiceResponse<List<Image>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getUntaggedImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Image>> getUntaggedImagesDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Image>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetUntaggedImagesParameters getUntaggedImages() {
        return new TrainingsGetUntaggedImagesParameters(this);
    }

    @Override
    public List<Image> getTaggedImages(UUID projectId, GetTaggedImagesOptionalParameter getTaggedImagesOptionalParameter) {
        return (List)((ServiceResponse)this.getTaggedImagesWithServiceResponseAsync(projectId, getTaggedImagesOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<List<Image>> getTaggedImagesAsync(UUID projectId, GetTaggedImagesOptionalParameter getTaggedImagesOptionalParameter, ServiceCallback<List<Image>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTaggedImagesWithServiceResponseAsync(projectId, getTaggedImagesOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<List<Image>> getTaggedImagesAsync(UUID projectId, GetTaggedImagesOptionalParameter getTaggedImagesOptionalParameter) {
        return this.getTaggedImagesWithServiceResponseAsync(projectId, getTaggedImagesOptionalParameter).map((Func1)new Func1<ServiceResponse<List<Image>>, List<Image>>(){

            public List<Image> call(ServiceResponse<List<Image>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Image>>> getTaggedImagesWithServiceResponseAsync(UUID projectId, GetTaggedImagesOptionalParameter getTaggedImagesOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = getTaggedImagesOptionalParameter != null ? getTaggedImagesOptionalParameter.iterationId() : null;
        List<UUID> tagIds = getTaggedImagesOptionalParameter != null ? getTaggedImagesOptionalParameter.tagIds() : null;
        String orderBy = getTaggedImagesOptionalParameter != null ? getTaggedImagesOptionalParameter.orderBy() : null;
        Integer take = getTaggedImagesOptionalParameter != null ? getTaggedImagesOptionalParameter.take() : null;
        Integer skip = getTaggedImagesOptionalParameter != null ? getTaggedImagesOptionalParameter.skip() : null;
        return this.getTaggedImagesWithServiceResponseAsync(projectId, iterationId, tagIds, orderBy, take, skip);
    }

    public Observable<ServiceResponse<List<Image>>> getTaggedImagesWithServiceResponseAsync(UUID projectId, UUID iterationId, List<UUID> tagIds, String orderBy, Integer take, Integer skip) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(tagIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String tagIdsConverted = this.client.serializerAdapter().serializeList(tagIds, CollectionFormat.CSV);
        return this.service.getTaggedImages(projectId, iterationId, tagIdsConverted, orderBy, take, skip, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Image>>>>(){

            public Observable<ServiceResponse<List<Image>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getTaggedImagesDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Image>> getTaggedImagesDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Image>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetTaggedImagesParameters getTaggedImages() {
        return new TrainingsGetTaggedImagesParameters(this);
    }

    @Override
    public void deleteImageRegions(UUID projectId, List<UUID> regionIds) {
        ((ServiceResponse)this.deleteImageRegionsWithServiceResponseAsync(projectId, regionIds).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteImageRegionsAsync(UUID projectId, List<UUID> regionIds, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteImageRegionsWithServiceResponseAsync(projectId, regionIds), serviceCallback);
    }

    @Override
    public Observable<Void> deleteImageRegionsAsync(UUID projectId, List<UUID> regionIds) {
        return this.deleteImageRegionsWithServiceResponseAsync(projectId, regionIds).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteImageRegionsWithServiceResponseAsync(UUID projectId, List<UUID> regionIds) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (regionIds == null) {
            throw new IllegalArgumentException("Parameter regionIds is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(regionIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String regionIdsConverted = this.client.serializerAdapter().serializeList(regionIds, CollectionFormat.CSV);
        return this.service.deleteImageRegions(projectId, regionIdsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deleteImageRegionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteImageRegionsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageRegionCreateSummary createImageRegions(UUID projectId, CreateImageRegionsOptionalParameter createImageRegionsOptionalParameter) {
        return (ImageRegionCreateSummary)((ServiceResponse)this.createImageRegionsWithServiceResponseAsync(projectId, createImageRegionsOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<ImageRegionCreateSummary> createImageRegionsAsync(UUID projectId, CreateImageRegionsOptionalParameter createImageRegionsOptionalParameter, ServiceCallback<ImageRegionCreateSummary> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImageRegionsWithServiceResponseAsync(projectId, createImageRegionsOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<ImageRegionCreateSummary> createImageRegionsAsync(UUID projectId, CreateImageRegionsOptionalParameter createImageRegionsOptionalParameter) {
        return this.createImageRegionsWithServiceResponseAsync(projectId, createImageRegionsOptionalParameter).map((Func1)new Func1<ServiceResponse<ImageRegionCreateSummary>, ImageRegionCreateSummary>(){

            public ImageRegionCreateSummary call(ServiceResponse<ImageRegionCreateSummary> response) {
                return (ImageRegionCreateSummary)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageRegionCreateSummary>> createImageRegionsWithServiceResponseAsync(UUID projectId, CreateImageRegionsOptionalParameter createImageRegionsOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        List<ImageRegionCreateEntry> regions = createImageRegionsOptionalParameter != null ? createImageRegionsOptionalParameter.regions() : null;
        return this.createImageRegionsWithServiceResponseAsync(projectId, regions);
    }

    public Observable<ServiceResponse<ImageRegionCreateSummary>> createImageRegionsWithServiceResponseAsync(UUID projectId, List<ImageRegionCreateEntry> regions) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(regions);
        ImageRegionCreateBatch batch = new ImageRegionCreateBatch();
        batch.withRegions(regions);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.createImageRegions(projectId, this.client.apiKey(), this.client.acceptLanguage(), batch, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageRegionCreateSummary>>>(){

            public Observable<ServiceResponse<ImageRegionCreateSummary>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createImageRegionsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageRegionCreateSummary> createImageRegionsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageRegionCreateSummary>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsCreateImageRegionsParameters createImageRegions() {
        return new TrainingsCreateImageRegionsParameters(this);
    }

    @Override
    public void deleteImageTags(UUID projectId, List<UUID> imageIds, List<UUID> tagIds) {
        ((ServiceResponse)this.deleteImageTagsWithServiceResponseAsync(projectId, imageIds, tagIds).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteImageTagsAsync(UUID projectId, List<UUID> imageIds, List<UUID> tagIds, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteImageTagsWithServiceResponseAsync(projectId, imageIds, tagIds), serviceCallback);
    }

    @Override
    public Observable<Void> deleteImageTagsAsync(UUID projectId, List<UUID> imageIds, List<UUID> tagIds) {
        return this.deleteImageTagsWithServiceResponseAsync(projectId, imageIds, tagIds).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteImageTagsWithServiceResponseAsync(UUID projectId, List<UUID> imageIds, List<UUID> tagIds) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (imageIds == null) {
            throw new IllegalArgumentException("Parameter imageIds is required and cannot be null.");
        }
        if (tagIds == null) {
            throw new IllegalArgumentException("Parameter tagIds is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(imageIds);
        Validator.validate(tagIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String imageIdsConverted = this.client.serializerAdapter().serializeList(imageIds, CollectionFormat.CSV);
        String tagIdsConverted = this.client.serializerAdapter().serializeList(tagIds, CollectionFormat.CSV);
        return this.service.deleteImageTags(projectId, imageIdsConverted, tagIdsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.deleteImageTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteImageTagsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public ImageTagCreateSummary createImageTags(UUID projectId, CreateImageTagsOptionalParameter createImageTagsOptionalParameter) {
        return (ImageTagCreateSummary)((ServiceResponse)this.createImageTagsWithServiceResponseAsync(projectId, createImageTagsOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<ImageTagCreateSummary> createImageTagsAsync(UUID projectId, CreateImageTagsOptionalParameter createImageTagsOptionalParameter, ServiceCallback<ImageTagCreateSummary> serviceCallback) {
        return ServiceFuture.fromResponse(this.createImageTagsWithServiceResponseAsync(projectId, createImageTagsOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<ImageTagCreateSummary> createImageTagsAsync(UUID projectId, CreateImageTagsOptionalParameter createImageTagsOptionalParameter) {
        return this.createImageTagsWithServiceResponseAsync(projectId, createImageTagsOptionalParameter).map((Func1)new Func1<ServiceResponse<ImageTagCreateSummary>, ImageTagCreateSummary>(){

            public ImageTagCreateSummary call(ServiceResponse<ImageTagCreateSummary> response) {
                return (ImageTagCreateSummary)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ImageTagCreateSummary>> createImageTagsWithServiceResponseAsync(UUID projectId, CreateImageTagsOptionalParameter createImageTagsOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        List<ImageTagCreateEntry> tags = createImageTagsOptionalParameter != null ? createImageTagsOptionalParameter.tags() : null;
        return this.createImageTagsWithServiceResponseAsync(projectId, tags);
    }

    public Observable<ServiceResponse<ImageTagCreateSummary>> createImageTagsWithServiceResponseAsync(UUID projectId, List<ImageTagCreateEntry> tags) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(tags);
        ImageTagCreateBatch batch = new ImageTagCreateBatch();
        batch.withTags(tags);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.createImageTags(projectId, this.client.apiKey(), this.client.acceptLanguage(), batch, parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ImageTagCreateSummary>>>(){

            public Observable<ServiceResponse<ImageTagCreateSummary>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.createImageTagsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ImageTagCreateSummary> createImageTagsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ImageTagCreateSummary>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsCreateImageTagsParameters createImageTags() {
        return new TrainingsCreateImageTagsParameters(this);
    }

    @Override
    public int getUntaggedImageCount(UUID projectId, GetUntaggedImageCountOptionalParameter getUntaggedImageCountOptionalParameter) {
        return (Integer)((ServiceResponse)this.getUntaggedImageCountWithServiceResponseAsync(projectId, getUntaggedImageCountOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Integer> getUntaggedImageCountAsync(UUID projectId, GetUntaggedImageCountOptionalParameter getUntaggedImageCountOptionalParameter, ServiceCallback<Integer> serviceCallback) {
        return ServiceFuture.fromResponse(this.getUntaggedImageCountWithServiceResponseAsync(projectId, getUntaggedImageCountOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Integer> getUntaggedImageCountAsync(UUID projectId, GetUntaggedImageCountOptionalParameter getUntaggedImageCountOptionalParameter) {
        return this.getUntaggedImageCountWithServiceResponseAsync(projectId, getUntaggedImageCountOptionalParameter).map((Func1)new Func1<ServiceResponse<Integer>, Integer>(){

            public Integer call(ServiceResponse<Integer> response) {
                return (Integer)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Integer>> getUntaggedImageCountWithServiceResponseAsync(UUID projectId, GetUntaggedImageCountOptionalParameter getUntaggedImageCountOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = getUntaggedImageCountOptionalParameter != null ? getUntaggedImageCountOptionalParameter.iterationId() : null;
        return this.getUntaggedImageCountWithServiceResponseAsync(projectId, iterationId);
    }

    public Observable<ServiceResponse<Integer>> getUntaggedImageCountWithServiceResponseAsync(UUID projectId, UUID iterationId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getUntaggedImageCount(projectId, iterationId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Integer>>>(){

            public Observable<ServiceResponse<Integer>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getUntaggedImageCountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Integer> getUntaggedImageCountDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Integer>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetUntaggedImageCountParameters getUntaggedImageCount() {
        return new TrainingsGetUntaggedImageCountParameters(this);
    }

    @Override
    public int getTaggedImageCount(UUID projectId, GetTaggedImageCountOptionalParameter getTaggedImageCountOptionalParameter) {
        return (Integer)((ServiceResponse)this.getTaggedImageCountWithServiceResponseAsync(projectId, getTaggedImageCountOptionalParameter).toBlocking().single()).body();
    }

    public ServiceFuture<Integer> getTaggedImageCountAsync(UUID projectId, GetTaggedImageCountOptionalParameter getTaggedImageCountOptionalParameter, ServiceCallback<Integer> serviceCallback) {
        return ServiceFuture.fromResponse(this.getTaggedImageCountWithServiceResponseAsync(projectId, getTaggedImageCountOptionalParameter), serviceCallback);
    }

    @Override
    public Observable<Integer> getTaggedImageCountAsync(UUID projectId, GetTaggedImageCountOptionalParameter getTaggedImageCountOptionalParameter) {
        return this.getTaggedImageCountWithServiceResponseAsync(projectId, getTaggedImageCountOptionalParameter).map((Func1)new Func1<ServiceResponse<Integer>, Integer>(){

            public Integer call(ServiceResponse<Integer> response) {
                return (Integer)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Integer>> getTaggedImageCountWithServiceResponseAsync(UUID projectId, GetTaggedImageCountOptionalParameter getTaggedImageCountOptionalParameter) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        UUID iterationId = getTaggedImageCountOptionalParameter != null ? getTaggedImageCountOptionalParameter.iterationId() : null;
        List<UUID> tagIds = getTaggedImageCountOptionalParameter != null ? getTaggedImageCountOptionalParameter.tagIds() : null;
        return this.getTaggedImageCountWithServiceResponseAsync(projectId, iterationId, tagIds);
    }

    public Observable<ServiceResponse<Integer>> getTaggedImageCountWithServiceResponseAsync(UUID projectId, UUID iterationId, List<UUID> tagIds) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (projectId == null) {
            throw new IllegalArgumentException("Parameter projectId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        Validator.validate(tagIds);
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        String tagIdsConverted = this.client.serializerAdapter().serializeList(tagIds, CollectionFormat.CSV);
        return this.service.getTaggedImageCount(projectId, iterationId, tagIdsConverted, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Integer>>>(){

            public Observable<ServiceResponse<Integer>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getTaggedImageCountDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Integer> getTaggedImageCountDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Integer>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public TrainingsGetTaggedImageCountParameters getTaggedImageCount() {
        return new TrainingsGetTaggedImageCountParameters(this);
    }

    @Override
    public Domain getDomain(UUID domainId) {
        return (Domain)((ServiceResponse)this.getDomainWithServiceResponseAsync(domainId).toBlocking().single()).body();
    }

    public ServiceFuture<Domain> getDomainAsync(UUID domainId, ServiceCallback<Domain> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDomainWithServiceResponseAsync(domainId), serviceCallback);
    }

    @Override
    public Observable<Domain> getDomainAsync(UUID domainId) {
        return this.getDomainWithServiceResponseAsync(domainId).map((Func1)new Func1<ServiceResponse<Domain>, Domain>(){

            public Domain call(ServiceResponse<Domain> response) {
                return (Domain)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Domain>> getDomainWithServiceResponseAsync(UUID domainId) {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (domainId == null) {
            throw new IllegalArgumentException("Parameter domainId is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getDomain(domainId, this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Domain>>>(){

            public Observable<ServiceResponse<Domain>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getDomainDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Domain> getDomainDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Domain>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    @Override
    public List<Domain> getDomains() {
        return (List)((ServiceResponse)this.getDomainsWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<List<Domain>> getDomainsAsync(ServiceCallback<List<Domain>> serviceCallback) {
        return ServiceFuture.fromResponse(this.getDomainsWithServiceResponseAsync(), serviceCallback);
    }

    @Override
    public Observable<List<Domain>> getDomainsAsync() {
        return this.getDomainsWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<List<Domain>>, List<Domain>>(){

            public List<Domain> call(ServiceResponse<List<Domain>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<Domain>>> getDomainsWithServiceResponseAsync() {
        if (this.client.endpoint() == null) {
            throw new IllegalArgumentException("Parameter this.client.endpoint() is required and cannot be null.");
        }
        if (this.client.apiKey() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiKey() is required and cannot be null.");
        }
        String parameterizedHost = Joiner.on((String)", ").join((Object)"{Endpoint}", (Object)this.client.endpoint(), new Object[0]);
        return this.service.getDomains(this.client.apiKey(), this.client.acceptLanguage(), parameterizedHost, this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<Domain>>>>(){

            public Observable<ServiceResponse<List<Domain>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrainingsImpl.this.getDomainsDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<List<Domain>> getDomainsDelegate(Response<ResponseBody> response) throws CustomVisionErrorException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<List<Domain>>(){}.getType()).registerError(CustomVisionErrorException.class).build(response);
    }

    class TrainingsGetTaggedImageCountParameters
    implements Trainings.TrainingsGetTaggedImageCountDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private List<UUID> tagIds;

        TrainingsGetTaggedImageCountParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetTaggedImageCountParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetTaggedImageCountParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsGetTaggedImageCountParameters withTagIds(List<UUID> tagIds) {
            this.tagIds = tagIds;
            return this;
        }

        @Override
        public int execute() {
            return (Integer)((ServiceResponse)TrainingsImpl.this.getTaggedImageCountWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds).toBlocking().single()).body();
        }

        @Override
        public Observable<Integer> executeAsync() {
            return TrainingsImpl.this.getTaggedImageCountWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds).map((Func1)new Func1<ServiceResponse<Integer>, Integer>(){

                public Integer call(ServiceResponse<Integer> response) {
                    return (Integer)response.body();
                }
            });
        }
    }

    class TrainingsGetUntaggedImageCountParameters
    implements Trainings.TrainingsGetUntaggedImageCountDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;

        TrainingsGetUntaggedImageCountParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetUntaggedImageCountParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetUntaggedImageCountParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public int execute() {
            return (Integer)((ServiceResponse)TrainingsImpl.this.getUntaggedImageCountWithServiceResponseAsync(this.projectId, this.iterationId).toBlocking().single()).body();
        }

        @Override
        public Observable<Integer> executeAsync() {
            return TrainingsImpl.this.getUntaggedImageCountWithServiceResponseAsync(this.projectId, this.iterationId).map((Func1)new Func1<ServiceResponse<Integer>, Integer>(){

                public Integer call(ServiceResponse<Integer> response) {
                    return (Integer)response.body();
                }
            });
        }
    }

    class TrainingsCreateImageTagsParameters
    implements Trainings.TrainingsCreateImageTagsDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private List<ImageTagCreateEntry> tags;

        TrainingsCreateImageTagsParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsCreateImageTagsParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsCreateImageTagsParameters withTags(List<ImageTagCreateEntry> tags) {
            this.tags = tags;
            return this;
        }

        @Override
        public ImageTagCreateSummary execute() {
            return (ImageTagCreateSummary)((ServiceResponse)TrainingsImpl.this.createImageTagsWithServiceResponseAsync(this.projectId, this.tags).toBlocking().single()).body();
        }

        @Override
        public Observable<ImageTagCreateSummary> executeAsync() {
            return TrainingsImpl.this.createImageTagsWithServiceResponseAsync(this.projectId, this.tags).map((Func1)new Func1<ServiceResponse<ImageTagCreateSummary>, ImageTagCreateSummary>(){

                public ImageTagCreateSummary call(ServiceResponse<ImageTagCreateSummary> response) {
                    return (ImageTagCreateSummary)response.body();
                }
            });
        }
    }

    class TrainingsCreateImageRegionsParameters
    implements Trainings.TrainingsCreateImageRegionsDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private List<ImageRegionCreateEntry> regions;

        TrainingsCreateImageRegionsParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsCreateImageRegionsParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsCreateImageRegionsParameters withRegions(List<ImageRegionCreateEntry> regions) {
            this.regions = regions;
            return this;
        }

        @Override
        public ImageRegionCreateSummary execute() {
            return (ImageRegionCreateSummary)((ServiceResponse)TrainingsImpl.this.createImageRegionsWithServiceResponseAsync(this.projectId, this.regions).toBlocking().single()).body();
        }

        @Override
        public Observable<ImageRegionCreateSummary> executeAsync() {
            return TrainingsImpl.this.createImageRegionsWithServiceResponseAsync(this.projectId, this.regions).map((Func1)new Func1<ServiceResponse<ImageRegionCreateSummary>, ImageRegionCreateSummary>(){

                public ImageRegionCreateSummary call(ServiceResponse<ImageRegionCreateSummary> response) {
                    return (ImageRegionCreateSummary)response.body();
                }
            });
        }
    }

    class TrainingsGetTaggedImagesParameters
    implements Trainings.TrainingsGetTaggedImagesDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private List<UUID> tagIds;
        private String orderBy;
        private Integer take;
        private Integer skip;

        TrainingsGetTaggedImagesParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetTaggedImagesParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetTaggedImagesParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsGetTaggedImagesParameters withTagIds(List<UUID> tagIds) {
            this.tagIds = tagIds;
            return this;
        }

        @Override
        public TrainingsGetTaggedImagesParameters withOrderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public TrainingsGetTaggedImagesParameters withTake(Integer take) {
            this.take = take;
            return this;
        }

        @Override
        public TrainingsGetTaggedImagesParameters withSkip(Integer skip) {
            this.skip = skip;
            return this;
        }

        @Override
        public List<Image> execute() {
            return (List)((ServiceResponse)TrainingsImpl.this.getTaggedImagesWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds, this.orderBy, this.take, this.skip).toBlocking().single()).body();
        }

        @Override
        public Observable<List<Image>> executeAsync() {
            return TrainingsImpl.this.getTaggedImagesWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds, this.orderBy, this.take, this.skip).map((Func1)new Func1<ServiceResponse<List<Image>>, List<Image>>(){

                public List<Image> call(ServiceResponse<List<Image>> response) {
                    return (List)response.body();
                }
            });
        }
    }

    class TrainingsGetUntaggedImagesParameters
    implements Trainings.TrainingsGetUntaggedImagesDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private String orderBy;
        private Integer take;
        private Integer skip;

        TrainingsGetUntaggedImagesParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetUntaggedImagesParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetUntaggedImagesParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsGetUntaggedImagesParameters withOrderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public TrainingsGetUntaggedImagesParameters withTake(Integer take) {
            this.take = take;
            return this;
        }

        @Override
        public TrainingsGetUntaggedImagesParameters withSkip(Integer skip) {
            this.skip = skip;
            return this;
        }

        @Override
        public List<Image> execute() {
            return (List)((ServiceResponse)TrainingsImpl.this.getUntaggedImagesWithServiceResponseAsync(this.projectId, this.iterationId, this.orderBy, this.take, this.skip).toBlocking().single()).body();
        }

        @Override
        public Observable<List<Image>> executeAsync() {
            return TrainingsImpl.this.getUntaggedImagesWithServiceResponseAsync(this.projectId, this.iterationId, this.orderBy, this.take, this.skip).map((Func1)new Func1<ServiceResponse<List<Image>>, List<Image>>(){

                public List<Image> call(ServiceResponse<List<Image>> response) {
                    return (List)response.body();
                }
            });
        }
    }

    class TrainingsGetImagesByIdsParameters
    implements Trainings.TrainingsGetImagesByIdsDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private List<UUID> imageIds;
        private UUID iterationId;

        TrainingsGetImagesByIdsParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetImagesByIdsParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetImagesByIdsParameters withImageIds(List<UUID> imageIds) {
            this.imageIds = imageIds;
            return this;
        }

        @Override
        public TrainingsGetImagesByIdsParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public List<Image> execute() {
            return (List)((ServiceResponse)TrainingsImpl.this.getImagesByIdsWithServiceResponseAsync(this.projectId, this.imageIds, this.iterationId).toBlocking().single()).body();
        }

        @Override
        public Observable<List<Image>> executeAsync() {
            return TrainingsImpl.this.getImagesByIdsWithServiceResponseAsync(this.projectId, this.imageIds, this.iterationId).map((Func1)new Func1<ServiceResponse<List<Image>>, List<Image>>(){

                public List<Image> call(ServiceResponse<List<Image>> response) {
                    return (List)response.body();
                }
            });
        }
    }

    class TrainingsCreateImagesFromDataParameters
    implements Trainings.TrainingsCreateImagesFromDataDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private byte[] imageData;
        private List<UUID> tagIds;

        TrainingsCreateImagesFromDataParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsCreateImagesFromDataParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsCreateImagesFromDataParameters withImageData(byte[] imageData) {
            this.imageData = imageData;
            return this;
        }

        @Override
        public TrainingsCreateImagesFromDataParameters withTagIds(List<UUID> tagIds) {
            this.tagIds = tagIds;
            return this;
        }

        @Override
        public ImageCreateSummary execute() {
            return (ImageCreateSummary)((ServiceResponse)TrainingsImpl.this.createImagesFromDataWithServiceResponseAsync(this.projectId, this.imageData, this.tagIds).toBlocking().single()).body();
        }

        @Override
        public Observable<ImageCreateSummary> executeAsync() {
            return TrainingsImpl.this.createImagesFromDataWithServiceResponseAsync(this.projectId, this.imageData, this.tagIds).map((Func1)new Func1<ServiceResponse<ImageCreateSummary>, ImageCreateSummary>(){

                public ImageCreateSummary call(ServiceResponse<ImageCreateSummary> response) {
                    return (ImageCreateSummary)response.body();
                }
            });
        }
    }

    class TrainingsQuickTestImageUrlParameters
    implements Trainings.TrainingsQuickTestImageUrlDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private String url;
        private UUID iterationId;

        TrainingsQuickTestImageUrlParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsQuickTestImageUrlParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsQuickTestImageUrlParameters withUrl(String url) {
            this.url = url;
            return this;
        }

        @Override
        public TrainingsQuickTestImageUrlParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public ImagePrediction execute() {
            return (ImagePrediction)((ServiceResponse)TrainingsImpl.this.quickTestImageUrlWithServiceResponseAsync(this.projectId, this.url, this.iterationId).toBlocking().single()).body();
        }

        @Override
        public Observable<ImagePrediction> executeAsync() {
            return TrainingsImpl.this.quickTestImageUrlWithServiceResponseAsync(this.projectId, this.url, this.iterationId).map((Func1)new Func1<ServiceResponse<ImagePrediction>, ImagePrediction>(){

                public ImagePrediction call(ServiceResponse<ImagePrediction> response) {
                    return (ImagePrediction)response.body();
                }
            });
        }
    }

    class TrainingsQuickTestImageParameters
    implements Trainings.TrainingsQuickTestImageDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private byte[] imageData;
        private UUID iterationId;

        TrainingsQuickTestImageParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsQuickTestImageParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsQuickTestImageParameters withImageData(byte[] imageData) {
            this.imageData = imageData;
            return this;
        }

        @Override
        public TrainingsQuickTestImageParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public ImagePrediction execute() {
            return (ImagePrediction)((ServiceResponse)TrainingsImpl.this.quickTestImageWithServiceResponseAsync(this.projectId, this.imageData, this.iterationId).toBlocking().single()).body();
        }

        @Override
        public Observable<ImagePrediction> executeAsync() {
            return TrainingsImpl.this.quickTestImageWithServiceResponseAsync(this.projectId, this.imageData, this.iterationId).map((Func1)new Func1<ServiceResponse<ImagePrediction>, ImagePrediction>(){

                public ImagePrediction call(ServiceResponse<ImagePrediction> response) {
                    return (ImagePrediction)response.body();
                }
            });
        }
    }

    class TrainingsGetIterationPerformanceParameters
    implements Trainings.TrainingsGetIterationPerformanceDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private Double threshold;
        private Double overlapThreshold;

        TrainingsGetIterationPerformanceParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetIterationPerformanceParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetIterationPerformanceParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsGetIterationPerformanceParameters withThreshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public TrainingsGetIterationPerformanceParameters withOverlapThreshold(Double overlapThreshold) {
            this.overlapThreshold = overlapThreshold;
            return this;
        }

        @Override
        public IterationPerformance execute() {
            return (IterationPerformance)((ServiceResponse)TrainingsImpl.this.getIterationPerformanceWithServiceResponseAsync(this.projectId, this.iterationId, this.threshold, this.overlapThreshold).toBlocking().single()).body();
        }

        @Override
        public Observable<IterationPerformance> executeAsync() {
            return TrainingsImpl.this.getIterationPerformanceWithServiceResponseAsync(this.projectId, this.iterationId, this.threshold, this.overlapThreshold).map((Func1)new Func1<ServiceResponse<IterationPerformance>, IterationPerformance>(){

                public IterationPerformance call(ServiceResponse<IterationPerformance> response) {
                    return (IterationPerformance)response.body();
                }
            });
        }
    }

    class TrainingsGetImagePerformancesParameters
    implements Trainings.TrainingsGetImagePerformancesDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private List<UUID> tagIds;
        private String orderBy;
        private Integer take;
        private Integer skip;

        TrainingsGetImagePerformancesParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetImagePerformancesParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetImagePerformancesParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsGetImagePerformancesParameters withTagIds(List<UUID> tagIds) {
            this.tagIds = tagIds;
            return this;
        }

        @Override
        public TrainingsGetImagePerformancesParameters withOrderBy(String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        @Override
        public TrainingsGetImagePerformancesParameters withTake(Integer take) {
            this.take = take;
            return this;
        }

        @Override
        public TrainingsGetImagePerformancesParameters withSkip(Integer skip) {
            this.skip = skip;
            return this;
        }

        @Override
        public List<ImagePerformance> execute() {
            return (List)((ServiceResponse)TrainingsImpl.this.getImagePerformancesWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds, this.orderBy, this.take, this.skip).toBlocking().single()).body();
        }

        @Override
        public Observable<List<ImagePerformance>> executeAsync() {
            return TrainingsImpl.this.getImagePerformancesWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds, this.orderBy, this.take, this.skip).map((Func1)new Func1<ServiceResponse<List<ImagePerformance>>, List<ImagePerformance>>(){

                public List<ImagePerformance> call(ServiceResponse<List<ImagePerformance>> response) {
                    return (List)response.body();
                }
            });
        }
    }

    class TrainingsGetImagePerformanceCountParameters
    implements Trainings.TrainingsGetImagePerformanceCountDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private List<UUID> tagIds;

        TrainingsGetImagePerformanceCountParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetImagePerformanceCountParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetImagePerformanceCountParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsGetImagePerformanceCountParameters withTagIds(List<UUID> tagIds) {
            this.tagIds = tagIds;
            return this;
        }

        @Override
        public int execute() {
            return (Integer)((ServiceResponse)TrainingsImpl.this.getImagePerformanceCountWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds).toBlocking().single()).body();
        }

        @Override
        public Observable<Integer> executeAsync() {
            return TrainingsImpl.this.getImagePerformanceCountWithServiceResponseAsync(this.projectId, this.iterationId, this.tagIds).map((Func1)new Func1<ServiceResponse<Integer>, Integer>(){

                public Integer call(ServiceResponse<Integer> response) {
                    return (Integer)response.body();
                }
            });
        }
    }

    class TrainingsCreateProjectParameters
    implements Trainings.TrainingsCreateProjectDefinition {
        private TrainingsImpl parent;
        private String name;
        private String description;
        private UUID domainId;
        private String classificationType;
        private List<String> targetExportPlatforms;

        TrainingsCreateProjectParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsCreateProjectParameters withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public TrainingsCreateProjectParameters withDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public TrainingsCreateProjectParameters withDomainId(UUID domainId) {
            this.domainId = domainId;
            return this;
        }

        @Override
        public TrainingsCreateProjectParameters withClassificationType(String classificationType) {
            this.classificationType = classificationType;
            return this;
        }

        @Override
        public TrainingsCreateProjectParameters withTargetExportPlatforms(List<String> targetExportPlatforms) {
            this.targetExportPlatforms = targetExportPlatforms;
            return this;
        }

        @Override
        public Project execute() {
            return (Project)((ServiceResponse)TrainingsImpl.this.createProjectWithServiceResponseAsync(this.name, this.description, this.domainId, this.classificationType, this.targetExportPlatforms).toBlocking().single()).body();
        }

        @Override
        public Observable<Project> executeAsync() {
            return TrainingsImpl.this.createProjectWithServiceResponseAsync(this.name, this.description, this.domainId, this.classificationType, this.targetExportPlatforms).map((Func1)new Func1<ServiceResponse<Project>, Project>(){

                public Project call(ServiceResponse<Project> response) {
                    return (Project)response.body();
                }
            });
        }
    }

    class TrainingsTrainProjectParameters
    implements Trainings.TrainingsTrainProjectDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private String trainingType;
        private Integer reservedBudgetInHours;
        private Boolean forceTrain;
        private String notificationEmailAddress;

        TrainingsTrainProjectParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsTrainProjectParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsTrainProjectParameters withTrainingType(String trainingType) {
            this.trainingType = trainingType;
            return this;
        }

        @Override
        public TrainingsTrainProjectParameters withReservedBudgetInHours(Integer reservedBudgetInHours) {
            this.reservedBudgetInHours = reservedBudgetInHours;
            return this;
        }

        @Override
        public TrainingsTrainProjectParameters withForceTrain(Boolean forceTrain) {
            this.forceTrain = forceTrain;
            return this;
        }

        @Override
        public TrainingsTrainProjectParameters withNotificationEmailAddress(String notificationEmailAddress) {
            this.notificationEmailAddress = notificationEmailAddress;
            return this;
        }

        @Override
        public Iteration execute() {
            return (Iteration)((ServiceResponse)TrainingsImpl.this.trainProjectWithServiceResponseAsync(this.projectId, this.trainingType, this.reservedBudgetInHours, this.forceTrain, this.notificationEmailAddress).toBlocking().single()).body();
        }

        @Override
        public Observable<Iteration> executeAsync() {
            return TrainingsImpl.this.trainProjectWithServiceResponseAsync(this.projectId, this.trainingType, this.reservedBudgetInHours, this.forceTrain, this.notificationEmailAddress).map((Func1)new Func1<ServiceResponse<Iteration>, Iteration>(){

                public Iteration call(ServiceResponse<Iteration> response) {
                    return (Iteration)response.body();
                }
            });
        }
    }

    class TrainingsExportIterationParameters
    implements Trainings.TrainingsExportIterationDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;
        private String platform;
        private String flavor;

        TrainingsExportIterationParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsExportIterationParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsExportIterationParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public TrainingsExportIterationParameters withPlatform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public TrainingsExportIterationParameters withFlavor(String flavor) {
            this.flavor = flavor;
            return this;
        }

        @Override
        public Export execute() {
            return (Export)((ServiceResponse)TrainingsImpl.this.exportIterationWithServiceResponseAsync(this.projectId, this.iterationId, this.platform, this.flavor).toBlocking().single()).body();
        }

        @Override
        public Observable<Export> executeAsync() {
            return TrainingsImpl.this.exportIterationWithServiceResponseAsync(this.projectId, this.iterationId, this.platform, this.flavor).map((Func1)new Func1<ServiceResponse<Export>, Export>(){

                public Export call(ServiceResponse<Export> response) {
                    return (Export)response.body();
                }
            });
        }
    }

    class TrainingsGetTagParameters
    implements Trainings.TrainingsGetTagDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID tagId;
        private UUID iterationId;

        TrainingsGetTagParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetTagParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetTagParameters withTagId(UUID tagId) {
            this.tagId = tagId;
            return this;
        }

        @Override
        public TrainingsGetTagParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public Tag execute() {
            return (Tag)((ServiceResponse)TrainingsImpl.this.getTagWithServiceResponseAsync(this.projectId, this.tagId, this.iterationId).toBlocking().single()).body();
        }

        @Override
        public Observable<Tag> executeAsync() {
            return TrainingsImpl.this.getTagWithServiceResponseAsync(this.projectId, this.tagId, this.iterationId).map((Func1)new Func1<ServiceResponse<Tag>, Tag>(){

                public Tag call(ServiceResponse<Tag> response) {
                    return (Tag)response.body();
                }
            });
        }
    }

    class TrainingsGetTagsParameters
    implements Trainings.TrainingsGetTagsDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private UUID iterationId;

        TrainingsGetTagsParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsGetTagsParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsGetTagsParameters withIterationId(UUID iterationId) {
            this.iterationId = iterationId;
            return this;
        }

        @Override
        public List<Tag> execute() {
            return (List)((ServiceResponse)TrainingsImpl.this.getTagsWithServiceResponseAsync(this.projectId, this.iterationId).toBlocking().single()).body();
        }

        @Override
        public Observable<List<Tag>> executeAsync() {
            return TrainingsImpl.this.getTagsWithServiceResponseAsync(this.projectId, this.iterationId).map((Func1)new Func1<ServiceResponse<List<Tag>>, List<Tag>>(){

                public List<Tag> call(ServiceResponse<List<Tag>> response) {
                    return (List)response.body();
                }
            });
        }
    }

    class TrainingsCreateTagParameters
    implements Trainings.TrainingsCreateTagDefinition {
        private TrainingsImpl parent;
        private UUID projectId;
        private String name;
        private String description;
        private String type;

        TrainingsCreateTagParameters(TrainingsImpl parent) {
            this.parent = parent;
        }

        @Override
        public TrainingsCreateTagParameters withProjectId(UUID projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        public TrainingsCreateTagParameters withName(String name) {
            this.name = name;
            return this;
        }

        @Override
        public TrainingsCreateTagParameters withDescription(String description) {
            this.description = description;
            return this;
        }

        @Override
        public TrainingsCreateTagParameters withType(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Tag execute() {
            return (Tag)((ServiceResponse)TrainingsImpl.this.createTagWithServiceResponseAsync(this.projectId, this.name, this.description, this.type).toBlocking().single()).body();
        }

        @Override
        public Observable<Tag> executeAsync() {
            return TrainingsImpl.this.createTagWithServiceResponseAsync(this.projectId, this.name, this.description, this.type).map((Func1)new Func1<ServiceResponse<Tag>, Tag>(){

                public Tag call(ServiceResponse<Tag> response) {
                    return (Tag)response.body();
                }
            });
        }
    }

    static interface TrainingsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createTag"})
        @POST(value="projects/{projectId}/tags")
        public Observable<Response<ResponseBody>> createTag(@Path(value="projectId") UUID var1, @Query(value="name") String var2, @Query(value="description") String var3, @Query(value="type") String var4, @Header(value="Training-Key") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getTags"})
        @GET(value="projects/{projectId}/tags")
        public Observable<Response<ResponseBody>> getTags(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings updateTag"})
        @PATCH(value="projects/{projectId}/tags/{tagId}")
        public Observable<Response<ResponseBody>> updateTag(@Path(value="projectId") UUID var1, @Path(value="tagId") UUID var2, @Body Tag var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deleteTag"})
        @HTTP(path="projects/{projectId}/tags/{tagId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteTag(@Path(value="projectId") UUID var1, @Path(value="tagId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getTag"})
        @GET(value="projects/{projectId}/tags/{tagId}")
        public Observable<Response<ResponseBody>> getTag(@Path(value="projectId") UUID var1, @Path(value="tagId") UUID var2, @Query(value="iterationId") UUID var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings exportIteration"})
        @POST(value="projects/{projectId}/iterations/{iterationId}/export")
        public Observable<Response<ResponseBody>> exportIteration(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Query(value="platform") String var3, @Query(value="flavor") String var4, @Header(value="Training-Key") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getExports"})
        @GET(value="projects/{projectId}/iterations/{iterationId}/export")
        public Observable<Response<ResponseBody>> getExports(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings unpublishIteration"})
        @HTTP(path="projects/{projectId}/iterations/{iterationId}/publish", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> unpublishIteration(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings publishIteration"})
        @POST(value="projects/{projectId}/iterations/{iterationId}/publish")
        public Observable<Response<ResponseBody>> publishIteration(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Query(value="publishName") String var3, @Query(value="predictionId") String var4, @Header(value="Training-Key") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings updateIteration"})
        @PATCH(value="projects/{projectId}/iterations/{iterationId}")
        public Observable<Response<ResponseBody>> updateIteration(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Body Iteration var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deleteIteration"})
        @HTTP(path="projects/{projectId}/iterations/{iterationId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteIteration(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getIteration"})
        @GET(value="projects/{projectId}/iterations/{iterationId}")
        public Observable<Response<ResponseBody>> getIteration(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getIterations"})
        @GET(value="projects/{projectId}/iterations")
        public Observable<Response<ResponseBody>> getIterations(@Path(value="projectId") UUID var1, @Header(value="Training-Key") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings trainProject"})
        @POST(value="projects/{projectId}/train")
        public Observable<Response<ResponseBody>> trainProject(@Path(value="projectId") UUID var1, @Query(value="trainingType") String var2, @Query(value="reservedBudgetInHours") Integer var3, @Query(value="forceTrain") Boolean var4, @Query(value="notificationEmailAddress") String var5, @Header(value="Training-Key") String var6, @Header(value="accept-language") String var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings updateProject"})
        @PATCH(value="projects/{projectId}")
        public Observable<Response<ResponseBody>> updateProject(@Path(value="projectId") UUID var1, @Body Project var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deleteProject"})
        @HTTP(path="projects/{projectId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteProject(@Path(value="projectId") UUID var1, @Header(value="Training-Key") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getProject"})
        @GET(value="projects/{projectId}")
        public Observable<Response<ResponseBody>> getProject(@Path(value="projectId") UUID var1, @Header(value="Training-Key") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createProject"})
        @POST(value="projects")
        public Observable<Response<ResponseBody>> createProject(@Query(value="name") String var1, @Query(value="description") String var2, @Query(value="domainId") UUID var3, @Query(value="classificationType") String var4, @Query(value="targetExportPlatforms") String var5, @Header(value="Training-Key") String var6, @Header(value="accept-language") String var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getProjects"})
        @GET(value="projects")
        public Observable<Response<ResponseBody>> getProjects(@Header(value="Training-Key") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getImagePerformanceCount"})
        @GET(value="projects/{projectId}/iterations/{iterationId}/performance/images/count")
        public Observable<Response<ResponseBody>> getImagePerformanceCount(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Query(value="tagIds") String var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getImagePerformances"})
        @GET(value="projects/{projectId}/iterations/{iterationId}/performance/images")
        public Observable<Response<ResponseBody>> getImagePerformances(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Query(value="tagIds") String var3, @Query(value="orderBy") String var4, @Query(value="take") Integer var5, @Query(value="skip") Integer var6, @Header(value="Training-Key") String var7, @Header(value="accept-language") String var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getIterationPerformance"})
        @GET(value="projects/{projectId}/iterations/{iterationId}/performance")
        public Observable<Response<ResponseBody>> getIterationPerformance(@Path(value="projectId") UUID var1, @Path(value="iterationId") UUID var2, @Query(value="threshold") Double var3, @Query(value="overlapThreshold") Double var4, @Header(value="Training-Key") String var5, @Header(value="accept-language") String var6, @Header(value="x-ms-parameterized-host") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings queryPredictions"})
        @POST(value="projects/{projectId}/predictions/query")
        public Observable<Response<ResponseBody>> queryPredictions(@Path(value="projectId") UUID var1, @Body PredictionQueryToken var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Multipart
        @POST(value="projects/{projectId}/quicktest/image")
        public Observable<Response<ResponseBody>> quickTestImage(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Part(value="imageData") RequestBody var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings quickTestImageUrl"})
        @POST(value="projects/{projectId}/quicktest/url")
        public Observable<Response<ResponseBody>> quickTestImageUrl(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Body ImageUrl var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deletePrediction"})
        @HTTP(path="projects/{projectId}/predictions", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deletePrediction(@Path(value="projectId") UUID var1, @Query(value="ids") String var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getImageRegionProposals"})
        @POST(value="projects/{projectId}/images/{imageId}/regionproposals")
        public Observable<Response<ResponseBody>> getImageRegionProposals(@Path(value="projectId") UUID var1, @Path(value="imageId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createImagesFromPredictions"})
        @POST(value="projects/{projectId}/images/predictions")
        public Observable<Response<ResponseBody>> createImagesFromPredictions(@Path(value="projectId") UUID var1, @Body ImageIdCreateBatch var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createImagesFromUrls"})
        @POST(value="projects/{projectId}/images/urls")
        public Observable<Response<ResponseBody>> createImagesFromUrls(@Path(value="projectId") UUID var1, @Body ImageUrlCreateBatch var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createImagesFromFiles"})
        @POST(value="projects/{projectId}/images/files")
        public Observable<Response<ResponseBody>> createImagesFromFiles(@Path(value="projectId") UUID var1, @Body ImageFileCreateBatch var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deleteImages"})
        @HTTP(path="projects/{projectId}/images", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteImages(@Path(value="projectId") UUID var1, @Query(value="imageIds") String var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Multipart
        @POST(value="projects/{projectId}/images")
        public Observable<Response<ResponseBody>> createImagesFromData(@Path(value="projectId") UUID var1, @Query(value="tagIds") String var2, @Part(value="imageData") RequestBody var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getImagesByIds"})
        @GET(value="projects/{projectId}/images/id")
        public Observable<Response<ResponseBody>> getImagesByIds(@Path(value="projectId") UUID var1, @Query(value="imageIds") String var2, @Query(value="iterationId") UUID var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getUntaggedImages"})
        @GET(value="projects/{projectId}/images/untagged")
        public Observable<Response<ResponseBody>> getUntaggedImages(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Query(value="orderBy") String var3, @Query(value="take") Integer var4, @Query(value="skip") Integer var5, @Header(value="Training-Key") String var6, @Header(value="accept-language") String var7, @Header(value="x-ms-parameterized-host") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getTaggedImages"})
        @GET(value="projects/{projectId}/images/tagged")
        public Observable<Response<ResponseBody>> getTaggedImages(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Query(value="tagIds") String var3, @Query(value="orderBy") String var4, @Query(value="take") Integer var5, @Query(value="skip") Integer var6, @Header(value="Training-Key") String var7, @Header(value="accept-language") String var8, @Header(value="x-ms-parameterized-host") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deleteImageRegions"})
        @HTTP(path="projects/{projectId}/images/regions", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteImageRegions(@Path(value="projectId") UUID var1, @Query(value="regionIds") String var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createImageRegions"})
        @POST(value="projects/{projectId}/images/regions")
        public Observable<Response<ResponseBody>> createImageRegions(@Path(value="projectId") UUID var1, @Header(value="Training-Key") String var2, @Header(value="accept-language") String var3, @Body ImageRegionCreateBatch var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings deleteImageTags"})
        @HTTP(path="projects/{projectId}/images/tags", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> deleteImageTags(@Path(value="projectId") UUID var1, @Query(value="imageIds") String var2, @Query(value="tagIds") String var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings createImageTags"})
        @POST(value="projects/{projectId}/images/tags")
        public Observable<Response<ResponseBody>> createImageTags(@Path(value="projectId") UUID var1, @Header(value="Training-Key") String var2, @Header(value="accept-language") String var3, @Body ImageTagCreateBatch var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getUntaggedImageCount"})
        @GET(value="projects/{projectId}/images/untagged/count")
        public Observable<Response<ResponseBody>> getUntaggedImageCount(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Header(value="Training-Key") String var3, @Header(value="accept-language") String var4, @Header(value="x-ms-parameterized-host") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getTaggedImageCount"})
        @GET(value="projects/{projectId}/images/tagged/count")
        public Observable<Response<ResponseBody>> getTaggedImageCount(@Path(value="projectId") UUID var1, @Query(value="iterationId") UUID var2, @Query(value="tagIds") String var3, @Header(value="Training-Key") String var4, @Header(value="accept-language") String var5, @Header(value="x-ms-parameterized-host") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getDomain"})
        @GET(value="domains/{domainId}")
        public Observable<Response<ResponseBody>> getDomain(@Path(value="domainId") UUID var1, @Header(value="Training-Key") String var2, @Header(value="accept-language") String var3, @Header(value="x-ms-parameterized-host") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.cognitiveservices.vision.customvision.training.Trainings getDomains"})
        @GET(value="domains")
        public Observable<Response<ResponseBody>> getDomains(@Header(value="Training-Key") String var1, @Header(value="accept-language") String var2, @Header(value="x-ms-parameterized-host") String var3, @Header(value="User-Agent") String var4);
    }
}

