/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.models.events.AddParticipantFailed;
import com.azure.communication.callautomation.models.events.AddParticipantSucceeded;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.azure.communication.callautomation.models.events.CallConnected;
import com.azure.communication.callautomation.models.events.CallDisconnected;
import com.azure.communication.callautomation.models.events.CallTransferAccepted;
import com.azure.communication.callautomation.models.events.CallTransferFailed;
import com.azure.communication.callautomation.models.events.CancelAddParticipantFailed;
import com.azure.communication.callautomation.models.events.CancelAddParticipantSucceeded;
import com.azure.communication.callautomation.models.events.ContinuousDtmfRecognitionStopped;
import com.azure.communication.callautomation.models.events.ContinuousDtmfRecognitionToneFailed;
import com.azure.communication.callautomation.models.events.ContinuousDtmfRecognitionToneReceived;
import com.azure.communication.callautomation.models.events.ParticipantsUpdated;
import com.azure.communication.callautomation.models.events.PlayCanceled;
import com.azure.communication.callautomation.models.events.PlayCompleted;
import com.azure.communication.callautomation.models.events.PlayFailed;
import com.azure.communication.callautomation.models.events.RecognizeCanceled;
import com.azure.communication.callautomation.models.events.RecognizeCompleted;
import com.azure.communication.callautomation.models.events.RecognizeFailed;
import com.azure.communication.callautomation.models.events.RecordingStateChanged;
import com.azure.communication.callautomation.models.events.RemoveParticipantFailed;
import com.azure.communication.callautomation.models.events.RemoveParticipantSucceeded;
import com.azure.communication.callautomation.models.events.SendDtmfTonesCompleted;
import com.azure.communication.callautomation.models.events.SendDtmfTonesFailed;
import com.azure.core.models.CloudEvent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CallAutomationEventParser {
    private static final ClientLogger LOGGER = new ClientLogger(CallAutomationEventParser.class);

    public static List<CallAutomationEventBase> parseEvents(String requestBody) {
        List<CallAutomationEventBase> callAutomationBaseEvents = CallAutomationEventParser.parseCloudEventList(requestBody);
        return callAutomationBaseEvents;
    }

    private static List<CallAutomationEventBase> parseCloudEventList(String requestBody) {
        try {
            List cloudEvents;
            ArrayList<CallAutomationEventBase> callAutomationBaseEvents = new ArrayList<CallAutomationEventBase>();
            try {
                cloudEvents = CloudEvent.fromString((String)requestBody);
            }
            catch (RuntimeException e) {
                return callAutomationBaseEvents;
            }
            for (CloudEvent cloudEvent : cloudEvents) {
                CallAutomationEventBase temp = CallAutomationEventParser.parseSingleCloudEvent(cloudEvent.getData().toString(), cloudEvent.getType());
                if (temp == null) continue;
                callAutomationBaseEvents.add(temp);
            }
            return callAutomationBaseEvents;
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    private static CallAutomationEventBase parseSingleCloudEvent(String data, String eventType) {
        try {
            CallAutomationEventBase ret = null;
            ObjectMapper mapper = new ObjectMapper();
            mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            JsonNode eventData = mapper.readTree(data);
            if (Objects.equals(eventType, "Microsoft.Communication.CallConnected")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, CallConnected.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.CallDisconnected")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, CallDisconnected.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.AddParticipantFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, AddParticipantFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.AddParticipantSucceeded")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, AddParticipantSucceeded.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.CallTransferAccepted")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, CallTransferAccepted.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.CallTransferFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, CallTransferFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.ParticipantsUpdated")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, ParticipantsUpdated.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.RecordingStateChanged")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, RecordingStateChanged.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.PlayCompleted")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, PlayCompleted.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.PlayFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, PlayFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.PlayCanceled")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, PlayCanceled.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.RecognizeCompleted")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, RecognizeCompleted.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.RecognizeFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, RecognizeFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.RecognizeCanceled")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, RecognizeCanceled.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.RemoveParticipantFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, RemoveParticipantFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.RemoveParticipantSucceeded")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, RemoveParticipantSucceeded.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.ContinuousDtmfRecognitionToneReceived")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, ContinuousDtmfRecognitionToneReceived.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.ContinuousDtmfRecognitionToneFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, ContinuousDtmfRecognitionToneFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.ContinuousDtmfRecognitionStopped")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, ContinuousDtmfRecognitionStopped.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.SendDtmfTonesCompleted")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, SendDtmfTonesCompleted.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.SendDtmfTonesFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, SendDtmfTonesFailed.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.CancelAddParticipantSucceeded")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, CancelAddParticipantSucceeded.class);
            } else if (Objects.equals(eventType, "Microsoft.Communication.CancelAddParticipantFailed")) {
                ret = (CallAutomationEventBase)mapper.convertValue((Object)eventData, CancelAddParticipantFailed.class);
            }
            return ret;
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
        catch (JsonProcessingException e) {
            throw LOGGER.logExceptionAsError(new RuntimeException(e));
        }
    }
}

