/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation;

import com.azure.communication.callautomation.CallMediaAsync;
import com.azure.communication.callautomation.models.CallMediaRecognizeOptions;
import com.azure.communication.callautomation.models.ContinuousDtmfRecognitionOptions;
import com.azure.communication.callautomation.models.DtmfTone;
import com.azure.communication.callautomation.models.PlayOptions;
import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.PlayToAllOptions;
import com.azure.communication.callautomation.models.SendDtmfTonesOptions;
import com.azure.communication.callautomation.models.SendDtmfTonesResult;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import java.util.List;

public final class CallMedia {
    private final CallMediaAsync callMediaAsync;

    CallMedia(CallMediaAsync callMediaAsync) {
        this.callMediaAsync = callMediaAsync;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void play(List<PlaySource> playSources, List<CommunicationIdentifier> playTo) {
        this.callMediaAsync.play(playSources, playTo).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void play(PlaySource playSource, List<CommunicationIdentifier> playTo) {
        this.callMediaAsync.play(playSource, playTo).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void playToAll(List<PlaySource> playSources) {
        this.callMediaAsync.playToAll(playSources).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void playToAll(PlaySource playSource) {
        this.callMediaAsync.playToAll(playSource).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> playWithResponse(PlayOptions options, Context context) {
        return (Response)this.callMediaAsync.playWithResponseInternal(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> playToAllWithResponse(PlayToAllOptions options, Context context) {
        return (Response)this.callMediaAsync.playToAllWithResponseInternal(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startRecognizing(CallMediaRecognizeOptions callMediaRecognizeOptions) {
        this.callMediaAsync.startRecognizing(callMediaRecognizeOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startRecognizingWithResponse(CallMediaRecognizeOptions callMediaRecognizeOptions, Context context) {
        return (Response)this.callMediaAsync.recognizeWithResponseInternal(callMediaRecognizeOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancelAllMediaOperations() {
        this.cancelAllMediaOperationsWithResponse(null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelAllMediaOperationsWithResponse(Context context) {
        return (Response)this.callMediaAsync.cancelAllMediaOperationsWithResponseInternal(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public SendDtmfTonesResult sendDtmfTones(List<DtmfTone> tones, CommunicationIdentifier targetParticipant) {
        return (SendDtmfTonesResult)this.callMediaAsync.sendDtmfTones(tones, targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<SendDtmfTonesResult> sendDtmfTonesWithResponse(SendDtmfTonesOptions options, Context context) {
        return (Response)this.callMediaAsync.sendDtmfTonesWithResponseInternal(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void startContinuousDtmfRecognition(CommunicationIdentifier targetParticipant) {
        this.callMediaAsync.startContinuousDtmfRecognition(targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> startContinuousDtmfRecognitionWithResponse(ContinuousDtmfRecognitionOptions options, Context context) {
        return (Response)this.callMediaAsync.startContinuousDtmfRecognitionWithResponseInternal(options, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void stopContinuousDtmfRecognition(CommunicationIdentifier targetParticipant) {
        this.callMediaAsync.stopContinuousDtmfRecognition(targetParticipant).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> stopContinuousDtmfRecognitionWithResponse(ContinuousDtmfRecognitionOptions options, Context context) {
        return (Response)this.callMediaAsync.stopContinuousDtmfRecognitionWithResponseInternal(options, context).block();
    }
}

