/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.implementation;

import com.azure.communication.callautomation.implementation.CallConnectionsImpl;
import com.azure.communication.callautomation.implementation.CallMediasImpl;
import com.azure.communication.callautomation.implementation.CallRecordingsImpl;
import com.azure.communication.callautomation.implementation.models.AnswerCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callautomation.implementation.models.CreateCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RedirectCallRequestInternal;
import com.azure.communication.callautomation.implementation.models.RejectCallRequestInternal;
import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.time.OffsetDateTime;
import java.util.UUID;
import reactor.core.publisher.Mono;

public final class AzureCommunicationCallAutomationServiceImpl {
    private final AzureCommunicationCallAutomationServiceService service;
    private final String endpoint;
    private final String apiVersion;
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializerAdapter;
    private final CallConnectionsImpl callConnections;
    private final CallMediasImpl callMedias;
    private final CallRecordingsImpl callRecordings;

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public HttpPipeline getHttpPipeline() {
        return this.httpPipeline;
    }

    public SerializerAdapter getSerializerAdapter() {
        return this.serializerAdapter;
    }

    public CallConnectionsImpl getCallConnections() {
        return this.callConnections;
    }

    public CallMediasImpl getCallMedias() {
        return this.callMedias;
    }

    public CallRecordingsImpl getCallRecordings() {
        return this.callRecordings;
    }

    AzureCommunicationCallAutomationServiceImpl(String endpoint, String apiVersion) {
        this(new HttpPipelineBuilder().policies(new HttpPipelinePolicy[]{new UserAgentPolicy(), new RetryPolicy()}).build(), JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    AzureCommunicationCallAutomationServiceImpl(HttpPipeline httpPipeline, String endpoint, String apiVersion) {
        this(httpPipeline, JacksonAdapter.createDefaultSerializerAdapter(), endpoint, apiVersion);
    }

    AzureCommunicationCallAutomationServiceImpl(HttpPipeline httpPipeline, SerializerAdapter serializerAdapter, String endpoint, String apiVersion) {
        this.httpPipeline = httpPipeline;
        this.serializerAdapter = serializerAdapter;
        this.endpoint = endpoint;
        this.apiVersion = apiVersion;
        this.callConnections = new CallConnectionsImpl(this);
        this.callMedias = new CallMediasImpl(this);
        this.callRecordings = new CallRecordingsImpl(this);
        this.service = (AzureCommunicationCallAutomationServiceService)RestProxy.create(AzureCommunicationCallAutomationServiceService.class, (HttpPipeline)this.httpPipeline, (SerializerAdapter)this.getSerializerAdapter());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> createCallWithResponseAsync(CreateCallRequestInternal createCallRequest) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return FluxUtil.withContext(context -> this.service.createCall(this.getEndpoint(), this.getApiVersion(), createCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> createCallWithResponseAsync(CreateCallRequestInternal createCallRequest, Context context) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return this.service.createCall(this.getEndpoint(), this.getApiVersion(), createCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> createCallAsync(CreateCallRequestInternal createCallRequest) {
        return this.createCallWithResponseAsync(createCallRequest).flatMap(res -> Mono.justOrEmpty((Object)((CallConnectionPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> createCallAsync(CreateCallRequestInternal createCallRequest, Context context) {
        return this.createCallWithResponseAsync(createCallRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((CallConnectionPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> createCallWithResponse(CreateCallRequestInternal createCallRequest, Context context) {
        return (Response)this.createCallWithResponseAsync(createCallRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionPropertiesInternal createCall(CreateCallRequestInternal createCallRequest) {
        return (CallConnectionPropertiesInternal)this.createCallWithResponse(createCallRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> answerCallWithResponseAsync(AnswerCallRequestInternal answerCallRequest) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return FluxUtil.withContext(context -> this.service.answerCall(this.getEndpoint(), this.getApiVersion(), answerCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CallConnectionPropertiesInternal>> answerCallWithResponseAsync(AnswerCallRequestInternal answerCallRequest, Context context) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return this.service.answerCall(this.getEndpoint(), this.getApiVersion(), answerCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> answerCallAsync(AnswerCallRequestInternal answerCallRequest) {
        return this.answerCallWithResponseAsync(answerCallRequest).flatMap(res -> Mono.justOrEmpty((Object)((CallConnectionPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CallConnectionPropertiesInternal> answerCallAsync(AnswerCallRequestInternal answerCallRequest, Context context) {
        return this.answerCallWithResponseAsync(answerCallRequest, context).flatMap(res -> Mono.justOrEmpty((Object)((CallConnectionPropertiesInternal)res.getValue())));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CallConnectionPropertiesInternal> answerCallWithResponse(AnswerCallRequestInternal answerCallRequest, Context context) {
        return (Response)this.answerCallWithResponseAsync(answerCallRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CallConnectionPropertiesInternal answerCall(AnswerCallRequestInternal answerCallRequest) {
        return (CallConnectionPropertiesInternal)this.answerCallWithResponse(answerCallRequest, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> redirectCallWithResponseAsync(RedirectCallRequestInternal redirectCallRequest) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return FluxUtil.withContext(context -> this.service.redirectCall(this.getEndpoint(), this.getApiVersion(), redirectCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> redirectCallWithResponseAsync(RedirectCallRequestInternal redirectCallRequest, Context context) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return this.service.redirectCall(this.getEndpoint(), this.getApiVersion(), redirectCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redirectCallAsync(RedirectCallRequestInternal redirectCallRequest) {
        return this.redirectCallWithResponseAsync(redirectCallRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> redirectCallAsync(RedirectCallRequestInternal redirectCallRequest, Context context) {
        return this.redirectCallWithResponseAsync(redirectCallRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> redirectCallWithResponse(RedirectCallRequestInternal redirectCallRequest, Context context) {
        return (Response)this.redirectCallWithResponseAsync(redirectCallRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void redirectCall(RedirectCallRequestInternal redirectCallRequest) {
        this.redirectCallWithResponse(redirectCallRequest, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rejectCallWithResponseAsync(RejectCallRequestInternal rejectCallRequest) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return FluxUtil.withContext(context -> this.service.rejectCall(this.getEndpoint(), this.getApiVersion(), rejectCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, (Context)context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> rejectCallWithResponseAsync(RejectCallRequestInternal rejectCallRequest, Context context) {
        String accept = "application/json";
        String repeatabilityRequestId = UUID.randomUUID().toString();
        String repeatabilityFirstSent = DateTimeRfc1123.toRfc1123String((OffsetDateTime)OffsetDateTime.now());
        return this.service.rejectCall(this.getEndpoint(), this.getApiVersion(), rejectCallRequest, "application/json", repeatabilityRequestId, repeatabilityFirstSent, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rejectCallAsync(RejectCallRequestInternal rejectCallRequest) {
        return this.rejectCallWithResponseAsync(rejectCallRequest).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> rejectCallAsync(RejectCallRequestInternal rejectCallRequest, Context context) {
        return this.rejectCallWithResponseAsync(rejectCallRequest, context).flatMap(ignored -> Mono.empty());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> rejectCallWithResponse(RejectCallRequestInternal rejectCallRequest, Context context) {
        return (Response)this.rejectCallWithResponseAsync(rejectCallRequest, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void rejectCall(RejectCallRequestInternal rejectCallRequest) {
        this.rejectCallWithResponse(rejectCallRequest, Context.NONE);
    }

    @Host(value="{endpoint}")
    @ServiceInterface(name="AzureCommunicationCa")
    public static interface AzureCommunicationCallAutomationServiceService {
        @Post(value="/calling/callConnections")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallConnectionPropertiesInternal>> createCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") CreateCallRequestInternal var3, @HeaderParam(value="Accept") String var4, @HeaderParam(value="repeatability-request-id") String var5, @HeaderParam(value="repeatability-first-sent") String var6, Context var7);

        @Post(value="/calling/callConnections:answer")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<CallConnectionPropertiesInternal>> answerCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") AnswerCallRequestInternal var3, @HeaderParam(value="Accept") String var4, @HeaderParam(value="repeatability-request-id") String var5, @HeaderParam(value="repeatability-first-sent") String var6, Context var7);

        @Post(value="/calling/callConnections:redirect")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> redirectCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RedirectCallRequestInternal var3, @HeaderParam(value="Accept") String var4, @HeaderParam(value="repeatability-request-id") String var5, @HeaderParam(value="repeatability-first-sent") String var6, Context var7);

        @Post(value="/calling/callConnections:reject")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=CommunicationErrorResponseException.class)
        public Mono<Response<Void>> rejectCall(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, @BodyParam(value="application/json") RejectCallRequestInternal var3, @HeaderParam(value="Accept") String var4, @HeaderParam(value="repeatability-request-id") String var5, @HeaderParam(value="repeatability-first-sent") String var6, Context var7);
    }
}

