/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.implementation.accesshelpers.CallConnectionPropertiesConstructorProxy;
import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.CommunicationUserIdentifierConverter;
import com.azure.communication.callautomation.implementation.converters.PhoneNumberIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CallConnectionPropertiesInternal;
import com.azure.communication.callautomation.models.CallConnectionState;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.communication.common.CommunicationUserIdentifier;
import com.azure.communication.common.PhoneNumberIdentifier;
import java.util.List;
import java.util.stream.Collectors;

public final class CallConnectionProperties {
    private final String callConnectionId;
    private final String serverCallId;
    private final CommunicationIdentifier source;
    private final PhoneNumberIdentifier sourceCallerIdNumber;
    private final String sourceDisplayName;
    private final List<CommunicationIdentifier> targetParticipants;
    private final CallConnectionState callConnectionState;
    private final String callbackUrl;
    private final CommunicationUserIdentifier answeredBy;
    private final String correlationId;

    public CallConnectionProperties() {
        this.callConnectionId = null;
        this.source = null;
        this.sourceCallerIdNumber = null;
        this.sourceDisplayName = null;
        this.serverCallId = null;
        this.targetParticipants = null;
        this.callConnectionState = null;
        this.callbackUrl = null;
        this.answeredBy = null;
        this.correlationId = null;
    }

    CallConnectionProperties(CallConnectionPropertiesInternal callConnectionPropertiesInternal) {
        this.callConnectionId = callConnectionPropertiesInternal.getCallConnectionId();
        this.source = CommunicationIdentifierConverter.convert(callConnectionPropertiesInternal.getSource());
        this.sourceCallerIdNumber = PhoneNumberIdentifierConverter.convert(callConnectionPropertiesInternal.getSourceCallerIdNumber());
        this.sourceDisplayName = callConnectionPropertiesInternal.getSourceDisplayName();
        this.serverCallId = callConnectionPropertiesInternal.getServerCallId();
        this.targetParticipants = callConnectionPropertiesInternal.getTargets().stream().map(CommunicationIdentifierConverter::convert).collect(Collectors.toList());
        this.callConnectionState = CallConnectionState.fromString(callConnectionPropertiesInternal.getCallConnectionState().toString());
        this.callbackUrl = callConnectionPropertiesInternal.getCallbackUri();
        this.answeredBy = CommunicationUserIdentifierConverter.convert(callConnectionPropertiesInternal.getAnsweredBy());
        this.correlationId = callConnectionPropertiesInternal.getCorrelationId();
    }

    public List<CommunicationIdentifier> getTargetParticipants() {
        return this.targetParticipants;
    }

    public CommunicationIdentifier getSource() {
        return this.source;
    }

    public PhoneNumberIdentifier getSourceCallerIdNumber() {
        return this.sourceCallerIdNumber;
    }

    public String getSourceDisplayName() {
        return this.sourceDisplayName;
    }

    public String getServerCallId() {
        return this.serverCallId;
    }

    public CallConnectionState getCallConnectionState() {
        return this.callConnectionState;
    }

    public String getCallbackUrl() {
        return this.callbackUrl;
    }

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    public CommunicationUserIdentifier getAnsweredBy() {
        return this.answeredBy;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    static {
        CallConnectionPropertiesConstructorProxy.setAccessor(new CallConnectionPropertiesConstructorProxy.CallConnectionPropertiesConstructorAccessor(){

            @Override
            public CallConnectionProperties create(CallConnectionPropertiesInternal internalHeaders) {
                return new CallConnectionProperties(internalHeaders);
            }
        });
    }
}

