/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.communication.callautomation.models.PlaySource;
import com.azure.communication.callautomation.models.RecognizeInputType;
import com.azure.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;

public abstract class CallMediaRecognizeOptions {
    @JsonProperty(value="recognizeInputType", required=true)
    private RecognizeInputType recognizeInputType;
    @JsonProperty(value="playPrompt")
    private PlaySource playPrompt;
    @JsonProperty(value="interruptCallMediaOperation")
    private Boolean interruptCallMediaOperation;
    @JsonProperty(value="stopCurrentOperations")
    private Boolean stopCurrentOperations;
    @JsonProperty(value="operationContext")
    private String operationContext;
    @JsonProperty(value="interruptPrompt")
    private Boolean interruptPrompt;
    @JsonProperty(value="initialSilenceTimeout")
    private Duration initialSilenceTimeout;
    @JsonProperty(value="speechModelEndpointId")
    private String speechModelEndpointId;
    @JsonProperty(value="targetParticipant")
    private CommunicationIdentifier targetParticipant;
    @JsonProperty(value="operationCallbackUrl")
    private String operationCallbackUrl;

    public CallMediaRecognizeOptions(RecognizeInputType recognizeInputType, CommunicationIdentifier targetParticipant) {
        this.recognizeInputType = recognizeInputType;
        this.targetParticipant = targetParticipant;
        this.initialSilenceTimeout = Duration.ofSeconds(5L);
    }

    public RecognizeInputType getRecognizeInputType() {
        return this.recognizeInputType;
    }

    public CallMediaRecognizeOptions setRecognizeInputType(RecognizeInputType recognizeInputType) {
        this.recognizeInputType = recognizeInputType;
        return this;
    }

    public PlaySource getPlayPrompt() {
        return this.playPrompt;
    }

    public CallMediaRecognizeOptions setPlayPrompt(PlaySource playPrompt) {
        this.playPrompt = playPrompt;
        return this;
    }

    public Boolean isInterruptCallMediaOperation() {
        return this.interruptCallMediaOperation;
    }

    public CallMediaRecognizeOptions setInterruptCallMediaOperation(Boolean interruptCallMediaOperation) {
        this.interruptCallMediaOperation = interruptCallMediaOperation;
        return this;
    }

    public Boolean isStopCurrentOperations() {
        return this.stopCurrentOperations;
    }

    public CallMediaRecognizeOptions setStopCurrentOperations(Boolean stopCurrentOperations) {
        this.stopCurrentOperations = stopCurrentOperations;
        return this;
    }

    public String getOperationContext() {
        return this.operationContext;
    }

    public CallMediaRecognizeOptions setOperationContext(String operationContext) {
        this.operationContext = operationContext;
        return this;
    }

    public Boolean isInterruptPrompt() {
        return this.interruptPrompt;
    }

    public CallMediaRecognizeOptions setInterruptPrompt(Boolean interruptPrompt) {
        this.interruptPrompt = interruptPrompt;
        return this;
    }

    public Duration getInitialSilenceTimeout() {
        return this.initialSilenceTimeout;
    }

    public CallMediaRecognizeOptions setInitialSilenceTimeout(Duration initialSilenceTimeout) {
        this.initialSilenceTimeout = initialSilenceTimeout;
        return this;
    }

    public CommunicationIdentifier getTargetParticipant() {
        return this.targetParticipant;
    }

    public String getOperationCallbackUrl() {
        return this.operationCallbackUrl;
    }

    public CallMediaRecognizeOptions setOperationCallbackUrl(String operationCallbackUrl) {
        this.operationCallbackUrl = operationCallbackUrl;
        return this;
    }
}

