/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models;

import com.azure.core.util.logging.ClientLogger;
import java.util.Map;

public final class CustomCallingContext {
    private final Map<String, String> sipHeaders;
    private final Map<String, String> voipHeaders;
    private final ClientLogger logger;

    CustomCallingContext(Map<String, String> sipHeaders, Map<String, String> voipHeaders) {
        this.sipHeaders = sipHeaders;
        this.voipHeaders = voipHeaders;
        this.logger = new ClientLogger(CustomCallingContext.class);
    }

    public Map<String, String> getSipHeaders() {
        return this.sipHeaders;
    }

    public Map<String, String> getVoipHeaders() {
        return this.voipHeaders;
    }

    public void addSipUui(String value) {
        if (this.sipHeaders == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add sip header, SipHeaders is null."));
        }
        this.sipHeaders.put("User-To-User", value);
    }

    public void addSipX(String key, String value) {
        if (this.sipHeaders == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add sip header, SipHeaders is null."));
        }
        this.sipHeaders.put("X-MS-Custom-" + key, value);
    }

    public void addVoip(String key, String value) {
        if (this.sipHeaders == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Cannot add sip header, VoipHeaders is null."));
        }
        this.voipHeaders.put(key, value);
    }
}

