/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callautomation.models.events;

import com.azure.communication.callautomation.implementation.converters.CommunicationIdentifierConverter;
import com.azure.communication.callautomation.implementation.models.CommunicationIdentifierModel;
import com.azure.communication.callautomation.models.events.CallAutomationEventBase;
import com.azure.communication.callautomation.models.events.ResultInformation;
import com.azure.communication.common.CommunicationIdentifier;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;

public final class CallTransferAccepted
extends CallAutomationEventBase {
    @JsonProperty(value="resultInformation")
    private final ResultInformation resultInformation = null;
    @JsonIgnore
    private final CommunicationIdentifier transferee;
    @JsonIgnore
    private final CommunicationIdentifier transferTarget;

    @JsonCreator
    private CallTransferAccepted(@JsonProperty(value="transferee") Map<String, Object> transferee, @JsonProperty(value="transferTarget") Map<String, Object> transferTarget) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.transferee = CommunicationIdentifierConverter.convert((CommunicationIdentifierModel)mapper.convertValue(transferee, CommunicationIdentifierModel.class));
        this.transferTarget = CommunicationIdentifierConverter.convert((CommunicationIdentifierModel)mapper.convertValue(transferTarget, CommunicationIdentifierModel.class));
    }

    public ResultInformation getResultInformation() {
        return this.resultInformation;
    }

    public CommunicationIdentifier getTransferee() {
        return this.transferee;
    }

    public CommunicationIdentifier getTransferTarget() {
        return this.transferTarget;
    }
}

