/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.CallConnectionAsync;
import com.azure.communication.callingserver.models.AddParticipantResult;
import com.azure.communication.callingserver.models.CancelAllMediaOperationsResult;
import com.azure.communication.callingserver.models.PlayAudioOptions;
import com.azure.communication.callingserver.models.PlayAudioResult;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;

public final class CallConnection {
    private final CallConnectionAsync callConnectionAsync;
    private final ClientLogger logger = new ClientLogger(CallConnection.class);

    CallConnection(CallConnectionAsync callConnectionAsync) {
        this.callConnectionAsync = callConnectionAsync;
    }

    public String getCallConnectionId() {
        return this.callConnectionAsync.getCallConnectionId();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlayAudioResult playAudio(String audioFileUri, boolean loop, String audioFileId, String callbackUri, String operationContext) {
        return (PlayAudioResult)this.callConnectionAsync.playAudioInternal(audioFileUri, loop, audioFileId, callbackUri, operationContext).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PlayAudioResult playAudio(String audioFileUri, PlayAudioOptions playAudioOptions) {
        return (PlayAudioResult)this.callConnectionAsync.playAudioInternal(audioFileUri, playAudioOptions).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<PlayAudioResult> playAudioWithResponse(String audioFileUri, PlayAudioOptions playAudioOptions, Context context) {
        return (Response)this.callConnectionAsync.playAudioWithResponseInternal(audioFileUri, playAudioOptions, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hangup() {
        this.callConnectionAsync.hangup().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> hangupWithResponse(Context context) {
        return (Response)this.callConnectionAsync.hangupWithResponse(context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CancelAllMediaOperationsResult cancelAllMediaOperations(String operationContext) {
        return (CancelAllMediaOperationsResult)this.callConnectionAsync.cancelAllMediaOperations(operationContext).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CancelAllMediaOperationsResult> cancelAllMediaOperationsWithResponse(String operationContext, Context context) {
        return (Response)this.callConnectionAsync.cancelAllMediaOperationsWithResponse(operationContext, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AddParticipantResult addParticipant(CommunicationIdentifier participant, String alternateCallerId, String operationContext) {
        return (AddParticipantResult)this.callConnectionAsync.addParticipant(participant, alternateCallerId, operationContext).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AddParticipantResult> addParticipantWithResponse(CommunicationIdentifier participant, String alternateCallerId, String operationContext, Context context) {
        return (Response)this.callConnectionAsync.addParticipantWithResponse(participant, alternateCallerId, operationContext, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void removeParticipant(String participantId) {
        this.callConnectionAsync.removeParticipant(participantId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> removeParticipantWithResponse(String participantId, Context context) {
        return (Response)this.callConnectionAsync.removeParticipantWithResponse(participantId, context).block();
    }
}

