/*
 * Decompiled with CFR 0.152.
 */
package com.azure.communication.callingserver;

import com.azure.communication.callingserver.implementation.CallConnectionsImpl;
import com.azure.communication.callingserver.implementation.converters.AddParticipantRequestConverter;
import com.azure.communication.callingserver.implementation.converters.CallingServerErrorConverter;
import com.azure.communication.callingserver.implementation.converters.CancelAllMediaOperationsResultConverter;
import com.azure.communication.callingserver.implementation.converters.PlayAudioResultConverter;
import com.azure.communication.callingserver.implementation.models.AddParticipantRequest;
import com.azure.communication.callingserver.implementation.models.AddParticipantResultInternal;
import com.azure.communication.callingserver.implementation.models.CancelAllMediaOperationsRequest;
import com.azure.communication.callingserver.implementation.models.CancelAllMediaOperationsResultInternal;
import com.azure.communication.callingserver.implementation.models.CommunicationErrorResponseException;
import com.azure.communication.callingserver.implementation.models.PlayAudioRequest;
import com.azure.communication.callingserver.implementation.models.PlayAudioResultInternal;
import com.azure.communication.callingserver.models.AddParticipantResult;
import com.azure.communication.callingserver.models.CancelAllMediaOperationsResult;
import com.azure.communication.callingserver.models.PlayAudioOptions;
import com.azure.communication.callingserver.models.PlayAudioResult;
import com.azure.communication.common.CommunicationIdentifier;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;
import reactor.core.publisher.Mono;

public final class CallConnectionAsync {
    private final String callConnectionId;
    private final CallConnectionsImpl callConnectionInternal;
    private final ClientLogger logger = new ClientLogger(CallConnectionAsync.class);

    CallConnectionAsync(String callConnectionId, CallConnectionsImpl callConnectionInternal) {
        this.callConnectionId = callConnectionId;
        this.callConnectionInternal = callConnectionInternal;
    }

    public String getCallConnectionId() {
        return this.callConnectionId;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResult> playAudio(String audioFileUri, boolean loop, String audioFileId, String callbackUri, String operationContext) {
        return this.playAudioInternal(audioFileUri, loop, audioFileId, callbackUri, operationContext);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<PlayAudioResult> playAudio(String audioFileUri, PlayAudioOptions playAudioOptions) {
        return this.playAudioInternal(audioFileUri, playAudioOptions);
    }

    Mono<PlayAudioResult> playAudioInternal(String audioFileUri, boolean loop, String audioFileId, String callbackUri, String operationContext) {
        try {
            Objects.requireNonNull(audioFileUri, "'audioFileUri' cannot be null.");
            PlayAudioRequest playAudioRequest = new PlayAudioRequest().setAudioFileUri(audioFileUri).setLoop(loop).setAudioFileId(audioFileId).setOperationContext(operationContext).setCallbackUri(callbackUri);
            return this.playAudioInternal(playAudioRequest);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PlayAudioResult> playAudioInternal(String audioFileUri, PlayAudioOptions playAudioOptions) {
        try {
            Objects.requireNonNull(audioFileUri, "'audioFileUri' cannot be null.");
            PlayAudioRequest request = new PlayAudioRequest().setAudioFileUri(audioFileUri);
            if (playAudioOptions != null) {
                request.setLoop(playAudioOptions.isLoop()).setOperationContext(playAudioOptions.getOperationContext()).setAudioFileId(playAudioOptions.getAudioFileId()).setCallbackUri(playAudioOptions.getCallbackUri());
            }
            return this.playAudioInternal(request);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<PlayAudioResult> playAudioInternal(PlayAudioRequest playAudioRequest) {
        try {
            return this.callConnectionInternal.playAudioAsync(this.callConnectionId, playAudioRequest).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)PlayAudioResultConverter.convert(result)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<PlayAudioResult>> playAudioWithResponse(String audioFileUri, PlayAudioOptions playAudioOptions) {
        return this.playAudioWithResponseInternal(audioFileUri, playAudioOptions, null);
    }

    Mono<Response<PlayAudioResult>> playAudioWithResponseInternal(String audioFileUri, PlayAudioOptions playAudioOptions, Context context) {
        try {
            Objects.requireNonNull(audioFileUri, "'audioFileUri' cannot be null.");
            PlayAudioRequest request = new PlayAudioRequest().setAudioFileUri(audioFileUri);
            if (playAudioOptions != null) {
                request.setLoop(playAudioOptions.isLoop()).setOperationContext(playAudioOptions.getOperationContext()).setAudioFileId(playAudioOptions.getAudioFileId()).setCallbackUri(playAudioOptions.getCallbackUri());
            }
            return this.playAudioWithResponseInternal(request, context);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    Mono<Response<PlayAudioResult>> playAudioWithResponseInternal(PlayAudioRequest playAudioRequest, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callConnectionInternal.playAudioWithResponseAsync(this.callConnectionId, playAudioRequest, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)PlayAudioResultConverter.convert((PlayAudioResultInternal)response.getValue())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hangup() {
        try {
            return this.callConnectionInternal.hangupCallAsync(this.callConnectionId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> hangupWithResponse() {
        return this.hangupWithResponse(null);
    }

    Mono<Response<Void>> hangupWithResponse(Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callConnectionInternal.hangupCallWithResponseAsync(this.callConnectionId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CancelAllMediaOperationsResult> cancelAllMediaOperations(String operationContext) {
        try {
            CancelAllMediaOperationsRequest request = new CancelAllMediaOperationsRequest();
            request.setOperationContext(operationContext);
            return this.callConnectionInternal.cancelAllMediaOperationsAsync(this.callConnectionId, request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)CancelAllMediaOperationsResultConverter.convert(result)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CancelAllMediaOperationsResult>> cancelAllMediaOperationsWithResponse(String operationContext) {
        return this.cancelAllMediaOperationsWithResponse(operationContext, null);
    }

    Mono<Response<CancelAllMediaOperationsResult>> cancelAllMediaOperationsWithResponse(String operationContext, Context context) {
        try {
            CancelAllMediaOperationsRequest request = new CancelAllMediaOperationsRequest();
            request.setOperationContext(operationContext);
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callConnectionInternal.cancelAllMediaOperationsWithResponseAsync(this.callConnectionId, request, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)CancelAllMediaOperationsResultConverter.convert((CancelAllMediaOperationsResultInternal)response.getValue())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<AddParticipantResult> addParticipant(CommunicationIdentifier participant, String alternateCallerId, String operationContext) {
        try {
            Objects.requireNonNull(participant, "'participant' cannot be null.");
            AddParticipantRequest request = AddParticipantRequestConverter.convert(participant, alternateCallerId, operationContext, null);
            return this.callConnectionInternal.addParticipantAsync(this.callConnectionId, request).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.just((Object)new AddParticipantResult(result.getParticipantId())));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<AddParticipantResult>> addParticipantWithResponse(CommunicationIdentifier participant, String alternateCallerId, String operationContext) {
        return this.addParticipantWithResponse(participant, alternateCallerId, operationContext, null);
    }

    Mono<Response<AddParticipantResult>> addParticipantWithResponse(CommunicationIdentifier participant, String alternateCallerId, String operationContext, Context context) {
        try {
            Objects.requireNonNull(participant, "'participant' cannot be null.");
            AddParticipantRequest request = AddParticipantRequestConverter.convert(participant, alternateCallerId, operationContext, null);
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callConnectionInternal.addParticipantWithResponseAsync(this.callConnectionId, request, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).map(response -> new SimpleResponse(response, (Object)new AddParticipantResult(((AddParticipantResultInternal)response.getValue()).getParticipantId())));
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> removeParticipant(String participantId) {
        try {
            return this.callConnectionInternal.removeParticipantAsync(this.callConnectionId, participantId).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException).flatMap(result -> Mono.empty());
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> removeParticipantWithResponse(String participantId) {
        return this.removeParticipantWithResponse(participantId, null);
    }

    Mono<Response<Void>> removeParticipantWithResponse(String participantId, Context context) {
        try {
            return FluxUtil.withContext(contextValue -> {
                contextValue = context == null ? contextValue : context;
                return this.callConnectionInternal.removeParticipantWithResponseAsync(this.callConnectionId, participantId, (Context)contextValue).onErrorMap(CommunicationErrorResponseException.class, CallingServerErrorConverter::translateException);
            });
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)this.logger, (RuntimeException)ex);
        }
    }
}

